/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.lifecycle;

import jakarta.faces.FacesException;
import jakarta.faces.application.Application;
import jakarta.faces.application.FacesMessage;
import jakarta.faces.application.ProjectStage;
import jakarta.faces.application.ViewHandler;
import jakarta.faces.component.UIViewRoot;
import jakarta.faces.context.ExternalContext;
import jakarta.faces.context.FacesContext;
import jakarta.faces.event.PhaseId;
import jakarta.faces.event.PostRenderViewEvent;
import jakarta.faces.event.PreRenderViewEvent;
import jakarta.faces.view.ViewDeclarationLanguage;
import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.myfaces.config.MyfacesConfig;
import org.apache.myfaces.lifecycle.PhaseExecutor;
import org.apache.myfaces.lifecycle.ViewNotFoundException;

class RenderResponseExecutor
extends PhaseExecutor {
    private static final Logger log = Logger.getLogger(RenderResponseExecutor.class.getName());

    RenderResponseExecutor() {
    }

    @Override
    public boolean execute(FacesContext facesContext) {
        Application application = facesContext.getApplication();
        ViewHandler viewHandler = application.getViewHandler();
        int loops = 0;
        int maxLoops = 15;
        if (facesContext.getViewRoot() == null) {
            throw new ViewNotFoundException("A view is required to execute " + facesContext.getCurrentPhaseId());
        }
        this.forceSessionCreation(facesContext);
        try {
            UIViewRoot root;
            boolean isNotSameRoot;
            String viewId;
            String newViewId;
            do {
                UIViewRoot previousRoot = root = facesContext.getViewRoot();
                viewId = root.getViewId();
                ViewDeclarationLanguage vdl = viewHandler.getViewDeclarationLanguage(facesContext, viewId);
                if (vdl != null) {
                    vdl.buildView(facesContext, root);
                }
                application.publishEvent(facesContext, PreRenderViewEvent.class, (Object)root);
                if (facesContext.getResponseComplete()) {
                    return false;
                }
                root = facesContext.getViewRoot();
                newViewId = root.getViewId();
                boolean bl = isNotSameRoot = !(newViewId == null ? newViewId == viewId : newViewId.equals(viewId)) || !previousRoot.equals(root);
            } while (newViewId == null && viewId != null || newViewId != null && (!newViewId.equals(viewId) || isNotSameRoot) && ++loops < maxLoops);
            if (loops == maxLoops) {
                Level level;
                Level level2 = level = facesContext.isProjectStage(ProjectStage.Production) ? Level.FINE : Level.WARNING;
                if (log.isLoggable(level)) {
                    log.log(level, "Cicle over buildView-PreRenderViewEvent on RENDER_RESPONSE phase reaches maximal limit, please check listeners for infinite recursion.");
                }
            }
            viewHandler.renderView(facesContext, root);
            application.publishEvent(facesContext, PostRenderViewEvent.class, (Object)root);
            List messageList = facesContext.getMessageList();
            if (!messageList.isEmpty()) {
                StringBuilder builder = new StringBuilder();
                boolean shouldLog = false;
                int size = messageList.size();
                for (int i = 0; i < size; ++i) {
                    FacesMessage message = (FacesMessage)messageList.get(i);
                    if (message.isRendered()) continue;
                    builder.append("\n- ");
                    builder.append(message.getDetail());
                    shouldLog = true;
                }
                if (shouldLog) {
                    log.log(Level.WARNING, "There are some unhandled FacesMessages, this means not every FacesMessage had a chance to be rendered.\nThese unhandled FacesMessages are: " + builder.toString());
                }
            }
        }
        catch (IOException e) {
            throw new FacesException(e.getMessage(), (Throwable)e);
        }
        return false;
    }

    @Override
    public PhaseId getPhase() {
        return PhaseId.RENDER_RESPONSE;
    }

    private void forceSessionCreation(FacesContext context) {
        ExternalContext ec;
        if (context.getExternalContext().getSession(false) == null && (MyfacesConfig.getCurrentInstance(ec = context.getExternalContext()).isAlwaysForceSessionCreation() || !context.getViewRoot().isTransient() && !context.getApplication().getStateManager().isSavingStateInClient(context))) {
            context.getExternalContext().getSession(true);
        }
    }
}

