/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.core.api.shared.lang;

import jakarta.faces.FacesWrapper;
import java.beans.PropertyDescriptor;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.lang.reflect.Method;

public class PropertyDescriptorWrapper
implements FacesWrapper<PropertyDescriptor> {
    private final PropertyDescriptor wrapped;
    private Reference<Method> readMethodRef;
    private Reference<Method> writeMethodRef;

    public PropertyDescriptorWrapper(Class<?> beanClass, PropertyDescriptor wrapped) {
        this.wrapped = wrapped;
        this.readMethodRef = new SoftReference<Method>(wrapped.getReadMethod());
    }

    public PropertyDescriptorWrapper(Class<?> beanClass, PropertyDescriptor wrapped, Method readMethod) {
        this.wrapped = wrapped;
        this.readMethodRef = new SoftReference<Method>(readMethod);
    }

    public Class<?> getPropertyType() {
        return this.wrapped.getPropertyType();
    }

    public String getName() {
        return this.wrapped.getName();
    }

    @Override
    public PropertyDescriptor getWrapped() {
        return this.wrapped;
    }

    public Method getReadMethod() {
        Method readMethod = this.readMethodRef.get();
        if (readMethod == null) {
            readMethod = this.wrapped.getReadMethod();
            this.readMethodRef = new SoftReference<Method>(readMethod);
        }
        return readMethod;
    }

    public Method getWriteMethod() {
        if (this.writeMethodRef == null || this.writeMethodRef.get() == null) {
            Method writeMethod = this.wrapped.getWriteMethod();
            this.writeMethodRef = new SoftReference<Method>(writeMethod);
        }
        return this.writeMethodRef.get();
    }
}

