/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.push;

import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.faces.FacesWrapper;
import jakarta.faces.component.UIComponent;
import jakarta.faces.component.UIWebsocket;
import jakarta.faces.component.behavior.ClientBehavior;
import jakarta.faces.component.behavior.ClientBehaviorContext;
import jakarta.faces.context.FacesContext;
import jakarta.faces.context.ResponseWriter;
import jakarta.faces.event.ComponentSystemEvent;
import jakarta.faces.event.ComponentSystemEventListener;
import jakarta.faces.event.ListenerFor;
import jakarta.faces.event.PostAddToViewEvent;
import jakarta.faces.render.Renderer;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.myfaces.cdi.util.CDIUtils;
import org.apache.myfaces.push.HtmlBufferResponseWriterWrapper;
import org.apache.myfaces.push.WebsocketInit;
import org.apache.myfaces.push._WebsocketInit;
import org.apache.myfaces.push.cdi.WebsocketChannelMetadata;
import org.apache.myfaces.push.cdi.WebsocketChannelTokenBuilder;
import org.apache.myfaces.push.cdi.WebsocketScopeManager;
import org.apache.myfaces.push.cdi.WebsocketSessionManager;
import org.apache.myfaces.renderkit.html.util.ClientBehaviorRendererUtils;
import org.apache.myfaces.renderkit.html.util.HtmlRendererUtils;
import org.apache.myfaces.renderkit.html.util.ResourceUtils;

@ListenerFor(systemEventClass=PostAddToViewEvent.class)
public class WebsocketComponentRenderer
extends Renderer
implements ComponentSystemEventListener {
    private static final Logger LOG = Logger.getLogger(WebsocketComponentRenderer.class.getName());

    @Override
    public void processEvent(ComponentSystemEvent event) {
        if (event instanceof PostAddToViewEvent) {
            FacesContext facesContext = FacesContext.getCurrentInstance();
            UIWebsocket component = (UIWebsocket)event.getComponent();
            WebsocketInit initComponent = (WebsocketInit)facesContext.getViewRoot().findComponent((String)component.getAttributes().get(_WebsocketInit.ATTRIBUTE_COMPONENT_ID));
            if (initComponent == null) {
                initComponent = (WebsocketInit)facesContext.getApplication().createComponent(facesContext, "org.apache.myfaces.WebsocketInit", "org.apache.myfaces.WebsocketInit");
                initComponent.setId((String)component.getAttributes().get(_WebsocketInit.ATTRIBUTE_COMPONENT_ID));
                facesContext.getViewRoot().addComponentResource(facesContext, initComponent, "body");
            }
        }
    }

    private HtmlBufferResponseWriterWrapper getResponseWriter(FacesContext context) {
        return HtmlBufferResponseWriterWrapper.getInstance(context.getResponseWriter());
    }

    public void decode(FacesContext facesContext, UIComponent component) {
        ClientBehaviorRendererUtils.decodeClientBehaviors(facesContext, component);
    }

    public void encodeBegin(FacesContext facesContext, UIComponent component) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        ResourceUtils.renderDefaultJsfJsInlineIfNecessary(facesContext, writer);
        writer.startElement("div", component);
        writer.writeAttribute("id", component.getClientId(), null);
        writer.writeAttribute("style", "display:none", null);
        writer.endElement("div");
        if (!facesContext.getPartialViewContext().isAjaxRequest()) {
            facesContext.setResponseWriter(this.getResponseWriter(facesContext));
        }
    }

    public void encodeEnd(FacesContext facesContext, UIComponent c) throws IOException {
        super.encodeEnd(facesContext, c);
        UIWebsocket component = (UIWebsocket)c;
        WebsocketInit init = (WebsocketInit)facesContext.getViewRoot().findComponent((String)component.getAttributes().get(_WebsocketInit.ATTRIBUTE_COMPONENT_ID));
        ResponseWriter writer = facesContext.getResponseWriter();
        String channel = component.getChannel();
        BeanManager beanManager = CDIUtils.getBeanManager(facesContext);
        WebsocketChannelTokenBuilder channelTokenBuilder = CDIUtils.get(beanManager, WebsocketChannelTokenBuilder.class);
        String scope = component.getScope();
        if (scope == null) {
            scope = component.getUser() == null ? "application" : "session";
        }
        WebsocketChannelMetadata metadata = new WebsocketChannelMetadata(channel, scope, component.getUser(), component.isConnected());
        WebsocketScopeManager scopeManager = CDIUtils.get(beanManager, WebsocketScopeManager.class);
        String channelToken = null;
        if (scopeManager.getScope(scope, true).isChannelAvailable(channel)) {
            List<String> channelTokenList;
            if (component.getUser() == null) {
                channelTokenList = scopeManager.getScope(scope, true).getChannelTokens(channel);
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.log(Level.FINE, "WebsocketComponentRenderer.encodeEnd: for channel = {0} found : ", channel);
                    channelTokenList.forEach(p -> LOG.log(Level.FINE, "  {0}", p));
                }
                if (channelTokenList.size() == 1) {
                    channelToken = channelTokenList.get(0);
                }
            } else {
                channelTokenList = scopeManager.getScope(scope, true).getChannelTokens(channel, component.getUser());
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.log(Level.FINE, "WebsocketComponentRenderer.encodeEnd: for channel = {0}, user = {1} found : ", new Object[]{channel, component.getUser()});
                    channelTokenList.forEach(p -> LOG.log(Level.FINE, "  {0}", p));
                }
                if (channelTokenList.size() == 1) {
                    channelToken = channelTokenList.get(0);
                }
            }
        }
        if (!component.isConnected()) {
            channelToken = scopeManager.getViewScope(true).getChannelToken(metadata);
        }
        if (channelToken == null) {
            channelToken = channelTokenBuilder.createChannelToken(facesContext, channel);
            scopeManager.getScope(scope, true).registerWebsocketSession(channelToken, metadata);
        }
        scopeManager.getViewScope(true).registerToken(channelToken, metadata);
        scopeManager.getSessionScope(true).registerToken(channelToken, metadata);
        WebsocketSessionManager sessionManager = CDIUtils.get(beanManager, WebsocketSessionManager.class);
        sessionManager.registerSessionToken(channelToken);
        writer.startElement("script", component);
        HtmlRendererUtils.renderScriptType(facesContext, writer);
        StringBuilder sb = new StringBuilder(50);
        sb.append("faces.push.init(");
        sb.append('\'');
        sb.append(component.getClientId());
        sb.append('\'');
        sb.append(',');
        sb.append('\'');
        sb.append(facesContext.getExternalContext().encodeWebsocketURL(facesContext.getApplication().getViewHandler().getWebsocketURL(facesContext, component.getChannel() + "?" + channelToken)));
        sb.append('\'');
        sb.append(',');
        sb.append('\'');
        sb.append(component.getChannel());
        sb.append('\'');
        sb.append(',');
        sb.append(component.getOnopen());
        sb.append(',');
        sb.append(component.getOnmessage());
        sb.append(',');
        sb.append(component.getOnerror());
        sb.append(',');
        sb.append(component.getOnclose());
        sb.append(',');
        sb.append(this.getBehaviorScripts(facesContext, component));
        sb.append(',');
        sb.append(component.isConnected());
        sb.append(");");
        writer.write(sb.toString());
        writer.endElement("script");
        if (!facesContext.getPartialViewContext().isAjaxRequest()) {
            ResponseWriter responseWriter = facesContext.getResponseWriter();
            while (!(responseWriter instanceof HtmlBufferResponseWriterWrapper) && responseWriter instanceof FacesWrapper) {
                responseWriter = (ResponseWriter)((FacesWrapper)((Object)responseWriter)).getWrapped();
            }
            HtmlBufferResponseWriterWrapper htmlBufferResponseWritter = (HtmlBufferResponseWriterWrapper)responseWriter;
            init.getUIWebsocketMarkupList().add(htmlBufferResponseWritter.toString());
            facesContext.setResponseWriter(htmlBufferResponseWritter.getInitialWriter());
        }
    }

    private String getBehaviorScripts(FacesContext facesContext, UIWebsocket component) {
        Map<String, List<ClientBehavior>> clientBehaviorsByEvent = component.getClientBehaviors();
        if (clientBehaviorsByEvent.isEmpty()) {
            return "{}";
        }
        String clientId = component.getClientId(facesContext);
        StringBuilder scripts = new StringBuilder("{");
        for (Map.Entry<String, List<ClientBehavior>> entry : clientBehaviorsByEvent.entrySet()) {
            String event = entry.getKey();
            List<ClientBehavior> clientBehaviors = entry.getValue();
            scripts.append(scripts.length() > 1 ? Character.valueOf(',') : "").append(event).append(":[");
            for (int i = 0; i < clientBehaviors.size(); ++i) {
                scripts.append(i > 0 ? Character.valueOf(',') : "").append("function(event){");
                scripts.append(clientBehaviors.get(i).getScript(ClientBehaviorContext.createClientBehaviorContext(facesContext, component, event, clientId, null)));
                scripts.append('}');
            }
            scripts.append(']');
        }
        return scripts.append('}').toString();
    }
}

