/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.application;

import jakarta.el.CompositeELResolver;
import jakarta.el.ELContext;
import jakarta.el.ELContextListener;
import jakarta.el.ELException;
import jakarta.el.ELResolver;
import jakarta.el.ExpressionFactory;
import jakarta.el.ValueExpression;
import jakarta.faces.FacesException;
import jakarta.faces.FacesWrapper;
import jakarta.faces.application.Application;
import jakarta.faces.application.NavigationHandler;
import jakarta.faces.application.ProjectStage;
import jakarta.faces.application.Resource;
import jakarta.faces.application.ResourceDependencies;
import jakarta.faces.application.ResourceDependency;
import jakarta.faces.application.ResourceHandler;
import jakarta.faces.application.StateManager;
import jakarta.faces.application.ViewHandler;
import jakarta.faces.component.UIComponent;
import jakarta.faces.component.UIComponentBase;
import jakarta.faces.component.UIOutput;
import jakarta.faces.component.UIViewRoot;
import jakarta.faces.component.behavior.Behavior;
import jakarta.faces.component.behavior.ClientBehavior;
import jakarta.faces.component.behavior.ClientBehaviorBase;
import jakarta.faces.component.behavior.FacesBehavior;
import jakarta.faces.component.search.SearchExpressionHandler;
import jakarta.faces.component.search.SearchKeywordResolver;
import jakarta.faces.context.ExternalContext;
import jakarta.faces.context.FacesContext;
import jakarta.faces.convert.Converter;
import jakarta.faces.convert.DateTimeConverter;
import jakarta.faces.convert.FacesConverter;
import jakarta.faces.event.ActionListener;
import jakarta.faces.event.ComponentSystemEventListener;
import jakarta.faces.event.ListenerFor;
import jakarta.faces.event.ListenersFor;
import jakarta.faces.event.SystemEvent;
import jakarta.faces.event.SystemEventListener;
import jakarta.faces.flow.FlowHandler;
import jakarta.faces.render.ClientBehaviorRenderer;
import jakarta.faces.render.RenderKit;
import jakarta.faces.render.Renderer;
import jakarta.faces.render.RendererWrapper;
import jakarta.faces.validator.FacesValidator;
import jakarta.faces.validator.Validator;
import jakarta.faces.view.ViewDeclarationLanguage;
import java.beans.BeanDescriptor;
import java.beans.BeanInfo;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.myfaces.application.ActionListenerImpl;
import org.apache.myfaces.application.ApplicationImplEventManager;
import org.apache.myfaces.application.NavigationHandlerImpl;
import org.apache.myfaces.application.ResourceHandlerImpl;
import org.apache.myfaces.application.StateManagerImpl;
import org.apache.myfaces.application.ViewHandlerImpl;
import org.apache.myfaces.cdi.wrapper.FacesBehaviorCDIWrapper;
import org.apache.myfaces.cdi.wrapper.FacesClientBehaviorCDIWrapper;
import org.apache.myfaces.cdi.wrapper.FacesConverterCDIWrapper;
import org.apache.myfaces.cdi.wrapper.FacesValidatorCDIWrapper;
import org.apache.myfaces.component.search.AllSearchKeywordResolver;
import org.apache.myfaces.component.search.ChildSearchKeywordResolver;
import org.apache.myfaces.component.search.CompositeComponentParentSearchKeywordResolver;
import org.apache.myfaces.component.search.CompositeSearchKeywordResolver;
import org.apache.myfaces.component.search.FormSearchKeywordResolver;
import org.apache.myfaces.component.search.IdSearchKeywordResolver;
import org.apache.myfaces.component.search.NamingContainerSearchKeywordResolver;
import org.apache.myfaces.component.search.NextSearchKeywordResolver;
import org.apache.myfaces.component.search.NoneSearchKeywordResolver;
import org.apache.myfaces.component.search.ParentSearchKeywordResolver;
import org.apache.myfaces.component.search.PreviousSearchKeywordResolver;
import org.apache.myfaces.component.search.RootSearchKeywordResolver;
import org.apache.myfaces.component.search.SearchExpressionHandlerImpl;
import org.apache.myfaces.component.search.ThisSearchKeywordResolver;
import org.apache.myfaces.config.RuntimeConfig;
import org.apache.myfaces.config.element.Property;
import org.apache.myfaces.config.element.ResourceBundle;
import org.apache.myfaces.config.webparameters.MyfacesConfig;
import org.apache.myfaces.context.RequestViewContext;
import org.apache.myfaces.core.api.shared.lang.Assert;
import org.apache.myfaces.core.api.shared.lang.LambdaPropertyDescriptor;
import org.apache.myfaces.core.api.shared.lang.PropertyDescriptorUtils;
import org.apache.myfaces.core.api.shared.lang.PropertyDescriptorWrapper;
import org.apache.myfaces.el.DefaultELResolverBuilder;
import org.apache.myfaces.flow.FlowHandlerImpl;
import org.apache.myfaces.util.lang.ClassUtils;
import org.apache.myfaces.util.lang.Lazy;
import org.apache.myfaces.util.lang.StringUtils;
import org.apache.myfaces.view.facelets.FaceletCompositionContext;
import org.apache.myfaces.view.facelets.el.ELText;

public class ApplicationImpl
extends Application {
    private static final Logger log = Logger.getLogger(ApplicationImpl.class.getName());
    public static final String PROJECT_STAGE_SYSTEM_PROPERTY_NAME = "faces.PROJECT_STAGE";
    private static final String RESOURCE_DEPENDENCY_UNIQUE_ID_KEY = "oam.view.resourceDependencyUniqueId";
    private Collection<Locale> _supportedLocales = Collections.emptySet();
    private Locale _defaultLocale;
    private String _messageBundle;
    private ViewHandler _viewHandler;
    private NavigationHandler _navigationHandler;
    private ActionListener _actionListener;
    private String _defaultRenderKitId;
    private ResourceHandler _resourceHandler;
    private StateManager _stateManager;
    private FlowHandler _flowHandler;
    private ArrayList<ELContextListener> _elContextListeners;
    private final Map<String, Object> _converterIdToClassMap = new ConcurrentHashMap<String, Object>();
    private final Map<Class<?>, Object> _converterTargetClassToConverterClassMap = new ConcurrentHashMap();
    private final Map<String, Object> _componentClassMap = new ConcurrentHashMap<String, Object>();
    private final Map<String, Object> _validatorClassMap = new ConcurrentHashMap<String, Object>();
    private ApplicationImplEventManager _eventManager;
    private final Map<String, String> _defaultValidatorsIds = new HashMap<String, String>();
    private volatile Map<String, String> _cachedDefaultValidatorsIds = null;
    private final Map<String, Object> _behaviorClassMap = new ConcurrentHashMap<String, Object>();
    private final RuntimeConfig _runtimeConfig;
    private final MyfacesConfig _myfacesConfig;
    private Lazy<ELResolver> elResolver;
    private ProjectStage _projectStage;
    private volatile boolean _firstRequestProcessed = false;
    private final Map<Class<?>, List<ListenerFor>> _classToListenerForMap = new ConcurrentHashMap();
    private final Map<Class<?>, List<ResourceDependency>> _classToResourceDependencyMap = new ConcurrentHashMap();
    private List<Class<? extends Converter>> _noArgConstructorConverterClasses = new CopyOnWriteArrayList<Class<? extends Converter>>();
    private Map<Class<? extends Converter>, Boolean> _cdiManagedConverterMap = new ConcurrentHashMap<Class<? extends Converter>, Boolean>();
    private Map<Class<? extends Validator>, Boolean> _cdiManagedValidatorMap = new ConcurrentHashMap<Class<? extends Validator>, Boolean>();
    private Map<Class<? extends Behavior>, Boolean> _cdiManagedBehaviorMap = new ConcurrentHashMap<Class<? extends Behavior>, Boolean>();
    private boolean _dateTimeConverterDefaultTimeZoneIsSystemTimeZone = false;
    private SearchExpressionHandler _searchExpressionHandler;
    private SearchKeywordResolver _searchExpressionResolver;
    private static final UIComponent NOTHING = new UIComponentBase(){

        public String getFamily() {
            return null;
        }
    };

    public ApplicationImpl() {
        this(RuntimeConfig.getCurrentInstance(FacesContext.getCurrentInstance()));
    }

    ApplicationImpl(RuntimeConfig runtimeConfig) {
        String configParam;
        if (runtimeConfig == null) {
            throw new IllegalArgumentException("runtimeConfig must mot be null");
        }
        this._viewHandler = new ViewHandlerImpl();
        this._navigationHandler = new NavigationHandlerImpl();
        this._actionListener = new ActionListenerImpl();
        this._defaultRenderKitId = "HTML_BASIC";
        this._stateManager = new StateManagerImpl();
        this._elContextListeners = new ArrayList();
        this._resourceHandler = new ResourceHandlerImpl();
        this._flowHandler = new FlowHandlerImpl();
        this._searchExpressionHandler = new SearchExpressionHandlerImpl();
        this._runtimeConfig = runtimeConfig;
        this._myfacesConfig = MyfacesConfig.getCurrentInstance(this.getFacesContext());
        this._eventManager = new ApplicationImplEventManager();
        if (log.isLoggable(Level.FINEST)) {
            log.finest("New Application instance created");
        }
        if ((configParam = this.getFacesContext().getExternalContext().getInitParameter("jakarta.faces.DATETIMECONVERTER_DEFAULT_TIMEZONE_IS_SYSTEM_TIMEZONE")) != null && configParam.toLowerCase().equals("true")) {
            this._dateTimeConverterDefaultTimeZoneIsSystemTimeZone = true;
        }
        this.elResolver = new Lazy<ELResolver>(() -> {
            CompositeELResolver celr = new CompositeELResolver();
            new DefaultELResolverBuilder(this._runtimeConfig, this._myfacesConfig).build(this.getFacesContext(), celr);
            return celr;
        });
    }

    public final void addELResolver(ELResolver resolver) {
        if (this.isFirstRequestProcessed()) {
            throw new IllegalStateException("It is illegal to add a resolver after the first request is processed");
        }
        if (resolver != null) {
            this._runtimeConfig.addApplicationElResolver(resolver);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDefaultValidatorId(String validatorId) {
        if (this._validatorClassMap.containsKey(validatorId)) {
            Class validatorClass = this.getObjectFromClassMap(validatorId, this._validatorClassMap);
            Map<String, String> map = this._defaultValidatorsIds;
            synchronized (map) {
                this._defaultValidatorsIds.put(validatorId, validatorClass.getName());
                this._cachedDefaultValidatorsIds = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getDefaultValidatorInfo() {
        Map<String, String> cachedMap = this._cachedDefaultValidatorsIds;
        if (cachedMap == null) {
            Map<String, String> map = this._defaultValidatorsIds;
            synchronized (map) {
                if (this._cachedDefaultValidatorsIds == null) {
                    this._cachedDefaultValidatorsIds = Collections.unmodifiableMap(this._defaultValidatorsIds);
                }
                cachedMap = this._cachedDefaultValidatorsIds;
            }
        }
        return cachedMap;
    }

    public final ELResolver getELResolver() {
        return this.elResolver.get();
    }

    public final java.util.ResourceBundle getResourceBundle(FacesContext facesContext, String name) throws FacesException, NullPointerException {
        Assert.notNull((Object)facesContext, (String)"facesContext");
        Assert.notNull((Object)name, (String)"name");
        String bundleName = this.getBundleName(facesContext, name);
        if (bundleName == null) {
            return null;
        }
        Locale locale = Locale.getDefault();
        UIViewRoot viewRoot = facesContext.getViewRoot();
        if (viewRoot != null && viewRoot.getLocale() != null) {
            locale = viewRoot.getLocale();
        }
        try {
            return this.getResourceBundle(bundleName, locale, ClassUtils.getContextClassLoader());
        }
        catch (MissingResourceException e) {
            try {
                return this.getResourceBundle(bundleName, locale, ((Object)((Object)this)).getClass().getClassLoader());
            }
            catch (MissingResourceException e1) {
                throw new FacesException("Could not load resource bundle for name '" + name + "': " + e.getMessage(), (Throwable)e1);
            }
        }
    }

    String getBundleName(FacesContext facesContext, String name) {
        ResourceBundle bundle = this._runtimeConfig.getResourceBundle(name);
        return bundle != null ? bundle.getBaseName() : null;
    }

    java.util.ResourceBundle getResourceBundle(String name, Locale locale, ClassLoader loader) throws MissingResourceException {
        if (this._myfacesConfig.getResourceBundleControl() != null) {
            return java.util.ResourceBundle.getBundle(name, locale, loader, this._myfacesConfig.getResourceBundleControl());
        }
        return java.util.ResourceBundle.getBundle(name, locale, loader);
    }

    final FacesContext getFacesContext() {
        return FacesContext.getCurrentInstance();
    }

    public final UIComponent createComponent(ValueExpression componentExpression, FacesContext facesContext, String componentType) throws FacesException, NullPointerException {
        Assert.notNull((Object)componentExpression, (String)"componentExpression");
        Assert.notNull((Object)facesContext, (String)"facesContext");
        Assert.notNull((Object)componentType, (String)"componentType");
        ELContext elContext = facesContext.getELContext();
        try {
            UIComponent createdComponent;
            Object retVal = componentExpression.getValue(elContext);
            if (retVal instanceof UIComponent) {
                createdComponent = (UIComponent)retVal;
                this._handleAnnotations(facesContext, createdComponent, createdComponent);
            } else {
                createdComponent = this.createComponent(facesContext, componentType);
                componentExpression.setValue(elContext, (Object)createdComponent);
            }
            return createdComponent;
        }
        catch (FacesException e) {
            throw e;
        }
        catch (Exception e) {
            throw new FacesException((Throwable)e);
        }
    }

    public UIComponent createComponent(ValueExpression componentExpression, FacesContext context, String componentType, String rendererType) {
        UIComponent component = this.createComponent(componentExpression, context, componentType);
        if (rendererType != null) {
            this._inspectRenderer(context, component, componentType, rendererType);
        }
        return component;
    }

    public final ExpressionFactory getExpressionFactory() {
        return this._runtimeConfig.getExpressionFactory();
    }

    public final <T> T evaluateExpressionGet(FacesContext context, String expression, Class<? extends T> expectedType) throws ELException {
        ELContext elContext = context.getELContext();
        ExpressionFactory factory = this.getExpressionFactory();
        return (T)factory.createValueExpression(elContext, expression, expectedType).getValue(elContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addELContextListener(ELContextListener listener) {
        ArrayList<ELContextListener> arrayList = this._elContextListeners;
        synchronized (arrayList) {
            this._elContextListeners.add(listener);
        }
    }

    public void publishEvent(FacesContext facesContext, Class<? extends SystemEvent> systemEventClass, Class<?> sourceBaseType, Object source) {
        this._eventManager.publishEvent(facesContext, systemEventClass, sourceBaseType, source);
    }

    public void publishEvent(FacesContext facesContext, Class<? extends SystemEvent> systemEventClass, Object source) {
        this._eventManager.publishEvent(facesContext, systemEventClass, source);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeELContextListener(ELContextListener listener) {
        ArrayList<ELContextListener> arrayList = this._elContextListeners;
        synchronized (arrayList) {
            this._elContextListeners.remove(listener);
        }
    }

    public final ELContextListener[] getELContextListeners() {
        return this._elContextListeners.toArray(new ELContextListener[this._elContextListeners.size()]);
    }

    public final void setActionListener(ActionListener actionListener) {
        Assert.notNull((Object)actionListener, (String)"actionListener");
        this._actionListener = actionListener;
        if (log.isLoggable(Level.FINEST)) {
            log.finest("set actionListener = " + actionListener.getClass().getName());
        }
    }

    public final ActionListener getActionListener() {
        return this._actionListener;
    }

    public Iterator<String> getBehaviorIds() {
        return this._behaviorClassMap.keySet().iterator();
    }

    public final Iterator<String> getComponentTypes() {
        return this._componentClassMap.keySet().iterator();
    }

    public final Iterator<String> getConverterIds() {
        return this._converterIdToClassMap.keySet().iterator();
    }

    public final Iterator<Class<?>> getConverterTypes() {
        return this._converterTargetClassToConverterClassMap.keySet().iterator();
    }

    public final void setDefaultLocale(Locale locale) {
        Assert.notNull((Object)locale, (String)"locale");
        this._defaultLocale = locale;
        if (log.isLoggable(Level.FINEST)) {
            log.finest("set defaultLocale = " + locale.getCountry() + " " + locale.getLanguage());
        }
    }

    public final Locale getDefaultLocale() {
        return this._defaultLocale;
    }

    public final void setMessageBundle(String messageBundle) {
        Assert.notNull((Object)messageBundle, (String)"messageBundle");
        this._messageBundle = messageBundle;
        if (log.isLoggable(Level.FINEST)) {
            log.finest("set MessageBundle = " + messageBundle);
        }
    }

    public final String getMessageBundle() {
        return this._messageBundle;
    }

    public final void setNavigationHandler(NavigationHandler navigationHandler) {
        Assert.notNull((Object)navigationHandler, (String)"navigationHandler");
        this._navigationHandler = navigationHandler;
        if (log.isLoggable(Level.FINEST)) {
            log.finest("set NavigationHandler = " + navigationHandler.getClass().getName());
        }
    }

    public final NavigationHandler getNavigationHandler() {
        return this._navigationHandler;
    }

    public ProjectStage getProjectStage() {
        if (this._projectStage == null) {
            String stageName = null;
            stageName = System.getProperty(PROJECT_STAGE_SYSTEM_PROPERTY_NAME);
            if (stageName == null) {
                try {
                    InitialContext ctx = new InitialContext();
                    Object temp = ctx.lookup("java:comp/env/faces/ProjectStage");
                    if (temp != null) {
                        if (temp instanceof String) {
                            stageName = (String)temp;
                        } else {
                            log.severe("JNDI lookup for key java:comp/env/faces/ProjectStage should return a java.lang.String value");
                        }
                    }
                }
                catch (NamingException ctx) {
                }
                catch (NoClassDefFoundError ctx) {
                    // empty catch block
                }
            }
            if (stageName == null) {
                stageName = this.getFacesContext().getExternalContext().getInitParameter("jakarta.faces.PROJECT_STAGE");
            }
            if (stageName != null) {
                try {
                    this._projectStage = ProjectStage.valueOf((String)stageName);
                    return this._projectStage;
                }
                catch (IllegalArgumentException e) {
                    log.log(Level.INFO, "Couldn't discover the current project stage: " + stageName);
                }
            } else if (log.isLoggable(Level.INFO)) {
                log.info("Couldn't discover the current project stage, using " + ProjectStage.Production);
            }
            this._projectStage = ProjectStage.Production;
        }
        return this._projectStage;
    }

    public final void setResourceHandler(ResourceHandler resourceHandler) {
        Assert.notNull((Object)resourceHandler, (String)"resourceHandler");
        if (this.isFirstRequestProcessed()) {
            throw new IllegalStateException("setResourceHandler may not be executed after a lifecycle request has been completed");
        }
        this._resourceHandler = resourceHandler;
    }

    public final ResourceHandler getResourceHandler() {
        return this._resourceHandler;
    }

    public final void setSupportedLocales(Collection<Locale> locales) {
        Assert.notNull(locales, (String)"locales");
        this._supportedLocales = locales;
        if (log.isLoggable(Level.FINEST)) {
            log.finest("set SupportedLocales");
        }
    }

    public final Iterator<Locale> getSupportedLocales() {
        return this._supportedLocales.iterator();
    }

    public final Iterator<String> getValidatorIds() {
        return this._validatorClassMap.keySet().iterator();
    }

    public final void setViewHandler(ViewHandler viewHandler) {
        Assert.notNull((Object)viewHandler, (String)"viewHandler");
        if (this.isFirstRequestProcessed()) {
            throw new IllegalStateException("setViewHandler may not be executed after a lifecycle request has been completed");
        }
        this._viewHandler = viewHandler;
        if (log.isLoggable(Level.FINEST)) {
            log.finest("set ViewHandler = " + viewHandler.getClass().getName());
        }
    }

    public void subscribeToEvent(Class<? extends SystemEvent> systemEventClass, SystemEventListener listener) {
        this._eventManager.subscribeToEvent(systemEventClass, listener);
    }

    public void subscribeToEvent(Class<? extends SystemEvent> systemEventClass, Class<?> sourceClass, SystemEventListener listener) {
        this._eventManager.subscribeToEvent(systemEventClass, sourceClass, listener);
    }

    public void unsubscribeFromEvent(Class<? extends SystemEvent> systemEventClass, SystemEventListener listener) {
        this._eventManager.unsubscribeFromEvent(systemEventClass, listener);
    }

    public void unsubscribeFromEvent(Class<? extends SystemEvent> systemEventClass, Class<?> sourceClass, SystemEventListener listener) {
        this._eventManager.unsubscribeFromEvent(systemEventClass, sourceClass, listener);
    }

    public final ViewHandler getViewHandler() {
        return this._viewHandler;
    }

    public void addBehavior(String behaviorId, String behaviorClass) {
        Assert.notEmpty((String)behaviorId, (String)"behaviorId");
        Assert.notEmpty((String)behaviorClass, (String)"behaviorClass");
        try {
            if (this._myfacesConfig.isLazyLoadConfigObjects()) {
                this._behaviorClassMap.put(behaviorId, behaviorClass);
            } else {
                this._behaviorClassMap.put(behaviorId, ClassUtils.simpleClassForName(behaviorClass));
            }
            if (log.isLoggable(Level.FINEST)) {
                log.finest("add Behavior class = " + behaviorClass + " for id = " + behaviorId);
            }
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Behavior class " + behaviorClass + " not found", e);
        }
    }

    public final void addComponent(String componentType, String componentClassName) {
        Assert.notEmpty((String)componentType, (String)"componentType");
        Assert.notEmpty((String)componentClassName, (String)"componentClassName");
        try {
            if (this._myfacesConfig.isLazyLoadConfigObjects()) {
                this._componentClassMap.put(componentType, componentClassName);
            } else {
                this._componentClassMap.put(componentType, ClassUtils.simpleClassForName(componentClassName));
            }
            if (log.isLoggable(Level.FINEST)) {
                log.finest("add Component class = " + componentClassName + " for type = " + componentType);
            }
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Component class " + componentClassName + " not found", e);
        }
    }

    public final void addConverter(String converterId, String converterClass) {
        Assert.notEmpty((String)converterId, (String)"converterId");
        Assert.notEmpty((String)converterClass, (String)"converterClass");
        try {
            if (this._myfacesConfig.isLazyLoadConfigObjects()) {
                this._converterIdToClassMap.put(converterId, converterClass);
            } else {
                this._converterIdToClassMap.put(converterId, ClassUtils.simpleClassForName(converterClass));
            }
            if (log.isLoggable(Level.FINEST)) {
                log.finest("add Converter id = " + converterId + " converterClass = " + converterClass);
            }
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Converter class " + converterClass + " not found", e);
        }
    }

    public final void addConverter(Class<?> targetClass, String converterClass) {
        Assert.notNull(targetClass, (String)"targetClass");
        Assert.notEmpty((String)converterClass, (String)"converterClass");
        try {
            if (this._myfacesConfig.isLazyLoadConfigObjects()) {
                this._converterTargetClassToConverterClassMap.put(targetClass, converterClass);
            } else {
                this._converterTargetClassToConverterClassMap.put(targetClass, ClassUtils.simpleClassForName(converterClass));
            }
            if (log.isLoggable(Level.FINEST)) {
                log.finest("add Converter for class = " + targetClass + " converterClass = " + converterClass);
            }
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Converter class " + converterClass + " not found", e);
        }
    }

    public final void addValidator(String validatorId, String validatorClass) {
        Assert.notEmpty((String)validatorId, (String)"validatorId");
        Assert.notEmpty((String)validatorClass, (String)"validatorClass");
        try {
            if (this._myfacesConfig.isLazyLoadConfigObjects()) {
                this._validatorClassMap.put(validatorId, validatorClass);
            } else {
                this._validatorClassMap.put(validatorId, ClassUtils.simpleClassForName(validatorClass));
            }
            if (log.isLoggable(Level.FINEST)) {
                log.finest("add Validator id = " + validatorId + " class = " + validatorClass);
            }
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Validator class " + validatorClass + " not found", e);
        }
    }

    public Behavior createBehavior(String behaviorId) throws FacesException {
        Assert.notEmpty((String)behaviorId, (String)"behaviorId");
        Class behaviorClass = this.getObjectFromClassMap(behaviorId, this._behaviorClassMap);
        if (behaviorClass == null) {
            throw new FacesException("Could not find any registered behavior-class for behaviorId : " + behaviorId);
        }
        try {
            if (!this._cdiManagedBehaviorMap.containsKey(behaviorClass)) {
                FacesBehavior annotation = behaviorClass.getAnnotation(FacesBehavior.class);
                if (annotation != null && annotation.managed()) {
                    this._cdiManagedBehaviorMap.put(behaviorClass, true);
                } else {
                    this._cdiManagedBehaviorMap.put(behaviorClass, false);
                }
            }
            boolean managed = this._cdiManagedBehaviorMap.get(behaviorClass);
            Object behavior = null;
            if (managed) {
                ClientBehaviorBase clientBehavior;
                String renderType;
                behavior = ClientBehavior.class.isAssignableFrom(behaviorClass) ? new FacesClientBehaviorCDIWrapper(behaviorClass, behaviorId) : new FacesBehaviorCDIWrapper(behaviorClass, behaviorId);
                Behavior innerBehavior = (Behavior)((FacesWrapper)behavior).getWrapped();
                FacesContext facesContext = this.getFacesContext();
                this._handleAttachedResourceDependencyAnnotations(facesContext, innerBehavior);
                if (innerBehavior instanceof ClientBehaviorBase && (renderType = (clientBehavior = (ClientBehaviorBase)innerBehavior).getRendererType()) != null) {
                    ClientBehaviorRenderer cbr = facesContext.getRenderKit().getClientBehaviorRenderer(renderType);
                    this._handleAttachedResourceDependencyAnnotations(facesContext, cbr);
                }
            } else {
                ClientBehaviorBase clientBehavior;
                String renderType;
                behavior = (Behavior)behaviorClass.newInstance();
                FacesContext facesContext = this.getFacesContext();
                this._handleAttachedResourceDependencyAnnotations(facesContext, behavior);
                if (behavior instanceof ClientBehaviorBase && (renderType = (clientBehavior = (ClientBehaviorBase)behavior).getRendererType()) != null) {
                    ClientBehaviorRenderer cbr = facesContext.getRenderKit().getClientBehaviorRenderer(renderType);
                    this._handleAttachedResourceDependencyAnnotations(facesContext, cbr);
                }
            }
            return behavior;
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Could not instantiate behavior " + behaviorClass, e);
            throw new FacesException("Could not instantiate behavior: " + behaviorClass, (Throwable)e);
        }
    }

    public UIComponent createComponent(FacesContext context, Resource componentResource) {
        Assert.notNull((Object)context, (String)"context");
        Assert.notNull((Object)componentResource, (String)"componentResource");
        UIComponent component = null;
        Class componentClass = null;
        UIViewRoot view = context.getViewRoot();
        Application application = context.getApplication();
        ViewDeclarationLanguage vdl = application.getViewHandler().getViewDeclarationLanguage(context, view.getViewId());
        BeanInfo metadata = vdl.getComponentMetadata(context, componentResource);
        if (metadata == null) {
            throw new FacesException("Could not get component metadata for " + componentResource.getResourceName() + ". Did you forget to specify <composite:interface>?");
        }
        BeanDescriptor descriptor = metadata.getBeanDescriptor();
        ValueExpression componentType = (ValueExpression)descriptor.getValue("jakarta.faces.component.COMPOSITE_COMPONENT_TYPE");
        boolean annotationsApplied = false;
        if (componentType != null) {
            component = application.createComponent((String)componentType.getValue(context.getELContext()));
            annotationsApplied = true;
        } else {
            Resource resource = vdl.getScriptComponentResource(context, componentResource);
            if (resource != null) {
                String name = resource.getResourceName();
                String className = name.substring(0, name.lastIndexOf(46));
                component = (UIComponent)ClassUtils.newInstance((String)className);
            } else {
                String fqcn;
                block17: {
                    boolean isProduction = FacesContext.getCurrentInstance().isProjectStage(ProjectStage.Production);
                    String name = componentResource.getResourceName();
                    String className = name.substring(0, name.lastIndexOf(46));
                    fqcn = componentResource.getLibraryName() + "." + className;
                    if (isProduction) {
                        componentClass = (Class)this._componentClassMap.get(fqcn);
                    }
                    if (componentClass == null) {
                        try {
                            componentClass = ClassUtils.classForName(fqcn);
                            if (isProduction) {
                                this._componentClassMap.put(fqcn, componentClass);
                            }
                        }
                        catch (ClassNotFoundException e) {
                            if (!isProduction) break block17;
                            this._componentClassMap.put(fqcn, NOTHING.getClass());
                        }
                    }
                }
                if (componentClass != null && NOTHING.getClass() != componentClass) {
                    try {
                        component = (UIComponent)componentClass.newInstance();
                    }
                    catch (InstantiationException e) {
                        log.log(Level.SEVERE, "Could not instantiate component class name = " + fqcn, e);
                        throw new FacesException("Could not instantiate component class name = " + fqcn, (Throwable)e);
                    }
                    catch (IllegalAccessException e) {
                        log.log(Level.SEVERE, "Could not instantiate component class name = " + fqcn, e);
                        throw new FacesException("Could not instantiate component class name = " + fqcn, (Throwable)e);
                    }
                    catch (Exception e) {
                        log.log(Level.SEVERE, "Could not instantiate component class name = " + fqcn, e);
                    }
                }
                if (component == null) {
                    component = application.createComponent(context, "jakarta.faces.NamingContainer", null);
                    annotationsApplied = true;
                }
            }
        }
        component.setRendererType("jakarta.faces.Composite");
        component.getAttributes().put("jakarta.faces.application.Resource.ComponentResource", componentResource);
        component.getAttributes().put("jakarta.faces.component.BEANINFO_KEY", metadata);
        if (!annotationsApplied) {
            this._handleAnnotations(context, component, component);
        }
        return component;
    }

    public UIComponent createComponent(FacesContext context, String componentType, String rendererType) {
        Assert.notNull((Object)context, (String)"context");
        Assert.notNull((Object)componentType, (String)"componentType");
        UIComponent component = this.createComponent(context, componentType);
        if (rendererType != null) {
            this._inspectRenderer(context, component, componentType, rendererType);
        }
        return component;
    }

    private final UIComponent createComponent(FacesContext facesContext, String componentType) throws FacesException {
        Assert.notEmpty((String)componentType, (String)"componentType");
        Class componentClass = this.getObjectFromClassMap(componentType, this._componentClassMap);
        if (componentClass == null) {
            log.log(Level.SEVERE, "Undefined component type " + componentType);
            throw new FacesException("Undefined component type " + componentType);
        }
        try {
            UIComponent component = (UIComponent)componentClass.newInstance();
            this._handleAnnotations(facesContext, component, component);
            return component;
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Could not instantiate component componentType = " + componentType, e);
            throw new FacesException("Could not instantiate component componentType = " + componentType, (Throwable)e);
        }
    }

    public final UIComponent createComponent(String componentType) throws FacesException {
        Assert.notEmpty((String)componentType, (String)"componentType");
        Class componentClass = this.getObjectFromClassMap(componentType, this._componentClassMap);
        if (componentClass == null) {
            log.log(Level.SEVERE, "Undefined component type " + componentType);
            throw new FacesException("Undefined component type " + componentType);
        }
        try {
            UIComponent component = (UIComponent)componentClass.newInstance();
            this._handleAnnotations(this.getFacesContext(), component, component);
            return component;
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Could not instantiate component componentType = " + componentType, e);
            throw new FacesException("Could not instantiate component componentType = " + componentType, (Throwable)e);
        }
    }

    public final Converter createConverter(String converterId) {
        Assert.notEmpty((String)converterId, (String)"converterId");
        Class converterClass = this.getObjectFromClassMap(converterId, this._converterIdToClassMap);
        if (converterClass == null) {
            throw new FacesException("Could not find any registered converter-class by converterId : " + converterId);
        }
        try {
            if (!this._cdiManagedConverterMap.containsKey(converterClass)) {
                FacesConverter annotation = converterClass.getAnnotation(FacesConverter.class);
                if (annotation != null && annotation.managed()) {
                    this._cdiManagedConverterMap.put(converterClass, true);
                } else {
                    this._cdiManagedConverterMap.put(converterClass, false);
                }
            }
            boolean managed = this._cdiManagedConverterMap.get(converterClass);
            Converter converter = null;
            if (managed) {
                converter = new FacesConverterCDIWrapper(converterClass, null, converterId);
                this.setConverterProperties(converterClass, (Converter)((FacesWrapper)converter).getWrapped());
                this._handleAttachedResourceDependencyAnnotations(this.getFacesContext(), ((FacesWrapper)converter).getWrapped());
            } else {
                converter = this.createConverterInstance(converterClass);
                this.setConverterProperties(converterClass, converter);
                this._handleAttachedResourceDependencyAnnotations(this.getFacesContext(), converter);
            }
            return converter;
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Could not instantiate converter " + converterClass, e);
            throw new FacesException("Could not instantiate converter: " + converterClass, (Throwable)e);
        }
    }

    private Converter createConverterInstance(Class<? extends Converter> converterClass) throws InstantiationException, IllegalAccessException {
        return converterClass.newInstance();
    }

    public final Converter createConverter(Class<?> targetClass) {
        Assert.notNull(targetClass, (String)"targetClass");
        return this.internalCreateConverter(targetClass);
    }

    private Converter<?> internalCreateConverter(Class<?> targetClass) {
        Class<?>[] interfaces;
        Object converterClassOrClassName = this._converterTargetClassToConverterClassMap.get(targetClass);
        if (converterClassOrClassName == null && !String.class.equals(targetClass) && (interfaces = targetClass.getInterfaces()) != null) {
            int len = interfaces.length;
            for (int i = 0; i < len; ++i) {
                Converter<?> converter = this.internalCreateConverter(interfaces[i]);
                if (converter == null) continue;
                return converter;
            }
        }
        if (converterClassOrClassName == null && targetClass.isEnum()) {
            converterClassOrClassName = this._converterTargetClassToConverterClassMap.get(Enum.class);
        }
        if (converterClassOrClassName != null) {
            try {
                Class converterClass = null;
                if (converterClassOrClassName instanceof Class) {
                    converterClass = (Class)converterClassOrClassName;
                } else if (converterClassOrClassName instanceof String) {
                    converterClass = ClassUtils.simpleClassForName((String)converterClassOrClassName);
                    this._converterTargetClassToConverterClassMap.put(targetClass, converterClass);
                } else {
                    this._converterTargetClassToConverterClassMap.remove(targetClass);
                }
                if (!this._cdiManagedConverterMap.containsKey(converterClass)) {
                    FacesConverter annotation = converterClass.getAnnotation(FacesConverter.class);
                    if (annotation != null && annotation.managed()) {
                        this._cdiManagedConverterMap.put(converterClass, true);
                    } else {
                        this._cdiManagedConverterMap.put(converterClass, false);
                    }
                }
                FacesConverterCDIWrapper converter = null;
                if (Boolean.TRUE.equals(this._cdiManagedConverterMap.get(converterClass))) {
                    converter = new FacesConverterCDIWrapper(converterClass, targetClass, null);
                    this.setConverterProperties(converterClass, (Converter)((FacesWrapper)converter).getWrapped());
                } else {
                    if (!this._noArgConstructorConverterClasses.contains(converterClass)) {
                        try {
                            Constructor constructor = converterClass.getConstructor(Class.class);
                            converter = (Converter)constructor.newInstance(targetClass);
                        }
                        catch (Exception e) {
                            this._noArgConstructorConverterClasses.add(converterClass);
                            converter = this.createConverterInstance(converterClass);
                        }
                    } else {
                        converter = this.createConverterInstance(converterClass);
                    }
                    this.setConverterProperties(converterClass, converter);
                }
                return converter;
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "Could not instantiate converter " + converterClassOrClassName.toString(), e);
                throw new FacesException("Could not instantiate converter: " + converterClassOrClassName.toString(), (Throwable)e);
            }
        }
        if (targetClass == Long.TYPE) {
            return this.internalCreateConverter(Long.class);
        }
        if (targetClass == Boolean.TYPE) {
            return this.internalCreateConverter(Boolean.class);
        }
        if (targetClass == Double.TYPE) {
            return this.internalCreateConverter(Double.class);
        }
        if (targetClass == Byte.TYPE) {
            return this.internalCreateConverter(Byte.class);
        }
        if (targetClass == Short.TYPE) {
            return this.internalCreateConverter(Short.class);
        }
        if (targetClass == Integer.TYPE) {
            return this.internalCreateConverter(Integer.class);
        }
        if (targetClass == Float.TYPE) {
            return this.internalCreateConverter(Float.class);
        }
        if (targetClass == Character.TYPE) {
            return this.internalCreateConverter(Character.class);
        }
        Class<?> superClazz = targetClass.getSuperclass();
        return superClazz != null ? this.internalCreateConverter(superClazz) : null;
    }

    private void setConverterProperties(Class<?> converterClass, Converter converter) {
        org.apache.myfaces.config.element.Converter converterConfig = this._runtimeConfig.getConverterConfiguration(converterClass.getName());
        if (converter instanceof DateTimeConverter && this._dateTimeConverterDefaultTimeZoneIsSystemTimeZone) {
            ((DateTimeConverter)converter).setTimeZone(TimeZone.getDefault());
        }
        if (converterConfig != null && !converterConfig.getProperties().isEmpty()) {
            Map pds = PropertyDescriptorUtils.getCachedPropertyDescriptors((ExternalContext)FacesContext.getCurrentInstance().getExternalContext(), converterClass);
            for (int i = 0; i < converterConfig.getProperties().size(); ++i) {
                Property property = converterConfig.getProperties().get(i);
                try {
                    PropertyDescriptorWrapper pd = (PropertyDescriptorWrapper)pds.get(property.getPropertyName());
                    if (!pd.getPropertyType().isPrimitive()) {
                        Object defaultValue;
                        Function readFunction = null;
                        if (pd instanceof LambdaPropertyDescriptor) {
                            readFunction = ((LambdaPropertyDescriptor)pd).getReadFunction();
                        }
                        if ((defaultValue = readFunction != null ? readFunction.apply(converter) : pd.getReadMethod().invoke((Object)converter, new Object[0])) != null) continue;
                    }
                    Object convertedValue = ClassUtils.convertToType((Object)property.getDefaultValue(), (Class)pd.getPropertyType());
                    BiConsumer writeFunction = null;
                    if (pd instanceof LambdaPropertyDescriptor) {
                        writeFunction = ((LambdaPropertyDescriptor)pd).getWriteFunction();
                    }
                    if (writeFunction != null) {
                        writeFunction.accept(converter, convertedValue);
                        continue;
                    }
                    pd.getWriteMethod().invoke((Object)converter, convertedValue);
                    continue;
                }
                catch (Throwable th) {
                    log.log(Level.SEVERE, "Initializing converter : " + converterClass.getName() + " with property : " + property.getPropertyName() + " and value : " + property.getDefaultValue() + " failed.");
                }
            }
        }
    }

    private void _handleAttachedResourceDependencyAnnotations(FacesContext context, Object inspected) {
        List<ResourceDependency> dependencyList;
        Class<?> inspectedClass;
        if (inspected == null) {
            return;
        }
        RequestViewContext rvc = RequestViewContext.getCurrentInstance(context);
        if (rvc.isClassAlreadyProcessed(inspectedClass = inspected.getClass())) {
            return;
        }
        if (context.isProjectStage(ProjectStage.Development)) {
            this._classToResourceDependencyMap.remove(inspectedClass);
        }
        if ((dependencyList = this._classToResourceDependencyMap.get(inspectedClass)) == null) {
            ResourceDependencies dependencies;
            dependencyList = new ArrayList<ResourceDependency>(5);
            ResourceDependency dependency = inspectedClass.getAnnotation(ResourceDependency.class);
            if (dependency != null) {
                dependencyList.add(dependency);
            }
            if ((dependencies = inspectedClass.getAnnotation(ResourceDependencies.class)) != null) {
                dependencyList.addAll(Arrays.asList(dependencies.value()));
            }
            this._classToResourceDependencyMap.put(inspectedClass, dependencyList.isEmpty() ? Collections.emptyList() : dependencyList);
        }
        if (!dependencyList.isEmpty()) {
            int size = dependencyList.size();
            for (int i = 0; i < size; ++i) {
                ResourceDependency dependency = dependencyList.get(i);
                if (rvc.isResourceDependencyAlreadyProcessed(dependency)) continue;
                this._handleAttachedResourceDependency(context, dependency, inspectedClass);
                rvc.setResourceDependencyAsProcessed(dependency);
            }
        }
        rvc.setClassProcessed(inspectedClass);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setResourceIdOnFaceletsMode(FacesContext facesContext, UIComponent component, Class<?> inspectedClass) {
        if (component.getId() == null) {
            FaceletCompositionContext mctx = FaceletCompositionContext.getCurrentInstance(facesContext);
            if (mctx != null) {
                UIViewRoot root = facesContext.getViewRoot();
                root.getAttributes().put(RESOURCE_DEPENDENCY_UNIQUE_ID_KEY, Boolean.TRUE);
                try {
                    String uid = root.createUniqueId(facesContext, null);
                    component.setId(uid);
                }
                finally {
                    root.getAttributes().put(RESOURCE_DEPENDENCY_UNIQUE_ID_KEY, Boolean.FALSE);
                }
                if (!mctx.isUsingPSSOnThisView()) {
                    component.getAttributes().put("oam.RDClass", inspectedClass);
                } else if (mctx.isRefreshTransientBuildOnPSSPreserveState()) {
                    component.getAttributes().put("oam.RDClass", inspectedClass);
                }
            } else {
                component.getAttributes().put("oam.RDClass", inspectedClass);
            }
        }
    }

    private void _handleAttachedResourceDependency(FacesContext context, ResourceDependency annotation, Class<?> inspectedClass) {
        if (annotation != null) {
            Application application = context.getApplication();
            UIOutput output = (UIOutput)application.createComponent(context, "jakarta.faces.Output", null);
            String name = annotation.name();
            if (StringUtils.isNotEmpty(name)) {
                name = ELText.parseAsString(this.getExpressionFactory(), context.getELContext(), name);
            }
            String rendererType = application.getResourceHandler().getRendererTypeForResourceName(name);
            output.setRendererType(rendererType);
            this.setResourceIdOnFaceletsMode(context, (UIComponent)output, inspectedClass);
            Map attributes = output.getAttributes();
            attributes.put("name", name);
            String library = annotation.library();
            if (StringUtils.isNotEmpty(library)) {
                library = ELText.parseAsString(this.getExpressionFactory(), context.getELContext(), library);
                attributes.put("library", library);
            }
            output.getAttributes().put("oam.component.resource.RDK", new Object[]{annotation.library(), annotation.name()});
            String target = annotation.target();
            if (StringUtils.isNotEmpty(target)) {
                target = ELText.parseAsString(this.getExpressionFactory(), context.getELContext(), target);
                attributes.put("target", target);
                context.getViewRoot().addComponentResource(context, (UIComponent)output, target);
            } else {
                context.getViewRoot().addComponentResource(context, (UIComponent)output);
            }
        }
    }

    public final Validator createValidator(String validatorId) throws FacesException {
        Assert.notEmpty((String)validatorId, (String)"validatorId");
        Class validatorClass = this.getObjectFromClassMap(validatorId, this._validatorClassMap);
        if (validatorClass == null) {
            String message = "Unknown validator id '" + validatorId + "'.";
            log.severe(message);
            throw new FacesException(message);
        }
        try {
            if (!this._cdiManagedValidatorMap.containsKey(validatorClass)) {
                FacesValidator annotation = validatorClass.getAnnotation(FacesValidator.class);
                if (annotation != null && annotation.managed()) {
                    this._cdiManagedValidatorMap.put(validatorClass, true);
                } else {
                    this._cdiManagedValidatorMap.put(validatorClass, false);
                }
            }
            boolean managed = this._cdiManagedValidatorMap.get(validatorClass);
            Validator validator = null;
            if (managed) {
                validator = new FacesValidatorCDIWrapper(validatorClass, validatorId);
                this._handleAttachedResourceDependencyAnnotations(this.getFacesContext(), ((FacesWrapper)validator).getWrapped());
            } else {
                validator = this.createValidatorInstance(validatorClass);
                this._handleAttachedResourceDependencyAnnotations(this.getFacesContext(), validator);
            }
            return validator;
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Could not instantiate validator " + validatorClass, e);
            throw new FacesException("Could not instantiate validator: " + validatorClass, (Throwable)e);
        }
    }

    private Validator createValidatorInstance(Class<? extends Validator> validatorClass) throws InstantiationException, IllegalAccessException {
        return validatorClass.newInstance();
    }

    public final String getDefaultRenderKitId() {
        return this._defaultRenderKitId;
    }

    public final void setDefaultRenderKitId(String defaultRenderKitId) {
        this._defaultRenderKitId = defaultRenderKitId;
    }

    public final StateManager getStateManager() {
        return this._stateManager;
    }

    public final void setStateManager(StateManager stateManager) {
        Assert.notNull((Object)stateManager, (String)"stateManager");
        if (this.isFirstRequestProcessed()) {
            throw new IllegalStateException("setStateManager may not be executed after a lifecycle request has been completed");
        }
        this._stateManager = stateManager;
    }

    public final void setFlowHandler(FlowHandler flowHandler) {
        Assert.notNull((Object)flowHandler, (String)"flowHandler");
        if (this.isFirstRequestProcessed()) {
            throw new IllegalStateException("setFlowHandler may not be executed after a lifecycle request has been completed");
        }
        this._flowHandler = flowHandler;
    }

    public final FlowHandler getFlowHandler() {
        return this._flowHandler;
    }

    private void _handleAnnotations(FacesContext context, Object inspected, UIComponent component) {
        boolean isProduction = context.isProjectStage(ProjectStage.Production);
        Class<?> inspectedClass = inspected.getClass();
        this._handleListenerForAnnotations(context, inspected, inspectedClass, component, isProduction);
        this._handleResourceDependencyAnnotations(context, inspectedClass, component, isProduction);
    }

    private void _handleRendererAnnotations(FacesContext context, Renderer inspected, UIComponent component) {
        boolean isProduction = context.isProjectStage(ProjectStage.Production);
        Renderer innerRenderer = inspected;
        while (innerRenderer != null) {
            Class<?> inspectedClass;
            if (innerRenderer instanceof RendererWrapper) {
                inspectedClass = innerRenderer.getClass();
                this._handleListenerForAnnotations(context, innerRenderer, inspectedClass, component, isProduction);
                this._handleResourceDependencyAnnotations(context, inspectedClass, component, isProduction);
                innerRenderer = ((RendererWrapper)innerRenderer).getWrapped();
                continue;
            }
            inspectedClass = innerRenderer.getClass();
            this._handleListenerForAnnotations(context, innerRenderer, inspectedClass, component, isProduction);
            this._handleResourceDependencyAnnotations(context, inspectedClass, component, isProduction);
            innerRenderer = null;
        }
    }

    private void _handleListenerForAnnotations(FacesContext context, Object inspected, Class<?> inspectedClass, UIComponent component, boolean isProduction) {
        List<ListenerFor> listenerForList;
        if (!isProduction) {
            this._classToListenerForMap.remove(inspectedClass);
        }
        if ((listenerForList = this._classToListenerForMap.get(inspectedClass)) == null) {
            ListenersFor listeners;
            listenerForList = new ArrayList<ListenerFor>(5);
            ListenerFor listener = inspectedClass.getAnnotation(ListenerFor.class);
            if (listener != null) {
                listenerForList.add(listener);
            }
            if ((listeners = inspectedClass.getAnnotation(ListenersFor.class)) != null) {
                listenerForList.addAll(Arrays.asList(listeners.value()));
            }
            this._classToListenerForMap.put(inspectedClass, listenerForList.isEmpty() ? Collections.emptyList() : listenerForList);
        }
        if (!listenerForList.isEmpty()) {
            int size = listenerForList.size();
            for (int i = 0; i < size; ++i) {
                ListenerFor listenerFor = listenerForList.get(i);
                this._handleListenerFor(context, inspected, component, listenerFor);
            }
        }
    }

    private void _handleListenerFor(FacesContext context, Object inspected, UIComponent component, ListenerFor annotation) {
        if (annotation != null) {
            if (inspected instanceof ComponentSystemEventListener) {
                component.subscribeToEvent(annotation.systemEventClass(), (ComponentSystemEventListener)inspected);
            } else if (component instanceof SystemEventListener) {
                Application application = context.getApplication();
                if (Void.class.equals((Object)annotation.sourceClass())) {
                    application.subscribeToEvent(annotation.systemEventClass(), (SystemEventListener)inspected);
                } else {
                    application.subscribeToEvent(annotation.systemEventClass(), annotation.sourceClass(), (SystemEventListener)inspected);
                }
            }
        }
    }

    private void _handleResourceDependencyAnnotations(FacesContext context, Class<?> inspectedClass, UIComponent component, boolean isProduction) {
        RequestViewContext rvc = RequestViewContext.getCurrentInstance(context);
        if (rvc.isClassAlreadyProcessed(inspectedClass)) {
            return;
        }
        boolean classAlreadyProcessed = false;
        List<Object> dependencyList = null;
        boolean isCachedList = false;
        if (isProduction && (dependencyList = this._classToResourceDependencyMap.get(inspectedClass)) != null) {
            if (dependencyList.isEmpty()) {
                return;
            }
            isCachedList = true;
        }
        if (dependencyList == null) {
            ResourceDependency dependency = inspectedClass.getAnnotation(ResourceDependency.class);
            ResourceDependencies dependencies = inspectedClass.getAnnotation(ResourceDependencies.class);
            if (dependency != null || dependencies != null) {
                dependencyList = new ArrayList<ResourceDependency>();
                if (dependency != null) {
                    dependencyList.add(dependency);
                }
                if (dependencies != null) {
                    dependencyList.addAll(Arrays.asList(dependencies.value()));
                }
            } else {
                dependencyList = Collections.emptyList();
            }
        }
        if (dependencyList != null && !dependencyList.isEmpty()) {
            int size = dependencyList.size();
            for (int i = 0; i < size; ++i) {
                ResourceDependency dependency = dependencyList.get(i);
                if (rvc.isResourceDependencyAlreadyProcessed(dependency)) continue;
                this._handleResourceDependency(context, component, dependency, inspectedClass);
                rvc.setResourceDependencyAsProcessed(dependency);
            }
        }
        if (isProduction && !isCachedList && dependencyList != null) {
            this._classToResourceDependencyMap.put(inspectedClass, dependencyList);
        }
        if (!classAlreadyProcessed) {
            rvc.setClassProcessed(inspectedClass);
        }
    }

    private void _handleResourceDependency(FacesContext context, UIComponent component, ResourceDependency annotation, Class<?> inspectedClass) {
        if (annotation != null) {
            UIOutput output = (UIOutput)this.createComponent(context, "jakarta.faces.Output", null);
            String name = annotation.name();
            if (StringUtils.isNotEmpty(name)) {
                name = ELText.parseAsString(this.getExpressionFactory(), context.getELContext(), name);
            }
            String rendererType = context.getApplication().getResourceHandler().getRendererTypeForResourceName(name);
            output.setRendererType(rendererType);
            this.setResourceIdOnFaceletsMode(context, (UIComponent)output, inspectedClass);
            Map attributes = output.getAttributes();
            attributes.put("name", name);
            String library = annotation.library();
            if (StringUtils.isNotEmpty(library)) {
                library = ELText.parseAsString(this.getExpressionFactory(), context.getELContext(), library);
                if ("this".equals(library)) {
                    Resource resource = (Resource)component.getAttributes().get("jakarta.faces.application.Resource.ComponentResource");
                    if (resource != null) {
                        attributes.put("library", resource.getLibraryName());
                    }
                } else {
                    attributes.put("library", library);
                }
            }
            output.getAttributes().put("oam.component.resource.RDK", new Object[]{annotation.library(), annotation.name()});
            String target = annotation.target();
            if (StringUtils.isNotEmpty(target)) {
                target = ELText.parseAsString(this.getExpressionFactory(), context.getELContext(), target);
                attributes.put("target", target);
                context.getViewRoot().addComponentResource(context, (UIComponent)output, target);
            } else {
                context.getViewRoot().addComponentResource(context, (UIComponent)output);
            }
        }
    }

    private void _inspectRenderer(FacesContext context, UIComponent component, String componentType, String rendererType) {
        RenderKit renderKit = context.getRenderKit();
        if (renderKit == null) {
            return;
        }
        Renderer renderer = renderKit.getRenderer(component.getFamily(), rendererType);
        if (renderer == null) {
            log.severe("renderer cannot be found for component type " + componentType + " and renderer type " + rendererType);
        } else {
            component.setRendererType(rendererType);
            this._handleRendererAnnotations(context, renderer, component);
        }
    }

    private boolean isFirstRequestProcessed() {
        FacesContext context = this.getFacesContext();
        if (!this._firstRequestProcessed && context != null && Boolean.TRUE.equals(context.getExternalContext().getApplicationMap().containsKey("org.apache.myfaces.lifecycle.first.request.processed"))) {
            this._firstRequestProcessed = true;
        }
        return this._firstRequestProcessed;
    }

    private <T> Class<? extends T> getObjectFromClassMap(String id, Map<String, Object> classMap) {
        Object obj = classMap.get(id);
        if (obj == null) {
            return null;
        }
        if (obj instanceof Class) {
            return (Class)obj;
        }
        if (obj instanceof String) {
            Class clazz = ClassUtils.simpleClassForName((String)obj);
            classMap.put(id, clazz);
            return clazz;
        }
        classMap.remove(id);
        return null;
    }

    public final void setSearchExpressionHandler(SearchExpressionHandler searchExpressionHandler) {
        Assert.notNull((Object)searchExpressionHandler, (String)"searchExpressionHandler");
        if (this.isFirstRequestProcessed()) {
            throw new IllegalStateException("setFlowHandler may not be executed after a lifecycle request has been completed");
        }
        this._searchExpressionHandler = searchExpressionHandler;
    }

    public final SearchExpressionHandler getSearchExpressionHandler() {
        return this._searchExpressionHandler;
    }

    public SearchKeywordResolver getSearchKeywordResolver() {
        if (this._searchExpressionResolver == null) {
            this._searchExpressionResolver = this.createSearchExpressionResolver();
        }
        return this._searchExpressionResolver;
    }

    private SearchKeywordResolver createSearchExpressionResolver() {
        CompositeSearchKeywordResolver baseResolver = new CompositeSearchKeywordResolver();
        for (SearchKeywordResolver child : this._runtimeConfig.getApplicationSearchExpressionResolvers()) {
            baseResolver.add(child);
        }
        baseResolver.add(new ThisSearchKeywordResolver());
        baseResolver.add(new ParentSearchKeywordResolver());
        baseResolver.add(new ChildSearchKeywordResolver());
        baseResolver.add(new CompositeComponentParentSearchKeywordResolver());
        baseResolver.add(new FormSearchKeywordResolver());
        baseResolver.add(new NamingContainerSearchKeywordResolver());
        baseResolver.add(new NextSearchKeywordResolver());
        baseResolver.add(new NoneSearchKeywordResolver());
        baseResolver.add(new PreviousSearchKeywordResolver());
        baseResolver.add(new RootSearchKeywordResolver());
        baseResolver.add(new IdSearchKeywordResolver());
        baseResolver.add(new AllSearchKeywordResolver());
        return baseResolver;
    }

    public void addSearchKeywordResolver(SearchKeywordResolver resolver) {
        if (this.isFirstRequestProcessed()) {
            throw new IllegalStateException("It is illegal to add a search expression resolver after the first request is processed");
        }
        if (resolver != null) {
            this._runtimeConfig.addApplicationSearchExpressionResolver(resolver);
        }
    }
}

