/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.view.facelets;

import jakarta.faces.context.FacesContext;
import java.io.IOException;
import java.io.Writer;
import org.apache.myfaces.util.lang.FastWriter;

public final class StateWriter
extends Writer {
    private static final String CURRENT_WRITER_KEY = "org.apache.myfaces.view.facelets.StateWriter.CURRENT_WRITER";
    private int initialSize;
    private Writer out;
    private FastWriter fast;
    private boolean writtenState;
    private boolean writtenStateWithoutWrapper;

    public static StateWriter getCurrentInstance() {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        return (StateWriter)facesContext.getAttributes().get(CURRENT_WRITER_KEY);
    }

    public static StateWriter getCurrentInstance(FacesContext facesContext) {
        return (StateWriter)facesContext.getAttributes().get(CURRENT_WRITER_KEY);
    }

    private static void setCurrentInstance(StateWriter stateWriter) {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        if (stateWriter == null) {
            facesContext.getAttributes().remove(CURRENT_WRITER_KEY);
        } else {
            facesContext.getAttributes().put(CURRENT_WRITER_KEY, stateWriter);
        }
    }

    private static void setCurrentInstance(StateWriter stateWriter, FacesContext facesContext) {
        if (stateWriter == null) {
            facesContext.getAttributes().remove(CURRENT_WRITER_KEY);
        } else {
            facesContext.getAttributes().put(CURRENT_WRITER_KEY, stateWriter);
        }
    }

    public StateWriter(Writer initialOut, int initialSize) {
        if (initialSize < 0) {
            throw new IllegalArgumentException("Initial Size cannot be less than 0");
        }
        this.initialSize = initialSize;
        this.out = initialOut;
        StateWriter.setCurrentInstance(this);
    }

    public StateWriter(Writer initialOut, int initialSize, FacesContext facesContext) {
        if (initialSize < 0) {
            throw new IllegalArgumentException("Initial Size cannot be less than 0");
        }
        this.initialSize = initialSize;
        this.out = initialOut;
        StateWriter.setCurrentInstance(this, facesContext);
    }

    public void writingState() {
        if (!this.writtenState) {
            this.writtenState = true;
            this.writtenStateWithoutWrapper = false;
            this.fast = new FastWriter(this.initialSize);
            this.out = this.fast;
        }
    }

    public boolean isStateWritten() {
        return this.writtenState;
    }

    public void writingStateWithoutWrapper() {
        if (!this.writtenState && !this.writtenStateWithoutWrapper) {
            this.writtenStateWithoutWrapper = true;
        }
    }

    public boolean isStateWrittenWithoutWrapper() {
        return this.writtenStateWithoutWrapper;
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public void flush() throws IOException {
        if (!this.writtenState) {
            this.out.flush();
        }
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        this.out.write(cbuf, off, len);
    }

    @Override
    public void write(char[] cbuf) throws IOException {
        this.out.write(cbuf);
    }

    @Override
    public void write(int c) throws IOException {
        this.out.write(c);
    }

    @Override
    public void write(String str, int off, int len) throws IOException {
        this.out.write(str, off, len);
    }

    @Override
    public void write(String str) throws IOException {
        this.out.write(str);
    }

    public String getAndResetBuffer() {
        if (!this.writtenState) {
            throw new IllegalStateException("Did not write state;  no buffer is available");
        }
        String result = this.fast.toString();
        this.fast.reset();
        return result;
    }

    public void release() {
        StateWriter.setCurrentInstance(null);
    }

    public void release(FacesContext facesContext) {
        StateWriter.setCurrentInstance(null, facesContext);
    }
}

