/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.cdi.wrapper;

import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.util.TypeLiteral;
import jakarta.faces.FacesWrapper;
import jakarta.faces.component.PartialStateHolder;
import jakarta.faces.component.UIComponent;
import jakarta.faces.context.FacesContext;
import jakarta.faces.convert.Converter;
import jakarta.faces.convert.ConverterException;
import jakarta.faces.convert.FacesConverter;
import java.lang.reflect.Type;
import org.apache.myfaces.cdi.util.CDIUtils;

public class FacesConverterCDIWrapper
implements PartialStateHolder,
Converter,
FacesWrapper<Converter> {
    private static final Type CONVERTER_TYPE = new TypeLiteral<Converter<?>>(){
        private static final long serialVersionUID = 1L;
    }.getType();
    private transient Converter delegate;
    private Class<?> forClass;
    private String converterId;
    private boolean _transient;
    private boolean _initialStateMarked = false;

    public FacesConverterCDIWrapper() {
    }

    public FacesConverterCDIWrapper(Class<? extends Converter> converterClass, Class<?> forClass, String converterId) {
        this.forClass = forClass;
        this.converterId = converterId;
    }

    public Object getAsObject(FacesContext context, UIComponent component, String value) throws ConverterException {
        return this.getWrapped().getAsObject(context, component, value);
    }

    public String getAsString(FacesContext context, UIComponent component, Object value) throws ConverterException {
        return this.getWrapped().getAsString(context, component, value);
    }

    @Override
    public Converter getWrapped() {
        if (this.delegate == null) {
            BeanManager bm = CDIUtils.getBeanManager(FacesContext.getCurrentInstance());
            if (this.converterId != null) {
                FacesConverter.Literal literal = FacesConverter.Literal.of(this.converterId, Object.class, true);
                this.delegate = (Converter)CDIUtils.get(bm, CONVERTER_TYPE, true, literal);
                if (this.delegate == null) {
                    this.delegate = CDIUtils.get(bm, Converter.class, true, literal);
                }
            } else if (this.forClass != null) {
                FacesConverter.Literal literal = FacesConverter.Literal.of("", this.forClass, true);
                this.delegate = (Converter)CDIUtils.get(bm, CONVERTER_TYPE, true, literal);
                if (this.delegate == null) {
                    this.delegate = CDIUtils.get(bm, Converter.class, true, literal);
                }
            }
        }
        return this.delegate;
    }

    @Override
    public Object saveState(FacesContext context) {
        if (!this.initialStateMarked()) {
            Object[] values = new Object[]{this.forClass, this.converterId};
            return values;
        }
        return null;
    }

    @Override
    public void restoreState(FacesContext context, Object state) {
        if (state != null) {
            Object[] values = (Object[])state;
            this.forClass = (Class)values[0];
            this.converterId = (String)values[1];
        }
    }

    @Override
    public boolean isTransient() {
        return this._transient;
    }

    @Override
    public void setTransient(boolean newTransientValue) {
        this._transient = newTransientValue;
    }

    @Override
    public void clearInitialState() {
        this._initialStateMarked = false;
    }

    @Override
    public boolean initialStateMarked() {
        return this._initialStateMarked;
    }

    @Override
    public void markInitialState() {
        this._initialStateMarked = true;
    }
}

