/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.renderkit.renderer;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.apache.myfaces.tobago.context.TobagoResourceBundle;
import org.apache.myfaces.tobago.internal.component.AbstractUIDate;
import org.apache.myfaces.tobago.internal.component.AbstractUIInput;
import org.apache.myfaces.tobago.internal.context.DateTimeI18n;
import org.apache.myfaces.tobago.internal.renderkit.renderer.InRenderer;
import org.apache.myfaces.tobago.internal.util.JsonUtils;
import org.apache.myfaces.tobago.internal.util.StringUtils;
import org.apache.myfaces.tobago.renderkit.css.BootstrapClass;
import org.apache.myfaces.tobago.renderkit.css.BootstrapDateTimePickerClass;
import org.apache.myfaces.tobago.renderkit.css.Icons;
import org.apache.myfaces.tobago.renderkit.css.TobagoClass;
import org.apache.myfaces.tobago.renderkit.html.DataAttributes;
import org.apache.myfaces.tobago.renderkit.html.HtmlAttributes;
import org.apache.myfaces.tobago.renderkit.html.HtmlButtonTypes;
import org.apache.myfaces.tobago.renderkit.html.HtmlElements;
import org.apache.myfaces.tobago.renderkit.html.MarkupLanguageAttributes;
import org.apache.myfaces.tobago.webapp.TobagoResponseWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DateRenderer
extends InRenderer {
    private static final Logger LOG = LoggerFactory.getLogger(DateRenderer.class);

    @Override
    protected void writeAdditionalAttributes(FacesContext facesContext, TobagoResponseWriter writer, AbstractUIInput input) throws IOException {
        AbstractUIDate date = (AbstractUIDate)input;
        super.writeAdditionalAttributes(facesContext, writer, date);
        writer.writeAttribute(DataAttributes.PATTERN, date.getPattern(), true);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        writer.writeAttribute(DataAttributes.TODAY, sdf.format(new Date()), true);
        DateTimeI18n dateTimeI18n = DateTimeI18n.valueOf(facesContext.getViewRoot().getLocale());
        writer.writeAttribute(DataAttributes.DATE_TIME_I18N, JsonUtils.encode(dateTimeI18n), true);
        writer.writeAttribute((MarkupLanguageAttributes)DataAttributes.TODAY_BUTTON, date.isTodayButton());
    }

    @Override
    protected void encodeBeginField(FacesContext facesContext, UIComponent component) throws IOException {
        AbstractUIDate date = (AbstractUIDate)component;
        TobagoResponseWriter writer = this.getResponseWriter(facesContext);
        writer.startElement(HtmlElements.DIV);
        if (date.isLabelLayoutSkip()) {
            writer.writeIdAttribute(date.getClientId());
            writer.writeAttribute(DataAttributes.MARKUP, JsonUtils.encode(date.getMarkup()), false);
        }
        writer.writeClassAttribute(TobagoClass.INPUT__GROUP__OUTER);
        writer.startElement(HtmlElements.DIV);
        writer.writeClassAttribute(BootstrapClass.INPUT_GROUP);
        super.encodeBeginField(facesContext, component);
    }

    @Override
    public void encodeEndField(FacesContext facesContext, UIComponent component) throws IOException {
        super.encodeEndField(facesContext, component);
        AbstractUIDate date = (AbstractUIDate)component;
        String pattern = date.getPattern();
        TobagoResponseWriter writer = this.getResponseWriter(facesContext);
        writer.startElement(HtmlElements.SPAN);
        writer.writeClassAttribute(BootstrapClass.INPUT_GROUP_APPEND);
        writer.startElement(HtmlElements.BUTTON);
        writer.writeClassAttribute(BootstrapClass.BTN, BootstrapClass.BTN_SECONDARY, BootstrapDateTimePickerClass.DATEPICKERBUTTON);
        writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.TYPE, HtmlButtonTypes.BUTTON);
        writer.writeAttribute(HtmlAttributes.TITLE, TobagoResourceBundle.getString(facesContext, "datePickerTitle"), true);
        writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.DISABLED, date.isDisabled() || date.isReadonly());
        writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.TABINDEX, date.getTabIndex());
        boolean hasDate = StringUtils.containsAny(pattern, "yYMDdE");
        boolean hasTime = StringUtils.containsAny(pattern, "Hhms");
        if (hasDate || !hasTime) {
            writer.startElement(HtmlElements.I);
            writer.writeClassAttribute(Icons.FA, Icons.CALENDAR);
            writer.endElement(HtmlElements.I);
        }
        if (hasTime) {
            writer.startElement(HtmlElements.I);
            writer.writeClassAttribute(Icons.FA, Icons.CLOCK_O);
            writer.endElement(HtmlElements.I);
        }
        if (StringUtils.containsAny(pattern, "GWFKzX")) {
            LOG.warn("Pattern chars 'G', 'W', 'F', 'K', 'z' and 'X' are not supported: " + pattern);
        }
        writer.endElement(HtmlElements.BUTTON);
        writer.endElement(HtmlElements.SPAN);
        writer.endElement(HtmlElements.DIV);
        writer.endElement(HtmlElements.DIV);
    }

    @Override
    protected TobagoClass getRendererCssClass() {
        return TobagoClass.DATE;
    }
}

