/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.util;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.servlet.ServletContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class WebXmlUtils {
    private static final Map<Class<Throwable>, String> ERROR_PAGE_LOCATIONS = new HashMap<Class<Throwable>, String>();

    public static String getErrorPageLocation(Throwable exception) {
        if (ERROR_PAGE_LOCATIONS.size() <= 0) {
            WebXmlUtils.init();
        }
        String location = null;
        if (exception != null) {
            for (Class<?> exceptionClass = exception.getClass(); exceptionClass != null && location == null; exceptionClass = exceptionClass.getSuperclass()) {
                location = ERROR_PAGE_LOCATIONS.get(exceptionClass);
            }
        }
        if (location == null) {
            location = ERROR_PAGE_LOCATIONS.get(null);
        }
        return location;
    }

    private static void init() {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        ExternalContext externalContext = facesContext.getExternalContext();
        try {
            List<Document> webXmls = WebXmlUtils.getWebXmls(facesContext);
            String locationDefault = null;
            String location500 = null;
            for (Document document : webXmls) {
                if (document == null) continue;
                NodeList errorPages = document.getElementsByTagName("error-page");
                for (int i = 0; i < errorPages.getLength(); ++i) {
                    Node errorPage = errorPages.item(i);
                    String errorCode = null;
                    String exceptionType = null;
                    String location = null;
                    NodeList children = errorPage.getChildNodes();
                    for (int j = 0; j < children.getLength(); ++j) {
                        Node child = children.item(j);
                        String name = child.getNodeName();
                        if ("error-code".equals(name)) {
                            errorCode = child.getFirstChild().getNodeValue().trim();
                            continue;
                        }
                        if ("exception-type".equals(name)) {
                            exceptionType = child.getFirstChild().getNodeValue().trim();
                            continue;
                        }
                        if (!"location".equals(name)) continue;
                        location = child.getFirstChild().getNodeValue().trim();
                    }
                    if (exceptionType != null) {
                        Class<?> key = Class.forName(exceptionType);
                        String value = WebXmlUtils.normalizePath(externalContext, location);
                        ERROR_PAGE_LOCATIONS.put(key, value);
                        continue;
                    }
                    if ("500".equals(errorCode)) {
                        location500 = location;
                        continue;
                    }
                    if (errorCode != null || exceptionType != null) continue;
                    locationDefault = location;
                }
            }
            if (!ERROR_PAGE_LOCATIONS.containsKey(null)) {
                String value = WebXmlUtils.normalizePath(externalContext, location500 != null ? location500 : locationDefault);
                ERROR_PAGE_LOCATIONS.put(null, value);
            }
        }
        catch (IOException | ClassNotFoundException | ParserConfigurationException | SAXException e) {
            throw new UnsupportedOperationException(e);
        }
    }

    private static List<Document> getWebXmls(FacesContext facesContext) throws ParserConfigurationException, IOException, SAXException {
        ArrayList<Document> webXmls = new ArrayList<Document>();
        DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        for (URL url : WebXmlUtils.getWebXmlUrls(facesContext)) {
            webXmls.add(WebXmlUtils.getWebXml(documentBuilder, url));
        }
        return webXmls;
    }

    private static List<URL> getWebXmlUrls(FacesContext facesContext) throws IOException {
        ArrayList<URL> urls = new ArrayList<URL>();
        ServletContext servletContext = (ServletContext)facesContext.getExternalContext().getContext();
        urls.add(servletContext.getResource("/WEB-INF/web.xml"));
        Enumeration<URL> webFragments = Thread.currentThread().getContextClassLoader().getResources("META-INF/web-fragment.xml");
        while (webFragments.hasMoreElements()) {
            urls.add(webFragments.nextElement());
        }
        return urls;
    }

    private static Document getWebXml(DocumentBuilder documentBuilder, URL url) throws ParserConfigurationException, IOException, SAXException {
        if (url != null) {
            URLConnection connection = url.openConnection();
            connection.setUseCaches(false);
            try (InputStream input = connection.getInputStream();){
                Document document = documentBuilder.parse(input);
                document.getDocumentElement().normalize();
                Document document2 = document;
                return document2;
            }
        }
        return null;
    }

    private static String normalizePath(ExternalContext externalContext, String path) {
        String suffix;
        if (path == null) {
            return null;
        }
        if (externalContext.getRequestPathInfo() != null) {
            String prefix = externalContext.getRequestServletPath();
            if (path.startsWith(prefix)) {
                return path.substring(prefix.length());
            }
            return path;
        }
        String suffixInitParam = externalContext.getInitParameter("javax.faces.FACELETS_SUFFIX");
        String string = suffix = suffixInitParam != null ? suffixInitParam : ".xhtml";
        if (path.endsWith(suffix)) {
            return path;
        }
        int lastIndex = path.lastIndexOf(46);
        if (lastIndex >= 0) {
            return path.substring(0, lastIndex) + suffix;
        }
        return path;
    }
}

