/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.portlet.faces.el;

import java.beans.FeatureDescriptor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.el.ELContext;
import javax.el.ELException;
import javax.el.ELResolver;
import javax.el.PropertyNotFoundException;
import javax.el.PropertyNotWritableException;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.portlet.PortletConfig;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.portlet.PortletSession;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.faces.Bridge;
import javax.portlet.faces.BridgeUtil;
import javax.portlet.faces.preference.Preference;
import org.apache.myfaces.portlet.faces.el.PortletELContextImpl;
import org.apache.myfaces.portlet.faces.preference.PreferenceImpl;
import org.apache.myfaces.portlet.faces.util.map.PortletSessionMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PortletELResolver
extends ELResolver {
    public Object getValue(ELContext context, Object base, Object property) throws ELException {
        if (!BridgeUtil.isPortletRequest() || base != null) {
            return null;
        }
        if (property == null) {
            throw new PropertyNotFoundException("Null property");
        }
        PortletELContextImpl portletELContext = (PortletELContextImpl)((Object)context.getContext(PortletELContextImpl.class));
        if (portletELContext == null) {
            return null;
        }
        return this.getResolvedValue(context, portletELContext, base, property, portletELContext.isFacesResolved());
    }

    private Object getResolvedValue(ELContext context, PortletELContextImpl bridgeContext, Object base, Object property, boolean isFacesResolved) throws ELException {
        block20: {
            FacesContext facesContext = (FacesContext)context.getContext(FacesContext.class);
            ExternalContext extCtx = facesContext.getExternalContext();
            if (property instanceof String) {
                try {
                    switch (Enum.valueOf(BRIDGE_IMPLICT_OBJECTS_ENUM.class, (String)property)) {
                        case portletConfig: {
                            if (isFacesResolved) {
                                PortletConfig config = bridgeContext.getPortletConfig();
                                if (config != null) {
                                    context.setPropertyResolved(true);
                                    return config;
                                }
                                throw new ELException("EL Resolve failed: can't resolve portletConfig because its not set on this Faces EL Resolver.");
                            }
                            return null;
                        }
                        case renderRequest: {
                            if (isFacesResolved) {
                                if (BridgeUtil.getPortletRequestPhase() == Bridge.PortletPhase.RENDER_PHASE) {
                                    context.setPropertyResolved(true);
                                    return extCtx.getRequest();
                                }
                                throw new ELException("EL Resolve failed: can't resolve renderRequest in a non-render request");
                            }
                            return null;
                        }
                        case renderResponse: {
                            if (isFacesResolved) {
                                if (BridgeUtil.getPortletRequestPhase() == Bridge.PortletPhase.RENDER_PHASE) {
                                    context.setPropertyResolved(true);
                                    return extCtx.getResponse();
                                }
                                throw new ELException("EL Resolve failed: can't resolve renderResponse in a non-render request");
                            }
                            return null;
                        }
                        case httpSessionScope: {
                            context.setPropertyResolved(true);
                            return this.getHttpSessionMap(extCtx, bridgeContext);
                        }
                        case portletSession: {
                            context.setPropertyResolved(true);
                            return extCtx.getSession(false);
                        }
                        case portletSessionScope: {
                            context.setPropertyResolved(true);
                            return extCtx.getSessionMap();
                        }
                        case mutablePortletPreferencesValues: {
                            context.setPropertyResolved(true);
                            return this.getMutablePortletPreferencesValues(extCtx, bridgeContext);
                        }
                        case portletPreferences: {
                            context.setPropertyResolved(true);
                            return ((PortletRequest)extCtx.getRequest()).getPreferences();
                        }
                        case portletPreferencesValues: {
                            context.setPropertyResolved(true);
                            return ((PortletRequest)extCtx.getRequest()).getPreferences().getMap();
                        }
                    }
                }
                catch (IllegalArgumentException e) {
                    if (isFacesResolved || !extCtx.getSessionMap().containsKey(property)) break block20;
                    context.setPropertyResolved(true);
                    return extCtx.getSessionMap().get(property);
                }
            }
        }
        return null;
    }

    public void setValue(ELContext context, Object base, Object property, Object val) throws ELException {
        if (!BridgeUtil.isPortletRequest() || base != null) {
            return;
        }
        if (property == null) {
            throw new PropertyNotFoundException("Null property");
        }
        if (property instanceof String) {
            try {
                Enum.valueOf(BRIDGE_IMPLICT_OBJECTS_ENUM.class, (String)property);
                throw new PropertyNotWritableException((String)property);
            }
            catch (IllegalArgumentException e) {
                // empty catch block
            }
        }
    }

    public boolean isReadOnly(ELContext context, Object base, Object property) throws ELException {
        if (!BridgeUtil.isPortletRequest() || base != null) {
            return false;
        }
        if (property == null) {
            throw new PropertyNotFoundException("Null property");
        }
        if (property instanceof String) {
            try {
                Enum.valueOf(BRIDGE_IMPLICT_OBJECTS_ENUM.class, (String)property);
                context.setPropertyResolved(true);
                return true;
            }
            catch (IllegalArgumentException e) {
                return false;
            }
        }
        return false;
    }

    public Class<?> getType(ELContext context, Object base, Object property) throws ELException {
        if (!BridgeUtil.isPortletRequest() || base != null) {
            return null;
        }
        if (property == null) {
            throw new PropertyNotFoundException("Null property");
        }
        int index = -1;
        if (property instanceof String) {
            try {
                Enum.valueOf(BRIDGE_IMPLICT_OBJECTS_ENUM.class, (String)property);
                context.setPropertyResolved(true);
            }
            catch (IllegalArgumentException e) {
                // empty catch block
            }
        }
        return null;
    }

    public Iterator<FeatureDescriptor> getFeatureDescriptors(ELContext context, Object base) {
        if (base != null) {
            return null;
        }
        ArrayList<FeatureDescriptor> list = new ArrayList<FeatureDescriptor>(9);
        list.add(this.getFeatureDescriptor("httpSessionScope", "httpSessionScope", "httpSessionScope", false, false, true, Map.class, Boolean.TRUE));
        list.add(this.getFeatureDescriptor("mutablePortletPreferences", "mutablePortletPreferences", "mutablePortletPreferences", false, false, true, Map.class, Boolean.TRUE));
        list.add(this.getFeatureDescriptor("portletConfig", "portletConfig", "portletConfig", false, false, true, PortletConfig.class, Boolean.TRUE));
        list.add(this.getFeatureDescriptor("portletPreferences", "portletPreferences", "portletPreferences", false, false, true, PortletPreferences.class, Boolean.TRUE));
        list.add(this.getFeatureDescriptor("portletPreferencesValues", "portletPreferencesValues", "portletPreferencesValues", false, false, true, Map.class, Boolean.TRUE));
        list.add(this.getFeatureDescriptor("portletSession", "portletSession", "portletSession", false, false, true, PortletSession.class, Boolean.TRUE));
        list.add(this.getFeatureDescriptor("portletSessionScope", "portletSessionScope", "portletSessionScope", false, false, true, Map.class, Boolean.TRUE));
        list.add(this.getFeatureDescriptor("renderRequest", "renderRequest", "renderRequest", false, false, true, RenderRequest.class, Boolean.TRUE));
        list.add(this.getFeatureDescriptor("renderResponse", "renderResponse", "renderResponse", false, false, true, RenderResponse.class, Boolean.TRUE));
        return list.iterator();
    }

    public Class<?> getCommonPropertyType(ELContext context, Object base) {
        if (base != null) {
            return null;
        }
        return String.class;
    }

    private FeatureDescriptor getFeatureDescriptor(String name, String displayName, String desc, boolean expert, boolean hidden, boolean preferred, Object type, Boolean designTime) {
        FeatureDescriptor fd = new FeatureDescriptor();
        fd.setName(name);
        fd.setDisplayName(displayName);
        fd.setShortDescription(desc);
        fd.setExpert(expert);
        fd.setHidden(hidden);
        fd.setPreferred(preferred);
        fd.setValue("type", type);
        fd.setValue("resolvableAtDesignTime", designTime);
        return fd;
    }

    private Map<String, String> getPreferencesValueMap(ExternalContext extCtx) {
        Map<String, String> m;
        PortletRequest portletRequest = (PortletRequest)extCtx.getRequest();
        Enumeration e = portletRequest.getPreferences().getNames();
        if (e.hasMoreElements()) {
            m = new HashMap();
            while (e.hasMoreElements()) {
                String name = (String)e.nextElement();
                String value = portletRequest.getPreferences().getValue(name, null);
                if (value == null) continue;
                m.put(name, value);
            }
        } else {
            m = Collections.emptyMap();
        }
        return m;
    }

    private Map<String, Preference> getPreferenceMap(PortletPreferences prefs) {
        Map<String, Preference> m;
        Enumeration e = prefs.getNames();
        if (e.hasMoreElements()) {
            m = new HashMap();
            while (e.hasMoreElements()) {
                String name = (String)e.nextElement();
                m.put(name, new PreferenceImpl(prefs, name));
            }
        } else {
            m = Collections.emptyMap();
        }
        return m;
    }

    private Map<String, Object> getHttpSessionMap(ExternalContext extCtx, PortletELContextImpl bridgeContext) {
        PortletSessionMap sessionMap = bridgeContext.getHttpSessionMap();
        if (sessionMap == null) {
            sessionMap = new PortletSessionMap(extCtx.getRequest(), 1);
            bridgeContext.setHttpSessionMap(sessionMap);
        }
        return sessionMap;
    }

    private Map getMutablePortletPreferencesValues(ExternalContext extCtx, PortletELContextImpl bridgeContext) {
        Map<String, Preference> preferencesValuesMap = bridgeContext.getMutablePortletPreferencesMap();
        if (preferencesValuesMap == null) {
            preferencesValuesMap = this.getPreferenceMap(((PortletRequest)extCtx.getRequest()).getPreferences());
            bridgeContext.setMutablePortletPreferencesMap(preferencesValuesMap);
        }
        return preferencesValuesMap;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum BRIDGE_IMPLICT_OBJECTS_ENUM {
        portletConfig,
        renderRequest,
        renderResponse,
        httpSessionScope,
        portletSession,
        portletSessionScope,
        mutablePortletPreferencesValues,
        portletPreferences,
        portletPreferencesValues;

    }
}

