/* Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package org.apache.myfaces.portlet.faces.signature;

import org.junit.Test;
import java.lang.reflect.Method;
import javax.portlet.faces.GenericFacesPortlet;

import static junit.framework.Assert.assertTrue;
import static junit.framework.Assert.fail;

public class GenericFacesPortletSignatureTest 
{
  private void testSignature(String methodName,
                             Class expectedReturnType,
                             Class<?>... parameters)
  {
    Class actualReturnType = null;

    try
    {
      Class facesClass = Class.forName("javax.portlet.faces.GenericFacesPortlet");
      Method method = facesClass.getMethod(methodName, parameters);

      actualReturnType = method.getReturnType();

      if (actualReturnType.equals(expectedReturnType))
      {
        assertTrue(true);
      }
      else
      {
        fail("public void " + expectedReturnType + " " + methodName + " not found in GenericFacesPortlet.");
      }

    }
    catch (Exception e)
    {
        fail("public void " + expectedReturnType + " " + methodName + " not found in GenericFacesPortlet.");
    }
  }

  @Test
  public void getBridgeClassName()
  {
    try
    {
      testSignature("getBridgeClassName", Class.forName("java.lang.String"));
    }
    catch (ClassNotFoundException cnfe)
    {}
  }

  @Test
  public void getDefaultViewIdMap()
  {
    try
    {
      testSignature("getDefaultViewIdMap", Class.forName("java.util.Map"));
    }
    catch (ClassNotFoundException cnfe)
    {}
  }

  @Test
  public void getExcludedRequestAttributes()
  {
    try
    {
      testSignature("getExcludedRequestAttributes", Class.forName("java.util.List"));
    }
    catch (ClassNotFoundException cnfe)
    {}
  }

  @Test
  public void isPreserveActionParameters()
  {
    testSignature("isPreserveActionParameters", Boolean.TYPE);
  }

  @Test
  public void getResponseContentType()
  {
    try
    {
      testSignature("getResponseContentType", Class.forName("java.lang.String"), Class.forName("javax.portlet.PortletRequest"));
    }
    catch (ClassNotFoundException cnfe)
    {}
  }

  @Test
  public void getResponseCharacterSetEncoding()
  {
    try
    {
      testSignature("getResponseCharacterSetEncoding", Class.forName("java.lang.String"), Class.forName("javax.portlet.PortletRequest"));
    }
    catch (ClassNotFoundException cnfe)
    {}
  }

  @Test
  public void getFacesBridge()
  {
    try
    {
      testSignature("getFacesBridge", Class.forName("javax.portlet.faces.Bridge"), Class.forName("javax.portlet.PortletRequest"), Class.forName("javax.portlet.PortletResponse"));
    }
    catch (ClassNotFoundException cnfe)
    {}
  }
}
