/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.webapp.filter;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.myfaces.webapp.filter.WelcomeFileHandler;
import org.xml.sax.helpers.DefaultHandler;

public class WelcomeFileFilter
implements Filter {
    private FilterConfig _config;
    private ServletContext _context;
    private String[] _welcomeFiles = new String[0];

    public void destroy() {
        this._config = null;
        this._context = null;
        this._welcomeFiles = null;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (this._config == null) {
            return;
        }
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        String uri = httpRequest.getRequestURI();
        if (uri.lastIndexOf(46) > uri.lastIndexOf(47)) {
            chain.doFilter(request, response);
            return;
        }
        String contextPath = httpRequest.getContextPath();
        String welcomeFile = null;
        StringBuffer sb = new StringBuffer(uri);
        if (!uri.endsWith("/")) {
            sb.append('/');
        }
        String baseURI = sb.delete(0, contextPath.length()).toString();
        for (int i = 0; i < this._welcomeFiles.length; ++i) {
            sb.setLength(0);
            sb.append(baseURI).append(this._welcomeFiles[i]);
            File file = new File(this._context.getRealPath(sb.toString()));
            if (!file.exists()) continue;
            if (!this._welcomeFiles[i].endsWith(".jsp")) break;
            sb.replace(sb.lastIndexOf(".jsp"), sb.length(), ".jsf");
            welcomeFile = sb.toString();
            break;
        }
        if (welcomeFile == null) {
            sb.setLength(0);
            sb.append(baseURI);
            sb.append("index.jsf");
            welcomeFile = sb.toString();
        }
        RequestDispatcher rd = httpRequest.getRequestDispatcher(welcomeFile);
        rd.forward(request, response);
    }

    public void init(FilterConfig config) throws ServletException {
        if (config == null) {
            return;
        }
        this._config = config;
        this._context = config.getServletContext();
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setValidating(false);
            factory.setNamespaceAware(false);
            SAXParser parser = factory.newSAXParser();
            WelcomeFileHandler handler = new WelcomeFileHandler();
            InputStream is = this._context.getResourceAsStream("WEB-INF/web.xml");
            if (is == null) {
                this._context.log("Unable to get inputstream for web.xml");
            }
            parser.parse(is, (DefaultHandler)handler);
            this._welcomeFiles = handler.getWelcomeFiles();
            this._context.log("Number of welcome files: " + this._welcomeFiles.length);
        }
        catch (Exception ex) {
            throw new ServletException((Throwable)ex);
        }
    }
}

