/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.share.config;

import java.io.File;
import java.util.Hashtable;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;
import org.apache.myfaces.trinidadinternal.share.config.Configuration;
import org.apache.myfaces.trinidadinternal.share.config.DirectoryUnavailableException;

public class ConfigurationImpl
extends Configuration {
    private Hashtable<Object, Object> _paths = new Hashtable(11);
    private Hashtable<Object, String> _uris = new Hashtable(11);
    private Hashtable<Object, String> _resolvedURIs = new Hashtable(11);
    private Hashtable<Object, String> _resolvedPaths = new Hashtable(11);
    private Hashtable<Object, Object> _properties = new Hashtable(11);
    private boolean _debug;
    private static final String _DEFAULT_BASE_DIRECTORY = "/adf/";
    private static final String _DEFAULT_IMAGES_SUBDIRECTORY = "images/";
    private static final String _DEFAULT_JSLIBS_SUBDIRECTORY = "jsLibs/";
    private static final String _DEFAULT_JSPS_SUBDIRECTORY = "jsps/";
    private static final String _DEFAULT_STYLES_SUBDIRECTORY = "styles/";
    private static final String _DEFAULT_CACHE_SUBDIRECTORY = "cache/";
    private static final String _URI_DELIMITER = "/";
    private static final char _URI_DELIMITER_CHAR = "/".charAt(0);
    private static final String _DEFAULT_IMAGES_SUBPATH = "images/".replace(_URI_DELIMITER_CHAR, File.separatorChar);
    private static final String _DEFAULT_JSLIBS_SUBPATH = "jsLibs/".replace(_URI_DELIMITER_CHAR, File.separatorChar);
    private static final String _DEFAULT_JSPS_SUBPATH = "jsps/".replace(_URI_DELIMITER_CHAR, File.separatorChar);
    private static final String _DEFAULT_STYLES_SUBPATH = "styles/".replace(_URI_DELIMITER_CHAR, File.separatorChar);
    private static final String _DEFAULT_CACHE_SUBPATH = "cache/".replace(_URI_DELIMITER_CHAR, File.separatorChar);
    private static final Object _NULL_PATH = new Object();
    private static final TrinidadLogger _LOG = TrinidadLogger.createTrinidadLogger(ConfigurationImpl.class);

    @Override
    public boolean isDebug() {
        return this._debug;
    }

    public void setDebug(boolean debug) {
        this._debug = debug;
    }

    ConfigurationImpl() {
    }

    @Override
    public String getURI(Object key, String contextURI) {
        String uri = this._getURI(key);
        if (this._isContextURI(uri)) {
            if (contextURI == null) {
                throw new DirectoryUnavailableException(_LOG.getMessage("NULL_CONTEXT_URL"), key);
            }
            if (contextURI.endsWith(_URI_DELIMITER)) {
                throw new IllegalArgumentException(_LOG.getMessage("CONTEXT_URI_ENDS_WITH_SLASH", key));
            }
            return contextURI + uri;
        }
        if (uri.indexOf(58) < 0) {
            return _URI_DELIMITER + uri;
        }
        return uri;
    }

    @Override
    public String getPath(Object key, String contextPath) {
        String uri = this._getURI(key);
        if (!this._isContextURI(uri)) {
            return this._getPath(key);
        }
        if (contextPath == null) {
            throw new DirectoryUnavailableException(_LOG.getMessage("NULL_CONTEXTPATH"), key);
        }
        if (contextPath.endsWith(File.separator)) {
            contextPath = contextPath.substring(0, contextPath.length() - 1);
        }
        return contextPath + uri.replace(_URI_DELIMITER_CHAR, File.separatorChar);
    }

    @Override
    public Object getProperty(Object key) {
        return this._properties.get(key);
    }

    public void putFullURIAndPath(Object key, String uri, String path) {
        if (uri == null) {
            throw new NullPointerException(_LOG.getMessage("REGISTERED_NULL_URI"));
        }
        if ((uri = this._endWithDelimiter(uri)).startsWith(_URI_DELIMITER)) {
            uri = uri.substring(1);
        }
        this._uris.put(key, uri);
        this._resolvedURIs.clear();
        if (path == null) {
            this._paths.put(key, _NULL_PATH);
        } else {
            if (!path.endsWith(File.separator)) {
                path = path + File.separator;
            }
            this._paths.put(key, path);
        }
    }

    public void putRelativeURI(Object key, String uri) {
        if (uri == null) {
            throw new NullPointerException(_LOG.getMessage("REGISTERED_NULL_URI"));
        }
        if ((uri = this._endWithDelimiter(uri)).indexOf(58) < 0 && uri.charAt(0) != _URI_DELIMITER_CHAR) {
            uri = _URI_DELIMITER + uri;
        }
        this._uris.put(key, uri);
        this._resolvedURIs.clear();
        this._paths.remove(key);
    }

    public void putProperty(Object key, Object value) {
        if (value == null) {
            this._properties.remove(key);
        } else {
            this._properties.put(key, value);
        }
    }

    private boolean _isContextURI(String uri) {
        return uri != null && uri.length() > 0 && uri.charAt(0) == _URI_DELIMITER_CHAR;
    }

    private String _endWithDelimiter(String uri) {
        if (!uri.endsWith(_URI_DELIMITER)) {
            uri = uri + _URI_DELIMITER;
        }
        return uri;
    }

    private String _getURI(Object key) {
        String uri = this._resolvedURIs.get(key);
        if (uri != null) {
            return uri;
        }
        uri = this._uris.get(key);
        if (uri == null) {
            if (BASE_DIRECTORY.equals(key)) {
                uri = _DEFAULT_BASE_DIRECTORY;
            } else if (IMAGES_DIRECTORY.equals(key)) {
                uri = this._getURI(BASE_DIRECTORY) + _DEFAULT_IMAGES_SUBDIRECTORY;
            } else if (IMAGES_CACHE_DIRECTORY.equals(key)) {
                uri = this._getURI(IMAGES_DIRECTORY) + _DEFAULT_CACHE_SUBDIRECTORY;
            } else if (STYLES_DIRECTORY.equals(key)) {
                uri = this._getURI(BASE_DIRECTORY) + _DEFAULT_STYLES_SUBDIRECTORY;
            } else if (STYLES_CACHE_DIRECTORY.equals(key)) {
                uri = this._getURI(STYLES_DIRECTORY) + _DEFAULT_CACHE_SUBDIRECTORY;
            } else if (JSLIBS_DIRECTORY.equals(key)) {
                uri = this._getURI(BASE_DIRECTORY) + _DEFAULT_JSLIBS_SUBDIRECTORY;
            } else if (JSPS_DIRECTORY.equals(key)) {
                uri = this._getURI(BASE_DIRECTORY) + _DEFAULT_JSPS_SUBDIRECTORY;
            }
        }
        assert (uri != null);
        this._resolvedURIs.put(key, uri);
        return uri;
    }

    private String _getPath(Object key) {
        String path = this._resolvedPaths.get(key);
        if (path != null) {
            return path;
        }
        Object o = this._paths.get(key);
        if (o == _NULL_PATH) {
            throw new IllegalStateException(_LOG.getMessage("NULL_PATH_REGISTERED", key));
        }
        path = (String)o;
        if (path == null) {
            if (BASE_DIRECTORY.equals(key)) {
                throw new IllegalStateException(_LOG.getMessage("NO_BASE_PATH_REGISTERED"));
            }
            if (IMAGES_DIRECTORY.equals(key)) {
                path = this._getPath(BASE_DIRECTORY) + _DEFAULT_IMAGES_SUBPATH;
            } else if (IMAGES_CACHE_DIRECTORY.equals(key)) {
                path = this._getPath(IMAGES_DIRECTORY) + _DEFAULT_CACHE_SUBPATH;
            } else if (STYLES_DIRECTORY.equals(key)) {
                path = this._getPath(BASE_DIRECTORY) + _DEFAULT_STYLES_SUBPATH;
            } else if (STYLES_CACHE_DIRECTORY.equals(key)) {
                path = this._getPath(STYLES_DIRECTORY) + _DEFAULT_CACHE_SUBPATH;
            } else if (JSLIBS_DIRECTORY.equals(key)) {
                path = this._getPath(BASE_DIRECTORY) + _DEFAULT_JSLIBS_SUBPATH;
            } else if (JSPS_DIRECTORY.equals(key)) {
                path = this._getPath(BASE_DIRECTORY) + _DEFAULT_JSPS_SUBPATH;
            }
        }
        assert (path != null);
        this._resolvedPaths.put(key, path);
        return path;
    }
}

