/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidad.component;

import java.util.List;
import javax.el.MethodExpression;
import javax.faces.component.NamingContainer;
import javax.faces.context.FacesContext;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.FacesEvent;
import org.apache.myfaces.trinidad.bean.FacesBean;
import org.apache.myfaces.trinidad.bean.PropertyKey;
import org.apache.myfaces.trinidad.component.FacesBeanWrapper;
import org.apache.myfaces.trinidad.component.TableUtils;
import org.apache.myfaces.trinidad.component.UIXIterator;
import org.apache.myfaces.trinidad.event.RowDisclosureEvent;
import org.apache.myfaces.trinidad.event.RowDisclosureListener;
import org.apache.myfaces.trinidad.event.SelectionEvent;
import org.apache.myfaces.trinidad.event.SelectionListener;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;
import org.apache.myfaces.trinidad.model.CollectionModel;
import org.apache.myfaces.trinidad.model.RowKeySet;
import org.apache.myfaces.trinidad.model.RowKeySetImpl;
import org.apache.myfaces.trinidad.model.RowKeySetTreeImpl;
import org.apache.myfaces.trinidad.model.TreeModel;

public class UIXListView
extends UIXIterator
implements NamingContainer {
    public static final FacesBean.Type TYPE = new FacesBean.Type(UIXIterator.TYPE);
    public static final PropertyKey SELECTED_ROW_KEYS_KEY = TYPE.registerKey("selectedRowKeys", RowKeySet.class, null, 0, PropertyKey.Mutable.OFTEN);
    public static final PropertyKey GROUP_DISCLOSED_ROW_KEYS_KEY = TYPE.registerKey("groupDisclosedRowKeys", RowKeySet.class, null, 0, PropertyKey.Mutable.OFTEN);
    public static final PropertyKey SELECTION_LISTENER_KEY = TYPE.registerKey("selectionListener", MethodExpression.class);
    public static final PropertyKey GROUP_DISCLOSURE_LISTENER_KEY = TYPE.registerKey("groupDisclosureListener", MethodExpression.class);
    public static final String COMPONENT_FAMILY = "org.apache.myfaces.trinidad.ListView";
    public static final String COMPONENT_TYPE = "org.apache.myfaces.trinidad.ListView";
    private static final PropertyKey _GROUP_DISCLOSED_ROW_KEYS_WITHOUT_MODEL_KEY = TYPE.registerKey("groupDisclosedRowKeysWithoutModel", RowKeySet.class);
    private static final PropertyKey _SELECTED_ROW_KEYS_WITHOUT_MODEL_KEY = TYPE.registerKey("selectedRowKeysWithoutModel", RowKeySet.class);
    private static final TrinidadLogger _LOG = TrinidadLogger.createTrinidadLogger(UIXListView.class);

    public UIXListView() {
        super("org.apache.myfaces.trinidad.ListView");
    }

    @Override
    public void queueEvent(FacesEvent event) {
        TableUtils.__handleQueueEvent(this, event);
        super.queueEvent(event);
    }

    @Override
    public void broadcast(FacesEvent event) throws AbortProcessingException {
        if (event instanceof SelectionEvent) {
            this.addAttributeChange("selectedRowKeys", this.getSelectedRowKeys());
            this.broadcastToMethodExpression(event, this.getSelectionListener());
        } else if (event instanceof RowDisclosureEvent) {
            RowDisclosureEvent dEvent = (RowDisclosureEvent)event;
            RowKeySet state = this.getGroupDisclosedRowKeys();
            state.removeAll(dEvent.getRemovedSet());
            state.addAll(dEvent.getAddedSet());
            this.addAttributeChange("groupDisclosedRowKeys", state);
            this.broadcastToMethodExpression(event, this.getGroupDisclosureListener());
        }
        super.broadcast(event);
    }

    @Override
    protected void postCreateCollectionModel(CollectionModel model) {
        RowKeySet disclosedRowKeys;
        RowKeySet selectedRowKeys = this.getSelectedRowKeys();
        if (selectedRowKeys == null) {
            selectedRowKeys = model instanceof TreeModel ? new RowKeySetTreeImpl() : new RowKeySetImpl();
            this.setSelectedRowKeys(selectedRowKeys);
        }
        if ((disclosedRowKeys = this.getGroupDisclosedRowKeys()) == null) {
            disclosedRowKeys = model instanceof TreeModel ? new RowKeySetTreeImpl() : new RowKeySetImpl();
            this.setGroupDisclosedRowKeys(disclosedRowKeys);
        }
        selectedRowKeys.setCollectionModel(model);
        disclosedRowKeys.setCollectionModel(model);
    }

    @Override
    Object __getMyStampState() {
        Object[] state = new Object[5];
        state[0] = super.__getMyStampState();
        RowKeySet selectedRowKeys = (RowKeySet)this.getProperty(_SELECTED_ROW_KEYS_WITHOUT_MODEL_KEY);
        RowKeySet disclosedRowKeys = (RowKeySet)this.getProperty(_GROUP_DISCLOSED_ROW_KEYS_WITHOUT_MODEL_KEY);
        state[1] = selectedRowKeys;
        state[2] = disclosedRowKeys;
        state[3] = this.getFirst();
        state[4] = this.getRows();
        return state;
    }

    @Override
    void __setMyStampState(Object stampState) {
        Object[] state = (Object[])stampState;
        super.__setMyStampState(state[0]);
        this.setSelectedRowKeys((RowKeySet)state[1]);
        this.setGroupDisclosedRowKeys((RowKeySet)state[2]);
        this.setFirst((Integer)state[3]);
        this.setRows((Integer)state[4]);
    }

    @Override
    void __resetMyStampState() {
        super.__resetMyStampState();
        this.setSelectedRowKeys(null);
        this.setGroupDisclosedRowKeys(null);
    }

    @Override
    protected FacesBean createFacesBean(String rendererType) {
        return new RowKeyFacesBeanWrapper(super.createFacesBean(rendererType));
    }

    public final void enterContainer() {
        this.preRowDataChange();
        this._getTreeModel().enterContainer();
        this.postRowDataChange();
    }

    public final void exitContainer() {
        this.preRowDataChange();
        this._getTreeModel().exitContainer();
        this.postRowDataChange();
    }

    public final boolean isContainer() {
        return this._getTreeModel().isContainer();
    }

    public boolean isContainerEmpty() {
        return this._getTreeModel().isContainerEmpty();
    }

    public int getDepth() {
        return this._getTreeModel().getDepth();
    }

    public int getDepth(Object rowKey) {
        return this._getTreeModel().getDepth(rowKey);
    }

    public Object getContainerRowKey() {
        return this._getTreeModel().getContainerRowKey();
    }

    public Object getContainerRowKey(Object childKey) {
        return this._getTreeModel().getContainerRowKey(childKey);
    }

    public List<Object> getAllAncestorContainerRowKeys(Object childRowKey) {
        return this._getTreeModel().getAllAncestorContainerRowKeys(childRowKey);
    }

    private TreeModel _getTreeModel() {
        CollectionModel model = this.getCollectionModel();
        if (!(model instanceof TreeModel)) {
            throw new IllegalStateException(_LOG.getMessage("LISTVIEW_MODEL_NOT_TREEMODEL"));
        }
        return (TreeModel)model;
    }

    public final RowKeySet getSelectedRowKeys() {
        return (RowKeySet)this.getProperty(SELECTED_ROW_KEYS_KEY);
    }

    public final void setSelectedRowKeys(RowKeySet selectedRowKeys) {
        this.setProperty(SELECTED_ROW_KEYS_KEY, selectedRowKeys);
    }

    public final RowKeySet getGroupDisclosedRowKeys() {
        return (RowKeySet)this.getProperty(GROUP_DISCLOSED_ROW_KEYS_KEY);
    }

    public final void setGroupDisclosedRowKeys(RowKeySet groupDisclosedRowKeys) {
        this.setProperty(GROUP_DISCLOSED_ROW_KEYS_KEY, groupDisclosedRowKeys);
    }

    public final MethodExpression getSelectionListener() {
        return (MethodExpression)this.getProperty(SELECTION_LISTENER_KEY);
    }

    public final void setSelectionListener(MethodExpression selectionListener) {
        this.setProperty(SELECTION_LISTENER_KEY, selectionListener);
    }

    public final MethodExpression getGroupDisclosureListener() {
        return (MethodExpression)this.getProperty(GROUP_DISCLOSURE_LISTENER_KEY);
    }

    public final void setGroupDisclosureListener(MethodExpression groupDisclosureListener) {
        this.setProperty(GROUP_DISCLOSURE_LISTENER_KEY, groupDisclosureListener);
    }

    public final void addSelectionListener(SelectionListener listener) {
        this.addFacesListener(listener);
    }

    public final void removeSelectionListener(SelectionListener listener) {
        this.removeFacesListener(listener);
    }

    public final SelectionListener[] getSelectionListeners() {
        return (SelectionListener[])this.getFacesListeners(SelectionListener.class);
    }

    public final void addRowDisclosureListener(RowDisclosureListener listener) {
        this.addFacesListener(listener);
    }

    public final void removeRowDisclosureListener(RowDisclosureListener listener) {
        this.removeFacesListener(listener);
    }

    public final RowDisclosureListener[] getRowDisclosureListeners() {
        return (RowDisclosureListener[])this.getFacesListeners(RowDisclosureListener.class);
    }

    @Override
    public String getFamily() {
        return "org.apache.myfaces.trinidad.ListView";
    }

    @Override
    protected FacesBean.Type getBeanType() {
        return TYPE;
    }

    protected UIXListView(String rendererType) {
        super(rendererType);
    }

    static {
        TYPE.lockAndRegister("org.apache.myfaces.trinidad.ListView", "org.apache.myfaces.trinidad.ListView");
    }

    private class RowKeyFacesBeanWrapper
    extends FacesBeanWrapper {
        private boolean _retrievingDisclosedRows;
        private boolean _retrievingSelectedRows;

        RowKeyFacesBeanWrapper(FacesBean bean) {
            super(bean);
            this._retrievingDisclosedRows = false;
            this._retrievingSelectedRows = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object getProperty(PropertyKey key) {
            if (key == _GROUP_DISCLOSED_ROW_KEYS_WITHOUT_MODEL_KEY) {
                return super.getProperty(GROUP_DISCLOSED_ROW_KEYS_KEY);
            }
            if (key == _SELECTED_ROW_KEYS_WITHOUT_MODEL_KEY) {
                return super.getProperty(SELECTED_ROW_KEYS_KEY);
            }
            Object value = super.getProperty(key);
            if (key == GROUP_DISCLOSED_ROW_KEYS_KEY) {
                if (!this._retrievingDisclosedRows && value instanceof RowKeySet) {
                    this._retrievingDisclosedRows = true;
                    try {
                        RowKeySet rowKeys = (RowKeySet)value;
                        rowKeys.setCollectionModel(UIXListView.this.getCollectionModel());
                    }
                    finally {
                        this._retrievingDisclosedRows = false;
                    }
                }
            } else if (key == SELECTED_ROW_KEYS_KEY && !this._retrievingSelectedRows && value instanceof RowKeySet) {
                this._retrievingSelectedRows = true;
                try {
                    RowKeySet rowKeys = (RowKeySet)value;
                    rowKeys.setCollectionModel(UIXListView.this.getCollectionModel());
                }
                finally {
                    this._retrievingSelectedRows = false;
                }
            }
            return value;
        }

        @Override
        public Object saveState(FacesContext context) {
            RowKeySet rowKeys = (RowKeySet)super.getProperty(GROUP_DISCLOSED_ROW_KEYS_KEY);
            if (rowKeys != null) {
                rowKeys.setCollectionModel(null);
            }
            if ((rowKeys = (RowKeySet)super.getProperty(SELECTED_ROW_KEYS_KEY)) != null) {
                rowKeys.setCollectionModel(null);
            }
            return super.saveState(context);
        }
    }
}

