/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.jdk;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import jpt.sun.source.tree.ClassTree;
import jpt.sun.source.tree.NewClassTree;
import jpt.sun.source.tree.Tree;
import jpt.sun.source.util.TreePath;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.java.hints.jdk.Bundle;
import org.netbeans.modules.java.hints.jdk.ConvertToLambdaConverter;
import org.netbeans.modules.java.hints.jdk.ConvertToLambdaPreconditionChecker;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.java.hints.ErrorDescriptionFactory;
import org.netbeans.spi.java.hints.HintContext;
import org.netbeans.spi.java.hints.JavaFix;

public class ConvertToLambda {
    public static final String ID = "Javac_canUseLambda";
    public static final Set<String> CODES = new HashSet<String>(Arrays.asList("compiler.warn.potential.lambda.found"));
    static final boolean DEF_PREFER_MEMBER_REFERENCES = true;
    static final String KEY_PREFER_MEMBER_REFERENCES = "prefer-member-references";

    public static ErrorDescription computeAnnonymousToLambda(HintContext ctx) {
        ClassTree clazz = ((NewClassTree)ctx.getPath().getLeaf()).getClassBody();
        ConvertToLambdaPreconditionChecker preconditionChecker = new ConvertToLambdaPreconditionChecker(ctx.getPath(), ctx.getInfo());
        if (!preconditionChecker.passesFatalPreconditions()) {
            return null;
        }
        FixImpl fix = new FixImpl(ctx.getInfo(), ctx.getPath(), false);
        if (ctx.getPreferences().getBoolean(KEY_PREFER_MEMBER_REFERENCES, true) && (preconditionChecker.foundMemberReferenceCandidate() || preconditionChecker.foundConstructorReferenceCandidate())) {
            return ErrorDescriptionFactory.forTree(ctx, ((NewClassTree)ctx.getPath().getLeaf()).getIdentifier(), Bundle.MSG_AnonymousConvertibleToLambda(), new FixImpl(ctx.getInfo(), ctx.getPath(), true).toEditorFix(), fix.toEditorFix());
        }
        return ErrorDescriptionFactory.forTree(ctx, ((NewClassTree)ctx.getPath().getLeaf()).getIdentifier(), Bundle.MSG_AnonymousConvertibleToLambda(), fix.toEditorFix());
    }

    private static final class FixImpl
    extends JavaFix {
        private final boolean useMemberReference;

        public FixImpl(CompilationInfo info, TreePath path, boolean useMemberReference) {
            super(info, path);
            this.useMemberReference = useMemberReference;
        }

        @Override
        public String getText() {
            return this.useMemberReference ? Bundle.FIX_ConvertToMemberReference() : Bundle.FIX_ConvertToLambda();
        }

        @Override
        protected void performRewrite(JavaFix.TransformationContext ctx) throws IOException {
            WorkingCopy copy = ctx.getWorkingCopy();
            copy.toPhase(JavaSource.Phase.RESOLVED);
            TreePath tp = ctx.getPath();
            if (tp.getLeaf().getKind() != Tree.Kind.NEW_CLASS) {
                return;
            }
            ConvertToLambdaConverter converter = new ConvertToLambdaConverter(tp, copy);
            if (this.useMemberReference) {
                converter.performRewriteToMemberReference();
            } else {
                converter.performRewriteToLambda();
            }
        }
    }
}

