/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.spiimpl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import jpt.sun.source.util.TreePath;
import jpt30.lang.model.type.TypeMirror;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.ModificationResult;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.api.project.Project;
import org.netbeans.modules.java.hints.spiimpl.batch.BatchUtilities;
import org.netbeans.modules.java.source.JavaSourceAccessor;
import org.netbeans.modules.refactoring.spi.RefactoringElementImplementation;
import org.netbeans.spi.editor.hints.ChangeInfo;
import org.netbeans.spi.editor.hints.EnhancedFix;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.java.hints.HintContext;
import org.netbeans.spi.java.hints.JavaFix;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;

public class JavaFixImpl
implements Fix {
    public final JavaFix jf;

    public JavaFixImpl(JavaFix jf) {
        this.jf = jf;
    }

    @Override
    public String getText() {
        return Accessor.INSTANCE.getText(this.jf);
    }

    @Override
    public ChangeInfo implement() throws Exception {
        FileObject file = Accessor.INSTANCE.getFile(this.jf);
        BatchUtilities.fixDependencies(file, Collections.singletonList(this.jf), new IdentityHashMap<Project, Set<String>>());
        JavaSource js = JavaSource.forFileObject(file);
        ModificationResult result = js.runModificationTask(wc -> {
            if (wc.toPhase(JavaSource.Phase.RESOLVED).compareTo(JavaSource.Phase.RESOLVED) < 0) {
                return;
            }
            HashMap<FileObject, byte[]> resourceContentChanges = new HashMap<FileObject, byte[]>();
            Accessor.INSTANCE.process(this.jf, (WorkingCopy)wc, true, (Map<FileObject, byte[]>)resourceContentChanges, new ArrayList());
            HashMap<FileObject, List<ModificationResult.Difference>> resourceContentDiffs = new HashMap<FileObject, List<ModificationResult.Difference>>();
            BatchUtilities.addResourceContentChanges(resourceContentChanges, resourceContentDiffs);
            JavaSourceAccessor.getINSTANCE().createModificationResult(resourceContentDiffs, Collections.emptyMap()).commit();
        });
        result.commit();
        Function<ModificationResult, ChangeInfo> convertor = Accessor.INSTANCE.getChangeInfoConvertor(this.jf);
        return convertor != null ? convertor.apply(result) : null;
    }

    public boolean equals(Object obj) {
        if (obj instanceof JavaFixImpl) {
            return this.jf.equals(((JavaFixImpl)obj).jf);
        }
        return super.equals(obj);
    }

    public int hashCode() {
        return this.jf.hashCode();
    }

    public static abstract class Accessor {
        public static Accessor INSTANCE;

        public abstract String getText(JavaFix var1);

        public abstract String getSortText(JavaFix var1);

        public abstract ChangeInfo process(JavaFix var1, WorkingCopy var2, boolean var3, Map<FileObject, byte[]> var4, Collection<? super RefactoringElementImplementation> var5) throws Exception;

        public abstract FileObject getFile(JavaFix var1);

        public abstract Map<String, String> getOptions(JavaFix var1);

        public abstract Fix rewriteFix(CompilationInfo var1, String var2, TreePath var3, String var4, Map<String, TreePath> var5, Map<String, Collection<? extends TreePath>> var6, Map<String, String> var7, Map<String, TypeMirror> var8, Map<String, String> var9, String ... var10);

        public abstract Fix createSuppressWarningsFix(CompilationInfo var1, TreePath var2, String ... var3);

        public abstract List<Fix> createSuppressWarnings(CompilationInfo var1, TreePath var2, String ... var3);

        public abstract List<Fix> resolveDefaultFixes(HintContext var1, Fix ... var2);

        public abstract void setChangeInfoConvertor(JavaFix var1, Function<ModificationResult, ChangeInfo> var2);

        public abstract Function<ModificationResult, ChangeInfo> getChangeInfoConvertor(JavaFix var1);

        static {
            try {
                Class.forName(JavaFix.class.getCanonicalName(), true, JavaFix.class.getClassLoader());
            }
            catch (ClassNotFoundException ex) {
                Exceptions.printStackTrace(ex);
            }
        }
    }

    public static class EnhancedJavaFixImpl
    extends JavaFixImpl
    implements EnhancedFix {
        public EnhancedJavaFixImpl(JavaFix jf) {
            super(jf);
        }

        @Override
        public CharSequence getSortText() {
            return Accessor.INSTANCE.getSortText(this.jf);
        }
    }
}

