/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.spiimpl;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.modules.java.hints.providers.spi.ClassPathBasedHintProvider;
import org.netbeans.modules.java.hints.providers.spi.ElementBasedHintProvider;
import org.netbeans.modules.java.hints.providers.spi.HintDescription;
import org.netbeans.modules.java.hints.providers.spi.HintMetadata;
import org.netbeans.modules.java.hints.providers.spi.HintProvider;
import org.netbeans.modules.java.hints.spiimpl.RulesManager;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;

public class RulesManagerImpl
extends RulesManager {
    private final Map<HintMetadata, Collection<HintDescription>> globalHints = new HashMap<HintMetadata, Collection<HintDescription>>();
    private final Map<ClasspathInfo, Reference<Holder>> compoundPathCache = new WeakHashMap<ClasspathInfo, Reference<Holder>>();

    public RulesManagerImpl() {
        this.reload();
    }

    @Override
    public void reload() {
        this.globalHints.clear();
        for (HintProvider p : Lookup.getDefault().lookupAll(HintProvider.class)) {
            Map<HintMetadata, ? extends Collection<? extends HintDescription>> pHints = p.computeHints();
            if (pHints == null) continue;
            for (Map.Entry<HintMetadata, ? extends Collection<? extends HintDescription>> e : pHints.entrySet()) {
                this.globalHints.put(e.getKey(), new ArrayList<HintDescription>(e.getValue()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<HintMetadata, ? extends Collection<? extends HintDescription>> readHints(CompilationInfo info, Collection<? extends ClassPath> from, AtomicBoolean cancel) {
        ClassPath compound;
        HashMap<HintMetadata, Collection<HintDescription>> result = new HashMap<HintMetadata, Collection<HintDescription>>(this.globalHints);
        if (info != null) {
            for (ElementBasedHintProvider provider : Lookup.getDefault().lookupAll(ElementBasedHintProvider.class)) {
                RulesManagerImpl.sortByMetadata(provider.computeHints(info), result);
            }
        }
        if (from != null) {
            compound = ClassPathSupport.createProxyClassPath(from.toArray(new ClassPath[0]));
        } else if (info != null) {
            Map<ClasspathInfo, Reference<Holder>> map = this.compoundPathCache;
            synchronized (map) {
                Holder cp;
                ClasspathInfo cpInfo = info.getClasspathInfo();
                Reference<Holder> cpRef = this.compoundPathCache.get(cpInfo);
                if (cpRef != null && (cp = cpRef.get()) != null) {
                    compound = cp.compound;
                }
                Holder h = new Holder(cpInfo);
                this.compoundPathCache.put(cpInfo, new WeakReference<Holder>(h));
                compound = h.compound;
            }
        } else {
            compound = ClassPathSupport.createClassPath(new FileObject[0]);
        }
        for (ClassPathBasedHintProvider p : Lookup.getDefault().lookupAll(ClassPathBasedHintProvider.class)) {
            Collection<? extends HintDescription> hints = p.computeHints(compound, cancel);
            if (hints == null || cancel != null && cancel.get()) {
                return null;
            }
            RulesManagerImpl.sortByMetadata(hints, result);
        }
        return result;
    }

    public static void sortByMetadata(Collection<? extends HintDescription> listedHints, Map<HintMetadata, Collection<HintDescription>> into) {
        for (HintDescription hintDescription : listedHints) {
            Collection<HintDescription> h = into.get(hintDescription.getMetadata());
            if (h == null) {
                h = new ArrayList<HintDescription>();
                into.put(hintDescription.getMetadata(), h);
            }
            h.add(hintDescription);
        }
    }

    private static final class Holder
    implements ChangeListener {
        private final ClassPath compound;

        public Holder(ClasspathInfo cpInfo) {
            cpInfo.addChangeListener(this);
            LinkedList<ClassPath> cps = new LinkedList<ClassPath>();
            cps.add(cpInfo.getClassPath(ClasspathInfo.PathKind.BOOT));
            cps.add(cpInfo.getClassPath(ClasspathInfo.PathKind.COMPILE));
            cps.add(cpInfo.getClassPath(ClasspathInfo.PathKind.SOURCE));
            this.compound = ClassPathSupport.createProxyClassPath(cps.toArray(new ClassPath[0]));
        }

        @Override
        public void stateChanged(ChangeEvent e) {
        }
    }
}

