/*
 * Decompiled with CFR 0.152.
 */
package org.openide.filesystems;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openide.filesystems.AbstractFileSystem;
import org.openide.filesystems.AbstractFolder;
import org.openide.filesystems.ExternalUtil;
import org.openide.filesystems.FileAlreadyLockedException;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.MIMESupport;
import org.openide.util.WeakSet;

final class StreamPool {
    static final Logger LOG = Logger.getLogger(StreamPool.class.getName());
    private static Map<FileObject, StreamPool> fo2StreamPool = new WeakHashMap<FileObject, StreamPool>();
    private static Map<FileSystem, StreamPool> fs2StreamPool = new WeakHashMap<FileSystem, StreamPool>();
    private static Boolean annotateUnclosedStreams;
    private Set<InputStream> iStreams;
    private Set<OutputStream> oStreams;

    private StreamPool() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static InputStream createInputStream(final AbstractFolder fo) throws FileNotFoundException {
        InputStream retVal = null;
        Class<StreamPool> clazz = StreamPool.class;
        synchronized (StreamPool.class) {
            if (StreamPool.get(fo).waitForOutputStreamsClosed(fo, 2000)) {
                retVal = new NotifyInputStream(fo);
                StreamPool.get(fo).iStream().add(retVal);
                StreamPool.get(fo.getFileSystem()).iStream().add(retVal);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            if (retVal != null && retVal instanceof NotifyInputStream) {
                AbstractFileSystem abstractFileSystem = (AbstractFileSystem)fo.getFileSystem();
                ((NotifyInputStream)retVal).setOriginal(abstractFileSystem.info.inputStream(fo.getPath()));
            } else {
                retVal = new InputStream(){

                    @Override
                    public int read() throws IOException {
                        FileAlreadyLockedException alreadyLockedEx = new FileAlreadyLockedException(fo.getPath());
                        StreamPool.get(fo).annotate(alreadyLockedEx);
                        throw alreadyLockedEx;
                    }
                };
            }
            return retVal;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static OutputStream createOutputStream(final AbstractFolder fo, boolean fireFileChanged) throws IOException {
        OutputStream retVal = null;
        Class<StreamPool> clazz = StreamPool.class;
        synchronized (StreamPool.class) {
            if (StreamPool.get(fo).waitForInputStreamsClosed(fo, 2000) && StreamPool.get(fo).waitForOutputStreamsClosed(fo, 2000)) {
                retVal = new NotifyOutputStream(fo, fireFileChanged);
                StreamPool.get(fo).oStream().add(retVal);
                StreamPool.get(fo.getFileSystem()).oStream().add(retVal);
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            if (retVal != null && retVal instanceof NotifyOutputStream) {
                AbstractFileSystem abstractFileSystem = (AbstractFileSystem)fo.getFileSystem();
                ((NotifyOutputStream)retVal).setOriginal(abstractFileSystem.info.outputStream(fo.getPath()));
            } else {
                retVal = new OutputStream(){

                    @Override
                    public void write(int b) throws IOException {
                        FileAlreadyLockedException alreadyLockedEx = new FileAlreadyLockedException(fo.getPath());
                        StreamPool.get(fo).annotate(alreadyLockedEx);
                        throw alreadyLockedEx;
                    }
                };
            }
            return retVal;
        }
    }

    public static synchronized StreamPool find(FileObject fo) {
        return fo2StreamPool.get(fo);
    }

    public static synchronized StreamPool find(FileSystem fs) {
        return fs2StreamPool.get(fs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void annotate(Exception ex) {
        if (!StreamPool.annotateUnclosedStreams()) {
            return;
        }
        Class<StreamPool> clazz = StreamPool.class;
        synchronized (StreamPool.class) {
            Exception annotation;
            if (this.iStreams != null) {
                for (NotifyInputStream notifyInputStream : this.iStreams) {
                    annotation = notifyInputStream.getException();
                    if (annotation == null) continue;
                    ExternalUtil.annotate((Throwable)ex, annotation);
                }
            }
            if (this.oStreams != null) {
                for (NotifyOutputStream notifyOutputStream : this.oStreams) {
                    annotation = notifyOutputStream.getException();
                    if (annotation == null) continue;
                    ExternalUtil.annotate((Throwable)ex, annotation);
                }
            }
            // ** MonitorExit[clazz] (shouldn't be in output)
            return;
        }
    }

    public boolean isInputStreamOpen() {
        return StreamPool.isStreamOpen(this.iStreams);
    }

    public boolean isOutputStreamOpen() {
        return StreamPool.isStreamOpen(this.oStreams);
    }

    private boolean waitForInputStreamsClosed(FileObject fo, int timeInMs) {
        return StreamPool.waitForStreams(fo, timeInMs, this.iStreams);
    }

    private boolean waitForOutputStreamsClosed(FileObject fo, int timeInMs) {
        return StreamPool.waitForStreams(fo, timeInMs, this.oStreams);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean waitForStreams(FileObject fo, int timeInMs, Set<?> streams) {
        Class<StreamPool> clazz = StreamPool.class;
        synchronized (StreamPool.class) {
            if (StreamPool.isStreamOpen(streams)) {
                long wait;
                long till = System.currentTimeMillis() + (long)timeInMs;
                boolean interrupted = false;
                while ((wait = till - System.currentTimeMillis()) > 0L) {
                    try {
                        StreamPool.class.wait(wait);
                        break;
                    }
                    catch (InterruptedException ex) {
                        interrupted = true;
                    }
                }
                if (interrupted) {
                    Thread.currentThread().interrupt();
                }
                if (StreamPool.isStreamOpen(streams)) {
                    LOG.log(Level.FINE, "Open streams {0} for {1}", new Object[]{streams, fo});
                    // ** MonitorExit[var3_3] (shouldn't be in output)
                    return false;
                }
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return true;
        }
    }

    private static boolean isStreamOpen(Set<?> set) {
        return set != null && !set.isEmpty();
    }

    private static StreamPool get(FileObject fo) {
        StreamPool strPool = fo2StreamPool.get(fo);
        if (strPool == null) {
            strPool = new StreamPool();
            fo2StreamPool.put(fo, strPool);
        }
        return strPool;
    }

    private static StreamPool get(FileSystem fs) {
        StreamPool strPool = fs2StreamPool.get(fs);
        if (strPool == null) {
            strPool = new StreamPool();
            fs2StreamPool.put(fs, strPool);
        }
        return strPool;
    }

    private Set<InputStream> iStream() {
        if (this.iStreams == null) {
            this.iStreams = new WeakSet<InputStream>();
        }
        return this.iStreams;
    }

    private Set<OutputStream> oStream() {
        if (this.oStreams == null) {
            this.oStreams = new WeakSet<OutputStream>();
        }
        return this.oStreams;
    }

    private static void closeOutputStream(AbstractFolder fo, OutputStream os, boolean fireFileChanged) {
        StreamPool foPool = StreamPool.find(fo);
        StreamPool fsPool = StreamPool.find(fo.getFileSystem());
        Set<OutputStream> foSet = foPool != null ? foPool.oStreams : null;
        Set<OutputStream> fsSet = fsPool != null ? fsPool.oStreams : null;
        StreamPool.removeStreams(fsSet, foSet, os);
        StreamPool.removeStreamPools(fsPool, foPool, fo);
        fo.outputStreamClosed(fireFileChanged);
    }

    private static void closeInputStream(AbstractFolder fo, InputStream is) {
        StreamPool foPool = StreamPool.find(fo);
        StreamPool fsPool = StreamPool.find(fo.getFileSystem());
        Set<InputStream> foSet = foPool != null ? foPool.iStreams : null;
        Set<InputStream> fsSet = fsPool != null ? fsPool.iStreams : null;
        StreamPool.removeStreams(fsSet, foSet, is);
        StreamPool.removeStreamPools(fsPool, foPool, fo);
    }

    private static synchronized void removeStreams(Set fsSet, Set foSet, Object stream) {
        if (foSet != null) {
            foSet.remove(stream);
        }
        if (fsSet != null) {
            fsSet.remove(stream);
        }
    }

    private static synchronized void removeStreamPools(StreamPool fsPool, StreamPool foPool, AbstractFolder fo) {
        boolean isOStreamEmpty;
        boolean isIStreamEmpty = foPool == null || foPool.iStreams == null || foPool.iStreams.isEmpty();
        boolean bl = isOStreamEmpty = foPool == null || foPool.oStreams == null || foPool.oStreams.isEmpty();
        if (isIStreamEmpty && isOStreamEmpty) {
            fo2StreamPool.remove(fo);
        }
        isIStreamEmpty = fsPool == null || fsPool.iStreams == null || fsPool.iStreams.isEmpty();
        boolean bl2 = isOStreamEmpty = fsPool == null || fsPool.oStreams == null || fsPool.oStreams.isEmpty();
        if (isIStreamEmpty && isOStreamEmpty) {
            fs2StreamPool.remove(fo.getFileSystem());
        }
    }

    private static boolean annotateUnclosedStreams() {
        if (annotateUnclosedStreams != null) {
            return annotateUnclosedStreams;
        }
        String annotateProp = System.getProperty("org.openide.filesystems.annotateUnclosedStreams");
        annotateUnclosedStreams = Boolean.parseBoolean(annotateProp);
        boolean assertsOn = false;
        if (!$assertionsDisabled) {
            assertsOn = true;
            if (!true) {
                throw new AssertionError();
            }
        }
        if (assertsOn) {
            annotateUnclosedStreams = annotateProp == null ? true : !Boolean.FALSE.toString().equals(annotateProp);
        }
        return annotateUnclosedStreams;
    }

    private static final class NotifyInputStream
    extends FilterInputStream {
        private static final InputStream emptyIs = new ByteArrayInputStream(new byte[0]);
        private Exception ex;
        AbstractFolder fo;
        private boolean closed = false;

        public NotifyInputStream(AbstractFolder fo) {
            super(emptyIs);
            this.fo = fo;
            if (StreamPool.annotateUnclosedStreams()) {
                this.ex = new Exception();
            }
        }

        private void setOriginal(InputStream is) {
            this.in = is;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void close() throws IOException {
            if (this.closed) return;
            this.closed = true;
            this.ex = null;
            super.close();
            StreamPool.closeInputStream(this.fo, this);
            Class<StreamPool> clazz = StreamPool.class;
            synchronized (StreamPool.class) {
                if (StreamPool.get(this.fo).isInputStreamOpen()) return;
                StreamPool.class.notifyAll();
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
        }

        public Exception getException() {
            return this.ex;
        }
    }

    private static final class NotifyOutputStream
    extends FilterOutputStream {
        private static final OutputStream emptyOs = new ByteArrayOutputStream();
        private Exception ex;
        private boolean closed = false;
        AbstractFolder fo;
        private boolean fireFileChanged;

        public NotifyOutputStream(AbstractFolder fo, boolean fireFileChanged) {
            super(emptyOs);
            this.fo = fo;
            if (StreamPool.annotateUnclosedStreams()) {
                this.ex = new Exception();
            }
            this.fireFileChanged = fireFileChanged;
        }

        private void setOriginal(OutputStream os) {
            this.out = os;
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.out.write(b, off, len);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws IOException {
            if (!this.closed) {
                this.closed = true;
                this.ex = null;
                try {
                    this.out.flush();
                    super.close();
                }
                finally {
                    StreamPool.closeOutputStream(this.fo, this, this.fireFileChanged);
                    MIMESupport.freeCaches();
                    Class<StreamPool> clazz = StreamPool.class;
                    synchronized (StreamPool.class) {
                        StreamPool.class.notifyAll();
                        // ** MonitorExit[var1_1] (shouldn't be in output)
                    }
                }
            }
        }

        public Exception getException() {
            return this.ex;
        }
    }
}

