/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.kafka.connect;

import java.util.Map;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.nifi.kafka.connect.StatelessNiFiCommonConfig;
import org.apache.nifi.kafka.connect.validators.ConnectRegularExpressionValidator;

public class StatelessNiFiSourceConfig
extends StatelessNiFiCommonConfig {
    public static final String OUTPUT_PORT_NAME = "output.port";
    public static final String TOPIC_NAME = "topics";
    public static final String TOPIC_NAME_ATTRIBUTE = "topic.name.attribute";
    public static final String KEY_ATTRIBUTE = "key.attribute";
    public static final String HEADER_REGEX = "header.attribute.regex";
    public static final String STATE_MAP_KEY = "task.index";
    protected static final ConfigDef CONFIG_DEF = StatelessNiFiSourceConfig.createConfigDef();

    public StatelessNiFiSourceConfig(Map<?, ?> originals) {
        super(CONFIG_DEF, originals);
    }

    protected StatelessNiFiSourceConfig(ConfigDef definition, Map<?, ?> originals) {
        super(definition, originals);
    }

    public String getOutputPortName() {
        return this.getString(OUTPUT_PORT_NAME);
    }

    public String getTopicName() {
        return this.getString(TOPIC_NAME);
    }

    public String getTopicNameAttribute() {
        return this.getString(TOPIC_NAME_ATTRIBUTE);
    }

    public String getKeyAttribute() {
        return this.getString(KEY_ATTRIBUTE);
    }

    public String getHeaderRegex() {
        return this.getString(HEADER_REGEX);
    }

    public String getStateMapKey() {
        return (String)this.originalsStrings().get(STATE_MAP_KEY);
    }

    protected static ConfigDef createConfigDef() {
        ConfigDef configDef = new ConfigDef();
        StatelessNiFiCommonConfig.addCommonConfigElements(configDef);
        StatelessNiFiSourceConfig.addFlowConfigs(configDef);
        StatelessNiFiSourceConfig.addSourceConfigs(configDef);
        return configDef;
    }

    protected static void addFlowConfigs(ConfigDef configDef) {
        StatelessNiFiCommonConfig.addFlowConfigElements(configDef);
        configDef.define(OUTPUT_PORT_NAME, ConfigDef.Type.STRING, null, ConfigDef.Importance.HIGH, "The name of the Output Port to pull data from", "Flow", 100, ConfigDef.Width.NONE, "Output port name");
    }

    protected static void addSourceConfigs(ConfigDef configDef) {
        configDef.define(TOPIC_NAME, ConfigDef.Type.STRING, null, ConfigDef.Importance.HIGH, "The name of the Kafka topic to send data to. Either the topics or topic.name.attribute configuration must be specified.", "Record", 0, ConfigDef.Width.NONE, "Topic name");
        configDef.define(TOPIC_NAME_ATTRIBUTE, ConfigDef.Type.STRING, null, ConfigDef.Importance.MEDIUM, "Specifies the name of a FlowFile attribute to use for determining which Kafka Topic a FlowFile will be sent to. Either the topics or topic.name.attribute configuration must be specified. If both are specified, the topic.name.attribute will be preferred, but if a FlowFile does not have the specified attribute name, then the topics property will serve as the default topic name to use.", "Record", 1, ConfigDef.Width.NONE, "Topic name attribute");
        configDef.define(KEY_ATTRIBUTE, ConfigDef.Type.STRING, null, ConfigDef.Importance.MEDIUM, "Specifies the name of a FlowFile attribute to use for determining the Kafka Message key. If not specified, the message key will be null. If specified, the value of the attribute with the given name will be used as the message key.", "Record", 100, ConfigDef.Width.NONE, "Record key attribute");
        configDef.define(HEADER_REGEX, ConfigDef.Type.STRING, null, (ConfigDef.Validator)new ConnectRegularExpressionValidator(), ConfigDef.Importance.MEDIUM, "Specifies a Regular Expression to evaluate against all FlowFile attributes. Any attribute whose name matches the Regular Expression will be converted into a Kafka message header with the name of the attribute used as header key and the value of the attribute used as the header value.", "Record", 200, ConfigDef.Width.NONE, "Record header attribute regex");
    }
}

