/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.util;

import java.security.SecureRandom;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComponentIdGenerator {
    private static final Logger logger = LoggerFactory.getLogger(ComponentIdGenerator.class);
    public static final Object lock = new Object();
    private static long lastTime;
    private static long clockSequence;
    private static final SecureRandom randomGenerator;

    public static final UUID generateId() {
        return ComponentIdGenerator.generateId(System.currentTimeMillis());
    }

    public static final UUID generateId(long currentTime) {
        return ComponentIdGenerator.generateId(currentTime, randomGenerator.nextLong(), true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final UUID generateId(long msb, long lsb, boolean ensureUnique) {
        Object object = lock;
        synchronized (object) {
            if (ensureUnique && msb <= lastTime) {
                msb = ++lastTime;
            }
            lastTime = msb;
        }
        long time = msb;
        time = msb << 32;
        time |= (msb & 0xFFFF00000000L) >> 16;
        long clockSequenceHi = clockSequence;
        lsb = (clockSequenceHi <<= 48) | lsb;
        UUID uuid = new UUID(time |= 0x1000L | msb >> 48 & 0xFFFL, lsb);
        logger.debug("Generating UUID {} for msb={}, lsb={}, ensureUnique={}", new Object[]{uuid, msb, lsb, ensureUnique});
        return uuid;
    }

    static {
        clockSequence = 0L;
        randomGenerator = new SecureRandom();
    }
}

