/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.stream.io;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;

public class RepeatingInputStream
extends InputStream {
    private final byte[] toRepeat;
    private final int maxIterations;
    private InputStream bais;
    private int repeatCount;

    public RepeatingInputStream(byte[] toRepeat, int iterations) {
        if (iterations < 1) {
            throw new IllegalArgumentException();
        }
        if (Objects.requireNonNull(toRepeat).length == 0) {
            throw new IllegalArgumentException();
        }
        this.toRepeat = toRepeat;
        this.maxIterations = iterations;
        this.repeat();
        this.bais = new ByteArrayInputStream(toRepeat);
        this.repeatCount = 1;
    }

    @Override
    public int read() throws IOException {
        int value = this.bais.read();
        if (value > -1) {
            return value;
        }
        boolean repeated = this.repeat();
        if (repeated) {
            return this.bais.read();
        }
        return -1;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int value = this.bais.read(b, off, len);
        if (value > -1) {
            return value;
        }
        boolean repeated = this.repeat();
        if (repeated) {
            return this.bais.read(b, off, len);
        }
        return -1;
    }

    @Override
    public int read(byte[] b) throws IOException {
        int value = this.bais.read(b);
        if (value > -1) {
            return value;
        }
        boolean repeated = this.repeat();
        if (repeated) {
            return this.bais.read(b);
        }
        return -1;
    }

    private boolean repeat() {
        if (this.repeatCount >= this.maxIterations) {
            return false;
        }
        ++this.repeatCount;
        this.bais = new ByteArrayInputStream(this.toRepeat);
        return true;
    }
}

