/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller;

import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import org.apache.nifi.annotation.notification.PrimaryNodeState;
import org.apache.nifi.connectable.Funnel;
import org.apache.nifi.connectable.Port;
import org.apache.nifi.controller.ProcessorNode;
import org.apache.nifi.controller.ReportingTaskNode;
import org.apache.nifi.controller.service.ControllerServiceNode;
import org.apache.nifi.controller.service.ControllerServiceProvider;
import org.apache.nifi.groups.StatelessGroupNode;
import org.apache.nifi.scheduling.SchedulingStrategy;

public interface ProcessScheduler {
    public void shutdown();

    public void shutdownControllerService(ControllerServiceNode var1, ControllerServiceProvider var2);

    public void shutdownReportingTask(ReportingTaskNode var1);

    public Future<Void> startProcessor(ProcessorNode var1, boolean var2);

    public Future<Void> runProcessorOnce(ProcessorNode var1, Callable<Future<Void>> var2);

    public CompletableFuture<Void> stopProcessor(ProcessorNode var1);

    public void terminateProcessor(ProcessorNode var1);

    public void onProcessorRemoved(ProcessorNode var1);

    public Future<Void> startStatelessGroup(StatelessGroupNode var1);

    public CompletableFuture<Void> stopStatelessGroup(StatelessGroupNode var1);

    public void onPortRemoved(Port var1);

    public void onFunnelRemoved(Funnel var1);

    public void onReportingTaskRemoved(ReportingTaskNode var1);

    public void startPort(Port var1);

    public void stopPort(Port var1);

    public void startFunnel(Funnel var1);

    public void stopFunnel(Funnel var1);

    public void enableFunnel(Funnel var1);

    public void enablePort(Port var1);

    public void enableProcessor(ProcessorNode var1);

    public void disableFunnel(Funnel var1);

    public void disablePort(Port var1);

    public void disableProcessor(ProcessorNode var1);

    public int getActiveThreadCount(Object var1);

    public boolean isScheduled(Object var1);

    public void setMaxThreadCount(SchedulingStrategy var1, int var2);

    public void yield(ProcessorNode var1);

    public Future<Void> unschedule(ReportingTaskNode var1);

    public void schedule(ReportingTaskNode var1);

    public CompletableFuture<Void> enableControllerService(ControllerServiceNode var1);

    public CompletableFuture<Void> disableControllerServices(List<ControllerServiceNode> var1);

    public CompletableFuture<Void> disableControllerService(ControllerServiceNode var1);

    public Future<?> submitFrameworkTask(Runnable var1);

    public void notifyPrimaryNodeStateChange(ProcessorNode var1, PrimaryNodeState var2);

    public void notifyPrimaryNodeStateChange(ControllerServiceNode var1, PrimaryNodeState var2);

    public void notifyPrimaryNodeStateChange(ReportingTaskNode var1, PrimaryNodeState var2);
}

