/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.minifi.toolkit.schema;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.nifi.minifi.toolkit.schema.ComponentStatusRepositorySchema;
import org.apache.nifi.minifi.toolkit.schema.ConnectionSchema;
import org.apache.nifi.minifi.toolkit.schema.ContentRepositorySchema;
import org.apache.nifi.minifi.toolkit.schema.CorePropertiesSchema;
import org.apache.nifi.minifi.toolkit.schema.FlowControllerSchema;
import org.apache.nifi.minifi.toolkit.schema.FlowFileRepositorySchema;
import org.apache.nifi.minifi.toolkit.schema.ProcessGroupSchema;
import org.apache.nifi.minifi.toolkit.schema.ProvenanceReportingSchema;
import org.apache.nifi.minifi.toolkit.schema.ProvenanceRepositorySchema;
import org.apache.nifi.minifi.toolkit.schema.ReportingSchema;
import org.apache.nifi.minifi.toolkit.schema.SecurityPropertiesSchema;
import org.apache.nifi.minifi.toolkit.schema.common.BaseSchema;
import org.apache.nifi.minifi.toolkit.schema.common.BaseSchemaWithId;
import org.apache.nifi.minifi.toolkit.schema.common.BaseSchemaWithIdAndName;
import org.apache.nifi.minifi.toolkit.schema.common.CollectionOverlap;
import org.apache.nifi.minifi.toolkit.schema.common.ConvertableSchema;
import org.apache.nifi.minifi.toolkit.schema.common.StringUtil;
import org.apache.nifi.minifi.toolkit.schema.common.WritableSchema;

public class ConfigSchema
extends BaseSchema
implements WritableSchema,
ConvertableSchema<ConfigSchema> {
    public static final int CONFIG_VERSION = 3;
    public static final String VERSION = "MiNiFi Config Version";
    public static final String FOUND_THE_FOLLOWING_DUPLICATE_INPUT_PORT_IDS = "Found the following duplicate input port ids: ";
    public static final String FOUND_THE_FOLLOWING_DUPLICATE_OUTPUT_PORT_IDS = "Found the following duplicate output port ids: ";
    public static final String FOUND_THE_FOLLOWING_DUPLICATE_IDS = "Found the following ids that occur both in more than one Processor(s), Input Port(s), Output Port(s) and/or Remote Input Port(s): ";
    public static final String CONNECTION_WITH_ID = "Connection with id ";
    public static final String HAS_INVALID_SOURCE_ID = " has invalid source id ";
    public static final String HAS_INVALID_DESTINATION_ID = " has invalid destination id ";
    public static final String FOUND_THE_FOLLOWING_DUPLICATE_PROCESSOR_IDS = "Found the following duplicate processor ids: ";
    public static final String FOUND_THE_FOLLOWING_DUPLICATE_CONTROLLER_SERVICE_IDS = "Found the following duplicate controller service ids: ";
    public static final String FOUND_THE_FOLLOWING_DUPLICATE_CONNECTION_IDS = "Found the following duplicate connection ids: ";
    public static final String FOUND_THE_FOLLOWING_DUPLICATE_FUNNEL_IDS = "Found the following duplicate funnel ids: ";
    public static final String FOUND_THE_FOLLOWING_DUPLICATE_REPORTING_IDS = "Found the following duplicate reporting ids: ";
    public static String TOP_LEVEL_NAME = "top level";
    private FlowControllerSchema flowControllerProperties;
    private CorePropertiesSchema coreProperties;
    private FlowFileRepositorySchema flowfileRepositoryProperties;
    private ContentRepositorySchema contentRepositoryProperties;
    private ComponentStatusRepositorySchema componentStatusRepositoryProperties;
    private SecurityPropertiesSchema securityProperties;
    private ProcessGroupSchema processGroupSchema;
    private ProvenanceReportingSchema provenanceReportingProperties;
    private List<ReportingSchema> reportingTasks;
    private ProvenanceRepositorySchema provenanceRepositorySchema;
    private Map<String, String> nifiPropertiesOverrides;

    public ConfigSchema(Map map) {
        this(map, Collections.emptyList());
    }

    public ConfigSchema(Map map, List<String> validationIssues) {
        validationIssues.stream().forEach(this::addValidationIssue);
        this.flowControllerProperties = this.getMapAsType(map, "Flow Controller", FlowControllerSchema.class, TOP_LEVEL_NAME, true);
        this.coreProperties = this.getMapAsType(map, "Core Properties", CorePropertiesSchema.class, TOP_LEVEL_NAME, false);
        this.flowfileRepositoryProperties = this.getMapAsType(map, "FlowFile Repository", FlowFileRepositorySchema.class, TOP_LEVEL_NAME, false);
        this.contentRepositoryProperties = this.getMapAsType(map, "Content Repository", ContentRepositorySchema.class, TOP_LEVEL_NAME, false);
        this.provenanceRepositorySchema = this.getMapAsType(map, "Provenance Repository", ProvenanceRepositorySchema.class, TOP_LEVEL_NAME, false);
        this.componentStatusRepositoryProperties = this.getMapAsType(map, "Component Status Repository", ComponentStatusRepositorySchema.class, TOP_LEVEL_NAME, false);
        this.securityProperties = this.getMapAsType(map, "Security Properties", SecurityPropertiesSchema.class, TOP_LEVEL_NAME, false);
        this.processGroupSchema = new ProcessGroupSchema(map, TOP_LEVEL_NAME);
        this.provenanceReportingProperties = (ProvenanceReportingSchema)this.getMapAsType(map, "Provenance Reporting", ProvenanceReportingSchema.class, TOP_LEVEL_NAME, false, false);
        this.reportingTasks = this.getOptionalKeyAsList(map, "Reporting Tasks", ReportingSchema::new, TOP_LEVEL_NAME);
        this.nifiPropertiesOverrides = (Map)map.get("NiFi Properties Overrides");
        if (this.nifiPropertiesOverrides == null) {
            this.nifiPropertiesOverrides = new HashMap<String, String>();
        }
        this.addIssuesIfNotNull(this.flowControllerProperties);
        this.addIssuesIfNotNull(this.coreProperties);
        this.addIssuesIfNotNull(this.flowfileRepositoryProperties);
        this.addIssuesIfNotNull(this.contentRepositoryProperties);
        this.addIssuesIfNotNull(this.componentStatusRepositoryProperties);
        this.addIssuesIfNotNull(this.securityProperties);
        this.addIssuesIfNotNull(this.processGroupSchema);
        this.addIssuesIfNotNull(this.provenanceReportingProperties);
        this.addIssuesIfNotNull(this.reportingTasks);
        this.addIssuesIfNotNull(this.provenanceRepositorySchema);
        List<ProcessGroupSchema> allProcessGroups = ConfigSchema.getAllProcessGroups(this.processGroupSchema);
        List<ConnectionSchema> allConnectionSchemas = allProcessGroups.stream().flatMap(p -> p.getConnections().stream()).collect(Collectors.toList());
        List allRemoteProcessGroups = allProcessGroups.stream().flatMap(p -> p.getRemoteProcessGroups().stream()).collect(Collectors.toList());
        List<String> allProcessorIds = allProcessGroups.stream().flatMap(p -> p.getProcessors().stream()).map(BaseSchemaWithId::getId).collect(Collectors.toList());
        List<String> allControllerServiceIds = allProcessGroups.stream().flatMap(p -> p.getControllerServices().stream()).map(BaseSchemaWithId::getId).collect(Collectors.toList());
        List<String> allFunnelIds = allProcessGroups.stream().flatMap(p -> p.getFunnels().stream()).map(BaseSchemaWithId::getId).collect(Collectors.toList());
        List<String> allConnectionIds = allConnectionSchemas.stream().map(BaseSchemaWithId::getId).collect(Collectors.toList());
        List allRemoteProcessGroupNames = allRemoteProcessGroups.stream().map(BaseSchemaWithIdAndName::getName).collect(Collectors.toList());
        List allRemoteInputPortIds = allRemoteProcessGroups.stream().filter(r -> r.getInputPorts() != null).flatMap(r -> r.getInputPorts().stream()).map(BaseSchemaWithId::getId).collect(Collectors.toList());
        List allRemoteOutputPortIds = allRemoteProcessGroups.stream().filter(r -> r.getOutputPorts() != null).flatMap(r -> r.getOutputPorts().stream()).map(BaseSchemaWithId::getId).collect(Collectors.toList());
        List<String> allInputPortIds = allProcessGroups.stream().flatMap(p -> p.getInputPortSchemas().stream()).map(BaseSchemaWithId::getId).collect(Collectors.toList());
        List<String> allOutputPortIds = allProcessGroups.stream().flatMap(p -> p.getOutputPortSchemas().stream()).map(BaseSchemaWithId::getId).collect(Collectors.toList());
        List<String> allReportingIds = this.reportingTasks.stream().map(BaseSchemaWithId::getId).collect(Collectors.toList());
        ConfigSchema.checkForDuplicates(this::addValidationIssue, FOUND_THE_FOLLOWING_DUPLICATE_PROCESSOR_IDS, allProcessorIds);
        ConfigSchema.checkForDuplicates(this::addValidationIssue, FOUND_THE_FOLLOWING_DUPLICATE_CONTROLLER_SERVICE_IDS, allControllerServiceIds);
        ConfigSchema.checkForDuplicates(this::addValidationIssue, FOUND_THE_FOLLOWING_DUPLICATE_FUNNEL_IDS, allFunnelIds);
        ConfigSchema.checkForDuplicates(this::addValidationIssue, FOUND_THE_FOLLOWING_DUPLICATE_CONNECTION_IDS, allConnectionIds);
        ConfigSchema.checkForDuplicates(this::addValidationIssue, FOUND_THE_FOLLOWING_DUPLICATE_INPUT_PORT_IDS, allInputPortIds);
        ConfigSchema.checkForDuplicates(this::addValidationIssue, FOUND_THE_FOLLOWING_DUPLICATE_OUTPUT_PORT_IDS, allOutputPortIds);
        ConfigSchema.checkForDuplicates(this::addValidationIssue, FOUND_THE_FOLLOWING_DUPLICATE_REPORTING_IDS, allReportingIds);
        CollectionOverlap overlapResults = new CollectionOverlap(new HashSet<String>(allProcessorIds), new HashSet(allRemoteInputPortIds), new HashSet(allRemoteOutputPortIds), new HashSet<String>(allInputPortIds), new HashSet<String>(allOutputPortIds), new HashSet<String>(allFunnelIds));
        if (overlapResults.getDuplicates().size() > 0) {
            this.addValidationIssue(FOUND_THE_FOLLOWING_DUPLICATE_IDS + overlapResults.getDuplicates().stream().sorted().collect(Collectors.joining(", ")));
        }
        allConnectionSchemas.forEach(c -> {
            String sourceId;
            String destinationId = c.getDestinationId();
            if (!StringUtil.isNullOrEmpty(destinationId) && !overlapResults.getElements().contains(destinationId)) {
                this.addValidationIssue(CONNECTION_WITH_ID + c.getId() + HAS_INVALID_DESTINATION_ID + destinationId);
            }
            if (!StringUtil.isNullOrEmpty(sourceId = c.getSourceId()) && !overlapResults.getElements().contains(sourceId)) {
                this.addValidationIssue(CONNECTION_WITH_ID + c.getId() + HAS_INVALID_SOURCE_ID + sourceId);
            }
        });
    }

    public static List<ProcessGroupSchema> getAllProcessGroups(ProcessGroupSchema processGroupSchema) {
        ArrayList<ProcessGroupSchema> result = new ArrayList<ProcessGroupSchema>();
        ConfigSchema.addProcessGroups(processGroupSchema, result);
        return result;
    }

    private static void addProcessGroups(ProcessGroupSchema processGroupSchema, List<ProcessGroupSchema> result) {
        result.add(processGroupSchema);
        processGroupSchema.getProcessGroupSchemas().forEach(p -> ConfigSchema.addProcessGroups(p, result));
    }

    @Override
    public Map<String, Object> toMap() {
        Map result = (Map)this.mapSupplier.get();
        result.put(VERSION, this.getVersion());
        ConfigSchema.putIfNotNull(result, "Flow Controller", this.flowControllerProperties);
        ConfigSchema.putIfNotNull(result, "Core Properties", this.coreProperties);
        ConfigSchema.putIfNotNull(result, "FlowFile Repository", this.flowfileRepositoryProperties);
        ConfigSchema.putIfNotNull(result, "Content Repository", this.contentRepositoryProperties);
        ConfigSchema.putIfNotNull(result, "Provenance Repository", this.provenanceRepositorySchema);
        ConfigSchema.putIfNotNull(result, "Component Status Repository", this.componentStatusRepositoryProperties);
        ConfigSchema.putIfNotNull(result, "Security Properties", this.securityProperties);
        result.putAll(this.processGroupSchema.toMap());
        ConfigSchema.putIfNotNull(result, "Provenance Reporting", this.provenanceReportingProperties);
        if (!this.reportingTasks.isEmpty()) {
            ConfigSchema.putListIfNotNull(result, "Reporting Tasks", this.reportingTasks);
        }
        result.put("NiFi Properties Overrides", this.nifiPropertiesOverrides);
        return result;
    }

    public FlowControllerSchema getFlowControllerProperties() {
        return this.flowControllerProperties;
    }

    public void setFlowControllerProperties(FlowControllerSchema flowControllerProperties) {
        this.flowControllerProperties = flowControllerProperties;
    }

    public CorePropertiesSchema getCoreProperties() {
        return this.coreProperties;
    }

    public void setCoreProperties(CorePropertiesSchema coreProperties) {
        this.coreProperties = coreProperties;
    }

    public FlowFileRepositorySchema getFlowfileRepositoryProperties() {
        return this.flowfileRepositoryProperties;
    }

    public void setFlowfileRepositoryProperties(FlowFileRepositorySchema flowfileRepositoryProperties) {
        this.flowfileRepositoryProperties = flowfileRepositoryProperties;
    }

    public ContentRepositorySchema getContentRepositoryProperties() {
        return this.contentRepositoryProperties;
    }

    public void setContentRepositoryProperties(ContentRepositorySchema contentRepositoryProperties) {
        this.contentRepositoryProperties = contentRepositoryProperties;
    }

    public SecurityPropertiesSchema getSecurityProperties() {
        return this.securityProperties;
    }

    public void setSecurityProperties(SecurityPropertiesSchema securityProperties) {
        this.securityProperties = securityProperties;
    }

    public ProcessGroupSchema getProcessGroupSchema() {
        return this.processGroupSchema;
    }

    public void setProcessGroupSchema(ProcessGroupSchema processGroupSchema) {
        this.processGroupSchema = processGroupSchema;
    }

    public ProvenanceReportingSchema getProvenanceReportingProperties() {
        return this.provenanceReportingProperties;
    }

    public void setProvenanceReportingProperties(ProvenanceReportingSchema provenanceReportingProperties) {
        this.provenanceReportingProperties = provenanceReportingProperties;
    }

    public List<ReportingSchema> getReportingTasksSchema() {
        return this.reportingTasks;
    }

    public void setReportingTasks(List<ReportingSchema> reportingTasks) {
        this.reportingTasks = reportingTasks;
    }

    public ComponentStatusRepositorySchema getComponentStatusRepositoryProperties() {
        return this.componentStatusRepositoryProperties;
    }

    public void setComponentStatusRepositoryProperties(ComponentStatusRepositorySchema componentStatusRepositoryProperties) {
        this.componentStatusRepositoryProperties = componentStatusRepositoryProperties;
    }

    public ProvenanceRepositorySchema getProvenanceRepositorySchema() {
        return this.provenanceRepositorySchema;
    }

    public void setProvenanceRepositorySchema(ProvenanceRepositorySchema provenanceRepositorySchema) {
        this.provenanceRepositorySchema = provenanceRepositorySchema;
    }

    public Map<String, String> getNifiPropertiesOverrides() {
        return this.nifiPropertiesOverrides;
    }

    public void setNifiPropertiesOverrides(Map<String, String> nifiPropertiesOverrides) {
        this.nifiPropertiesOverrides = nifiPropertiesOverrides;
    }

    @Override
    public int getVersion() {
        return 3;
    }

    @Override
    public ConfigSchema convert() {
        return this;
    }
}

