/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.odata2.core.commons;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Pattern;

public class ContentType {
    private static final Set<String> KNOWN_MIME_TYPES = new HashSet<String>();
    private static final Comparator<String> Q_PARAMETER_COMPARATOR;
    private static final char WHITESPACE_CHAR = ' ';
    private static final String PARAMETER_SEPARATOR = ";";
    private static final String PARAMETER_KEY_VALUE_SEPARATOR = "=";
    private static final String TYPE_SUBTYPE_SEPARATOR = "/";
    private static final String MEDIA_TYPE_WILDCARD = "*";
    private static final String VERBOSE = "verbose";
    public static final String PARAMETER_CHARSET = "charset";
    public static final String PARAMETER_ODATA = "odata";
    public static final String PARAMETER_Q = "q";
    public static final String PARAMETER_TYPE = "type";
    public static final String CHARSET_UTF_8 = "utf-8";
    private static final Pattern Q_PARAMETER_VALUE_PATTERN;
    public static final ContentType WILDCARD;
    public static final ContentType APPLICATION_XML;
    public static final ContentType APPLICATION_XML_CS_UTF_8;
    public static final ContentType APPLICATION_ATOM_XML;
    public static final ContentType APPLICATION_ATOM_XML_CS_UTF_8;
    public static final ContentType APPLICATION_ATOM_XML_ENTRY;
    public static final ContentType APPLICATION_ATOM_XML_ENTRY_CS_UTF_8;
    public static final ContentType APPLICATION_ATOM_XML_FEED;
    public static final ContentType APPLICATION_ATOM_XML_FEED_CS_UTF_8;
    public static final ContentType APPLICATION_ATOM_SVC;
    public static final ContentType APPLICATION_ATOM_SVC_CS_UTF_8;
    public static final ContentType APPLICATION_JSON;
    public static final ContentType APPLICATION_JSON_ODATA_VERBOSE;
    public static final ContentType APPLICATION_JSON_CS_UTF_8;
    public static final ContentType APPLICATION_OCTET_STREAM;
    public static final ContentType TEXT_PLAIN;
    public static final ContentType TEXT_PLAIN_CS_UTF_8;
    public static final ContentType MULTIPART_MIXED;
    private final String type;
    private final String subtype;
    private final Map<String, String> parameters;
    private final ODataFormat odataFormat;

    private ContentType(String type) {
        if (type == null) {
            throw new IllegalArgumentException("Type parameter MUST NOT be null.");
        }
        this.odataFormat = ODataFormat.CUSTOM;
        this.type = this.validateType(type);
        this.subtype = null;
        this.parameters = Collections.emptyMap();
    }

    private ContentType(String type, String subtype) {
        this(type, subtype, ODataFormat.CUSTOM, null);
    }

    private ContentType(String type, String subtype, ODataFormat odataFormat) {
        this(type, subtype, odataFormat, null);
    }

    private ContentType(String type, String subtype, ODataFormat odataFormat, Map<String, String> parameters) {
        if ((type == null || MEDIA_TYPE_WILDCARD.equals(type)) && !MEDIA_TYPE_WILDCARD.equals(subtype)) {
            throw new IllegalArgumentException("Illegal combination of WILDCARD type with NONE WILDCARD subtype.");
        }
        this.odataFormat = odataFormat;
        this.type = this.validateType(type);
        this.subtype = this.validateType(subtype);
        if (parameters == null) {
            this.parameters = Collections.emptyMap();
        } else {
            this.parameters = new TreeMap<String, String>(new Comparator<String>(){

                @Override
                public int compare(String o1, String o2) {
                    return o1.compareToIgnoreCase(o2);
                }
            });
            this.parameters.putAll(parameters);
            this.parameters.remove(PARAMETER_Q);
        }
    }

    private String validateType(String type) {
        if (type == null || type.isEmpty()) {
            return MEDIA_TYPE_WILDCARD;
        }
        int len = type.length();
        for (int i = 0; i < len; ++i) {
            if (type.charAt(i) != ' ') continue;
            throw new IllegalArgumentException("Illegal whitespace found for type '" + type + "'.");
        }
        return type;
    }

    public static boolean isParseable(String format) {
        try {
            return ContentType.create(format) != null;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public static boolean isParseableAsCustom(String format) {
        try {
            return ContentType.create(format) != null;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public static ContentType create(String type, String subtype) {
        return new ContentType(type, subtype, ContentType.mapToODataFormat(type, subtype), null);
    }

    public static ContentType create(String type, String subtype, Map<String, String> parameters) {
        return new ContentType(type, subtype, ContentType.mapToODataFormat(type, subtype), parameters);
    }

    public static ContentType create(ContentType contentType, String parameterKey, String parameterValue) {
        ContentType ct = new ContentType(contentType.type, contentType.subtype, contentType.odataFormat, contentType.parameters);
        ct.parameters.put(parameterKey, parameterValue);
        return ct;
    }

    public static ContentType create(String format) {
        if (format == null) {
            throw new IllegalArgumentException("Parameter format MUST NOT be NULL.");
        }
        String[] typesAndParameters = format.split(PARAMETER_SEPARATOR, 2);
        String types = typesAndParameters[0];
        String parameters = typesAndParameters.length > 1 ? typesAndParameters[1] : null;
        Map<String, String> parametersMap = ContentType.parseParameters(parameters);
        if (types.contains(TYPE_SUBTYPE_SEPARATOR)) {
            String[] tokens = types.split(TYPE_SUBTYPE_SEPARATOR);
            if (tokens.length == 2) {
                if (tokens[0] == null || tokens[0].isEmpty()) {
                    throw new IllegalArgumentException("No type found in format '" + format + "'.");
                }
                if (tokens[1] == null || tokens[1].isEmpty()) {
                    throw new IllegalArgumentException("No subtype found in format '" + format + "'.");
                }
                return ContentType.create(tokens[0], tokens[1], parametersMap);
            }
            throw new IllegalArgumentException("Too many '/' in format '" + format + "'.");
        }
        if (MEDIA_TYPE_WILDCARD.equals(types)) {
            return WILDCARD;
        }
        throw new IllegalArgumentException("No separator '/' was found in format '" + format + "'.");
    }

    public static ContentType createAsCustom(String format) {
        ContentType parsedContentType = ContentType.parse(format);
        if (parsedContentType == null) {
            return new ContentType(format);
        }
        return parsedContentType;
    }

    public static List<ContentType> create(List<String> contentTypeStrings) {
        ArrayList<ContentType> contentTypes = new ArrayList<ContentType>(contentTypeStrings.size());
        for (String contentTypeString : contentTypeStrings) {
            contentTypes.add(ContentType.create(contentTypeString));
        }
        return contentTypes;
    }

    public static List<ContentType> createAsCustom(List<String> contentTypeStrings) {
        ArrayList<ContentType> contentTypes = new ArrayList<ContentType>(contentTypeStrings.size());
        for (String contentTypeString : contentTypeStrings) {
            contentTypes.add(ContentType.createAsCustom(contentTypeString));
        }
        return contentTypes;
    }

    public static ContentType parse(String format) {
        try {
            return ContentType.create(format);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public static void sortForQParameter(List<String> toSort) {
        Collections.sort(toSort, Q_PARAMETER_COMPARATOR);
    }

    private static ODataFormat mapToODataFormat(String type, String subtype) {
        ODataFormat odataFormat = ODataFormat.CUSTOM;
        if (type.contains("application")) {
            if (subtype.contains("atom")) {
                odataFormat = ODataFormat.ATOM;
            } else if (subtype.contains("xml")) {
                odataFormat = ODataFormat.XML;
            } else if (subtype.contains("json")) {
                odataFormat = ODataFormat.JSON;
            }
        } else if (KNOWN_MIME_TYPES.contains(type)) {
            odataFormat = ODataFormat.MIME;
        }
        return odataFormat;
    }

    private static Map<String, String> parameterMap(String ... content) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (int i = 0; i < content.length - 1; i += 2) {
            String key = content[i];
            String value = content[i + 1];
            map.put(key, value);
        }
        return map;
    }

    private static Map<String, String> parseParameters(String parameters) {
        HashMap<String, String> parameterMap = new HashMap<String, String>();
        if (parameters != null) {
            String[] splittedParameters;
            for (String parameter : splittedParameters = parameters.split(PARAMETER_SEPARATOR)) {
                String value;
                String[] keyValue = parameter.split(PARAMETER_KEY_VALUE_SEPARATOR);
                String key = keyValue[0].trim().toLowerCase(Locale.ENGLISH);
                String string = value = keyValue.length > 1 ? keyValue[1] : null;
                if (value != null && ContentType.isLws(value.charAt(0))) {
                    throw new IllegalArgumentException("Value of parameter '" + key + "' starts with a LWS ('" + parameters + "').");
                }
                if (PARAMETER_Q.equals(key.toLowerCase(Locale.US))) {
                    if (Q_PARAMETER_VALUE_PATTERN.matcher(value).matches()) continue;
                    throw new IllegalArgumentException("Value of 'q' parameter is not valid (q='" + value + "').");
                }
                parameterMap.put(key, value);
            }
        }
        return parameterMap;
    }

    private static Float parseQParameterValue(String contentType) {
        if (contentType != null) {
            String[] splittedParameters;
            for (String parameter : splittedParameters = contentType.split(PARAMETER_SEPARATOR)) {
                String value;
                String[] keyValue = parameter.split(PARAMETER_KEY_VALUE_SEPARATOR);
                String key = keyValue[0].trim().toLowerCase(Locale.ENGLISH);
                if (!PARAMETER_Q.equalsIgnoreCase(key)) continue;
                String string = value = keyValue.length > 1 ? keyValue[1] : null;
                if (Q_PARAMETER_VALUE_PATTERN.matcher(value).matches()) {
                    return Float.valueOf(value);
                }
                return Float.valueOf(-1.0f);
            }
        }
        return Float.valueOf(1.0f);
    }

    private static boolean isParameterAllowed(String key) {
        return key != null && !PARAMETER_Q.equals(key.toLowerCase(Locale.US));
    }

    private static boolean isLws(char character) {
        switch (character) {
            case '\t': 
            case '\n': 
            case '\r': 
            case ' ': {
                return true;
            }
        }
        return false;
    }

    public ContentType receiveWithCharsetParameter(String defaultCharset) {
        if (this.isContentTypeODataTextRelated() && !this.parameters.containsKey(PARAMETER_CHARSET)) {
            return ContentType.create(this, PARAMETER_CHARSET, defaultCharset);
        }
        return this;
    }

    public boolean isContentTypeODataTextRelated() {
        return TEXT_PLAIN.equals(this) || this.getODataFormat() == ODataFormat.XML || this.getODataFormat() == ODataFormat.ATOM || this.getODataFormat() == ODataFormat.JSON;
    }

    public String getType() {
        return this.type;
    }

    public String getSubtype() {
        return this.subtype;
    }

    public Map<String, String> getParameters() {
        return Collections.unmodifiableMap(this.parameters);
    }

    public int hashCode() {
        return 1;
    }

    public boolean equals(Object obj) {
        Boolean compatible = this.isEqualWithoutParameters(obj);
        if (compatible == null) {
            ContentType other = (ContentType)obj;
            if (this.parameters == null) {
                if (other.parameters != null) {
                    return false;
                }
            } else if (this.parameters.size() == other.parameters.size()) {
                Iterator<Map.Entry<String, String>> entries = this.parameters.entrySet().iterator();
                Iterator<Map.Entry<String, String>> otherEntries = other.parameters.entrySet().iterator();
                while (entries.hasNext()) {
                    Map.Entry<String, String> e = entries.next();
                    Map.Entry<String, String> oe = otherEntries.next();
                    if (!ContentType.areEqual(e.getKey(), oe.getKey())) {
                        return false;
                    }
                    if (ContentType.areEqual(e.getValue(), oe.getValue())) continue;
                    return false;
                }
            } else {
                return false;
            }
            return true;
        }
        return compatible;
    }

    public boolean isCompatible(ContentType obj) {
        Boolean compatible = this.isEqualWithoutParameters(obj);
        if (compatible == null) {
            return true;
        }
        return compatible;
    }

    private Boolean isEqualWithoutParameters(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ContentType other = (ContentType)obj;
        if (this.subtype == null) {
            if (other.subtype != null) {
                return false;
            }
        } else if (!this.subtype.equals(other.subtype)) {
            if (other.subtype == null) {
                return false;
            }
            if (!this.subtype.equals(MEDIA_TYPE_WILDCARD) && !other.subtype.equals(MEDIA_TYPE_WILDCARD)) {
                return false;
            }
        }
        if (this.type == null ? other.type != null : !this.type.equals(other.type) && !this.type.equals(MEDIA_TYPE_WILDCARD) && !other.type.equals(MEDIA_TYPE_WILDCARD)) {
            return false;
        }
        if (this.countWildcards() > 0 || other.countWildcards() > 0) {
            return true;
        }
        return null;
    }

    private static boolean areEqual(String first, String second) {
        return !(first == null ? second != null : !first.equalsIgnoreCase(second));
    }

    public String toContentTypeString() {
        StringBuilder sb = new StringBuilder();
        if (this.odataFormat == ODataFormat.CUSTOM && this.subtype == null) {
            sb.append(this.type);
        } else {
            sb.append(this.type).append(TYPE_SUBTYPE_SEPARATOR).append(this.subtype);
        }
        for (Map.Entry<String, String> parameter : this.parameters.entrySet()) {
            if (!ContentType.isParameterAllowed(parameter.getKey())) continue;
            String value = parameter.getValue();
            sb.append(PARAMETER_SEPARATOR).append(parameter.getKey()).append(PARAMETER_KEY_VALUE_SEPARATOR).append(value);
        }
        return sb.toString();
    }

    public String toString() {
        return this.toContentTypeString();
    }

    public ODataFormat getODataFormat() {
        return this.odataFormat;
    }

    public ContentType match(List<ContentType> toMatchContentTypes) {
        for (ContentType supportedContentType : toMatchContentTypes) {
            if (!this.equals(supportedContentType)) continue;
            if (this.compareWildcardCounts(supportedContentType) < 0) {
                return this;
            }
            return supportedContentType;
        }
        return null;
    }

    public ContentType matchCompatible(List<ContentType> toMatchContentTypes) {
        for (ContentType supportedContentType : toMatchContentTypes) {
            if (!this.isCompatible(supportedContentType)) continue;
            if (this.compareWildcardCounts(supportedContentType) < 0) {
                return this;
            }
            return supportedContentType;
        }
        return null;
    }

    public boolean hasCompatible(List<ContentType> toMatchContentTypes) {
        return this.matchCompatible(toMatchContentTypes) != null;
    }

    public boolean hasMatch(List<ContentType> toMatchContentTypes) {
        return this.match(toMatchContentTypes) != null;
    }

    public int compareWildcardCounts(ContentType otherContentType) {
        return this.countWildcards() - otherContentType.countWildcards();
    }

    private int countWildcards() {
        int count = 0;
        if (MEDIA_TYPE_WILDCARD.equals(this.type)) {
            count += 2;
        }
        if (MEDIA_TYPE_WILDCARD.equals(this.subtype)) {
            ++count;
        }
        return count;
    }

    public boolean hasWildcard() {
        return MEDIA_TYPE_WILDCARD.equals(this.type) || MEDIA_TYPE_WILDCARD.equals(this.subtype);
    }

    public boolean isWildcard() {
        return MEDIA_TYPE_WILDCARD.equals(this.type) && MEDIA_TYPE_WILDCARD.equals(this.subtype);
    }

    public static List<ContentType> convert(List<String> types) {
        ArrayList<ContentType> results = new ArrayList<ContentType>();
        for (String contentType : types) {
            results.add(ContentType.create(contentType));
        }
        return results;
    }

    public static boolean match(String toMatch, ContentType ... matchExamples) {
        ContentType toMatchContentType = ContentType.create(toMatch);
        return toMatchContentType.hasMatch(Arrays.asList(matchExamples));
    }

    static {
        KNOWN_MIME_TYPES.add("audio");
        KNOWN_MIME_TYPES.add("image");
        KNOWN_MIME_TYPES.add("video");
        KNOWN_MIME_TYPES.add("multipart");
        KNOWN_MIME_TYPES.add("text");
        Q_PARAMETER_COMPARATOR = new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                Float f1 = ContentType.parseQParameterValue(o1);
                Float f2 = ContentType.parseQParameterValue(o2);
                return f2.compareTo(f1);
            }
        };
        Q_PARAMETER_VALUE_PATTERN = Pattern.compile("1|0|1\\.0{1,3}|0\\.\\d{1,3}");
        WILDCARD = new ContentType(MEDIA_TYPE_WILDCARD, MEDIA_TYPE_WILDCARD);
        APPLICATION_XML = new ContentType("application", "xml", ODataFormat.XML);
        APPLICATION_XML_CS_UTF_8 = ContentType.create(APPLICATION_XML, PARAMETER_CHARSET, CHARSET_UTF_8);
        APPLICATION_ATOM_XML = new ContentType("application", "atom+xml", ODataFormat.ATOM);
        APPLICATION_ATOM_XML_CS_UTF_8 = ContentType.create(APPLICATION_ATOM_XML, PARAMETER_CHARSET, CHARSET_UTF_8);
        APPLICATION_ATOM_XML_ENTRY = new ContentType("application", "atom+xml", ODataFormat.ATOM, ContentType.parameterMap(PARAMETER_TYPE, "entry"));
        APPLICATION_ATOM_XML_ENTRY_CS_UTF_8 = ContentType.create(APPLICATION_ATOM_XML_ENTRY, PARAMETER_CHARSET, CHARSET_UTF_8);
        APPLICATION_ATOM_XML_FEED = new ContentType("application", "atom+xml", ODataFormat.ATOM, ContentType.parameterMap(PARAMETER_TYPE, "feed"));
        APPLICATION_ATOM_XML_FEED_CS_UTF_8 = ContentType.create(APPLICATION_ATOM_XML_FEED, PARAMETER_CHARSET, CHARSET_UTF_8);
        APPLICATION_ATOM_SVC = new ContentType("application", "atomsvc+xml", ODataFormat.ATOM);
        APPLICATION_ATOM_SVC_CS_UTF_8 = ContentType.create(APPLICATION_ATOM_SVC, PARAMETER_CHARSET, CHARSET_UTF_8);
        APPLICATION_JSON = new ContentType("application", "json", ODataFormat.JSON);
        APPLICATION_JSON_ODATA_VERBOSE = ContentType.create(APPLICATION_JSON, PARAMETER_ODATA, VERBOSE);
        APPLICATION_JSON_CS_UTF_8 = ContentType.create(APPLICATION_JSON, PARAMETER_CHARSET, CHARSET_UTF_8);
        APPLICATION_OCTET_STREAM = new ContentType("application", "octet-stream");
        TEXT_PLAIN = new ContentType("text", "plain");
        TEXT_PLAIN_CS_UTF_8 = ContentType.create(TEXT_PLAIN, PARAMETER_CHARSET, CHARSET_UTF_8);
        MULTIPART_MIXED = new ContentType("multipart", "mixed");
    }

    public static enum ODataFormat {
        ATOM,
        XML,
        JSON,
        MIME,
        CUSTOM;

    }
}

