/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.client.core.edm.xml.annotation;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.io.IOException;
import java.io.Serializable;
import org.apache.olingo.client.core.edm.xml.AbstractClientCsdlEdmDeserializer;
import org.apache.olingo.client.core.edm.xml.ClientCsdlAnnotation;
import org.apache.olingo.client.core.edm.xml.annotation.ClientCsdlDynamicExpression;
import org.apache.olingo.commons.api.edm.provider.annotation.CsdlExpression;
import org.apache.olingo.commons.api.edm.provider.annotation.CsdlPropertyValue;

@JsonDeserialize(using=PropertyValueDeserializer.class)
class ClientCsdlPropertyValue
extends CsdlPropertyValue
implements Serializable {
    private static final long serialVersionUID = -8437649215282645228L;

    ClientCsdlPropertyValue() {
    }

    static class PropertyValueDeserializer
    extends AbstractClientCsdlEdmDeserializer<ClientCsdlPropertyValue> {
        PropertyValueDeserializer() {
        }

        @Override
        protected ClientCsdlPropertyValue doDeserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
            ClientCsdlPropertyValue propValue = new ClientCsdlPropertyValue();
            while (jp.getCurrentToken() != JsonToken.END_OBJECT) {
                JsonToken token = jp.getCurrentToken();
                if (token == JsonToken.FIELD_NAME) {
                    if ("Property".equals(jp.getCurrentName())) {
                        propValue.setProperty(jp.nextTextValue());
                    } else if ("Annotation".equals(jp.getCurrentName())) {
                        propValue.getAnnotations().add(jp.readValueAs(ClientCsdlAnnotation.class));
                    } else if (this.isAnnotationConstExprConstruct(jp)) {
                        propValue.setValue((CsdlExpression)this.parseAnnotationConstExprConstruct(jp));
                    } else {
                        propValue.setValue((CsdlExpression)jp.readValueAs(ClientCsdlDynamicExpression.class));
                    }
                }
                jp.nextToken();
            }
            return propValue;
        }
    }
}

