/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.server.api.serializer;

import org.apache.olingo.commons.api.data.ContextURL;
import org.apache.olingo.server.api.uri.queryoption.ExpandOption;
import org.apache.olingo.server.api.uri.queryoption.SelectOption;

public class EntitySerializerOptions {
    private ContextURL contextURL;
    private ExpandOption expand;
    private SelectOption select;
    private boolean writeOnlyReferences;
    private String xml10InvalidCharReplacement;

    public ContextURL getContextURL() {
        return this.contextURL;
    }

    public ExpandOption getExpand() {
        return this.expand;
    }

    public SelectOption getSelect() {
        return this.select;
    }

    public boolean getWriteOnlyReferences() {
        return this.writeOnlyReferences;
    }

    public String xml10InvalidCharReplacement() {
        return this.xml10InvalidCharReplacement;
    }

    private EntitySerializerOptions() {
    }

    public static Builder with() {
        return new Builder();
    }

    public static final class Builder {
        private final EntitySerializerOptions options = new EntitySerializerOptions();

        private Builder() {
        }

        public Builder contextURL(ContextURL contextURL) {
            this.options.contextURL = contextURL;
            return this;
        }

        public Builder expand(ExpandOption expand) {
            this.options.expand = expand;
            return this;
        }

        public Builder select(SelectOption select) {
            this.options.select = select;
            return this;
        }

        public Builder writeOnlyReferences(boolean ref) {
            this.options.writeOnlyReferences = ref;
            return this;
        }

        public Builder xml10InvalidCharReplacement(String replacement) {
            this.options.xml10InvalidCharReplacement = replacement;
            return this;
        }

        public EntitySerializerOptions build() {
            return this.options;
        }
    }
}

