/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.client.core.edm.xml;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.io.IOException;
import java.io.Serializable;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.olingo.client.core.edm.xml.AbstractClientCsdlEdmDeserializer;
import org.apache.olingo.client.core.edm.xml.ClientCsdlAnnotation;
import org.apache.olingo.client.core.edm.xml.ClientCsdlParameter;
import org.apache.olingo.commons.api.edm.provider.CsdlAnnotation;
import org.apache.olingo.commons.api.edm.provider.CsdlFunction;
import org.apache.olingo.commons.api.edm.provider.CsdlParameter;

@JsonDeserialize(using=FunctionDeserializer.class)
class ClientCsdlFunction
extends CsdlFunction
implements Serializable {
    private static final long serialVersionUID = -5494898295282843362L;

    ClientCsdlFunction() {
    }

    static class FunctionDeserializer
    extends AbstractClientCsdlEdmDeserializer<ClientCsdlFunction> {
        FunctionDeserializer() {
        }

        @Override
        protected ClientCsdlFunction doDeserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
            ClientCsdlFunction functionImpl = new ClientCsdlFunction();
            while (jp.getCurrentToken() != JsonToken.END_OBJECT) {
                JsonToken token = jp.getCurrentToken();
                if (token == JsonToken.FIELD_NAME) {
                    if ("Name".equals(jp.getCurrentName())) {
                        functionImpl.setName(jp.nextTextValue());
                    } else if ("IsBound".equals(jp.getCurrentName())) {
                        functionImpl.setBound(BooleanUtils.toBoolean((String)jp.nextTextValue()));
                    } else if ("IsComposable".equals(jp.getCurrentName())) {
                        functionImpl.setComposable(BooleanUtils.toBoolean((String)jp.nextTextValue()));
                    } else if ("EntitySetPath".equals(jp.getCurrentName())) {
                        functionImpl.setEntitySetPath(jp.nextTextValue());
                    } else if ("Parameter".equals(jp.getCurrentName())) {
                        jp.nextToken();
                        functionImpl.getParameters().add((CsdlParameter)jp.readValueAs(ClientCsdlParameter.class));
                    } else if ("ReturnType".equals(jp.getCurrentName())) {
                        functionImpl.setReturnType(this.parseReturnType(jp, "Function"));
                    } else if ("Annotation".equals(jp.getCurrentName())) {
                        jp.nextToken();
                        functionImpl.getAnnotations().add((CsdlAnnotation)jp.readValueAs(ClientCsdlAnnotation.class));
                    }
                }
                jp.nextToken();
            }
            return functionImpl;
        }
    }
}

