/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.commons.api.data;

import java.util.ArrayList;
import java.util.List;
import org.apache.olingo.commons.api.data.AbstractODataObject;
import org.apache.olingo.commons.api.data.Link;

public abstract class Linked
extends AbstractODataObject {
    private final List<Link> associationLinks = new ArrayList<Link>();
    private final List<Link> navigationLinks = new ArrayList<Link>();
    private final List<Link> bindingLinks = new ArrayList<Link>();

    protected Link getOneByTitle(String name, List<Link> links) {
        Link result = null;
        for (Link link : links) {
            if (!name.equals(link.getTitle())) continue;
            result = link;
        }
        return result;
    }

    public Link getAssociationLink(String name) {
        return this.getOneByTitle(name, this.associationLinks);
    }

    public List<Link> getAssociationLinks() {
        return this.associationLinks;
    }

    public Link getNavigationLink(String name) {
        return this.getOneByTitle(name, this.navigationLinks);
    }

    public List<Link> getNavigationLinks() {
        return this.navigationLinks;
    }

    public Link getNavigationBinding(String name) {
        return this.getOneByTitle(name, this.bindingLinks);
    }

    public List<Link> getNavigationBindings() {
        return this.bindingLinks;
    }

    @Override
    public boolean equals(Object o) {
        return super.equals(o) && this.associationLinks.equals(((Linked)o).associationLinks) && this.navigationLinks.equals(((Linked)o).navigationLinks) && this.bindingLinks.equals(((Linked)o).bindingLinks);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.associationLinks.hashCode();
        result = 31 * result + this.navigationLinks.hashCode();
        result = 31 * result + this.bindingLinks.hashCode();
        return result;
    }
}

