/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.preflight;

import java.util.Stack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PreflightPath {
    private Stack objectPath = new Stack();
    private Stack<Class> classObjPath = new Stack();

    public boolean pushObject(Object pathElement) {
        boolean pushed = false;
        if (pathElement != null) {
            this.objectPath.push(pathElement);
            this.classObjPath.push(pathElement.getClass());
            pushed = true;
        }
        return pushed;
    }

    public <T> T getPathElement(int position, Class<T> expectedType) {
        if (position < 0 || position >= this.objectPath.size()) {
            return null;
        }
        return (T)this.objectPath.get(position);
    }

    public <T> int getClosestTypePosition(Class<T> type) {
        int i = this.objectPath.size();
        while (i-- > 0) {
            if (!((Class)this.classObjPath.get(i)).equals(type)) continue;
            return i;
        }
        return -1;
    }

    public <T> T getClosestPathElement(Class<T> type) {
        return this.getPathElement(this.getClosestTypePosition(type), type);
    }

    public Object peek() {
        return this.objectPath.peek();
    }

    public Object pop() {
        this.classObjPath.pop();
        return this.objectPath.pop();
    }

    public void clear() {
        this.classObjPath.clear();
        this.objectPath.clear();
    }

    public int size() {
        return this.objectPath.size();
    }

    public boolean isEmpty() {
        return this.objectPath.isEmpty();
    }

    public boolean isExpectedType(Class<?> type) {
        Class knownType = this.classObjPath.peek();
        return knownType != null && (type.equals(knownType) || type.isAssignableFrom(knownType));
    }
}

