/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlbeans.impl.common;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;

public class JarHelper {
    private static final int BUFFER_SIZE = 2156;
    private final byte[] mBuffer = new byte[2156];
    private boolean mVerbose = false;
    private String mDestJarName = "";
    private static final char SEP = '/';

    public void jarDir(File dirOrFile2Jar, File destJar) throws IOException {
        if (dirOrFile2Jar == null || destJar == null) {
            throw new IllegalArgumentException();
        }
        this.mDestJarName = destJar.getCanonicalPath();
        try (OutputStream fout = Files.newOutputStream(destJar.toPath(), new OpenOption[0]);
             JarOutputStream jout = new JarOutputStream(fout);){
            this.jarDir(dirOrFile2Jar, jout, null);
        }
    }

    public void setVerbose(boolean b) {
        this.mVerbose = b;
    }

    private void jarDir(File dirOrFile2jar, JarOutputStream jos, String path) throws IOException {
        block20: {
            block19: {
                String subPath;
                if (this.mVerbose) {
                    System.out.println("checking " + dirOrFile2jar);
                }
                if (!dirOrFile2jar.isDirectory()) break block19;
                String[] dirList = dirOrFile2jar.list();
                String string = subPath = path == null ? "" : path + dirOrFile2jar.getName() + '/';
                if (path != null) {
                    JarEntry je = new JarEntry(subPath);
                    je.setTime(dirOrFile2jar.lastModified());
                    jos.putNextEntry(je);
                    jos.flush();
                    jos.closeEntry();
                }
                if (dirList == null) break block20;
                for (String s : dirList) {
                    File f = new File(dirOrFile2jar, s);
                    this.jarDir(f, jos, subPath);
                }
                break block20;
            }
            if (dirOrFile2jar.getCanonicalPath().equals(this.mDestJarName)) {
                if (this.mVerbose) {
                    System.out.println("skipping " + dirOrFile2jar.getPath());
                }
                return;
            }
            if (this.mVerbose) {
                System.out.println("adding " + dirOrFile2jar.getPath());
            }
            try (InputStream fis = Files.newInputStream(dirOrFile2jar.toPath(), new OpenOption[0]);){
                int mByteCount;
                JarEntry entry = new JarEntry(path + dirOrFile2jar.getName());
                entry.setTime(dirOrFile2jar.lastModified());
                jos.putNextEntry(entry);
                while ((mByteCount = fis.read(this.mBuffer)) != -1) {
                    jos.write(this.mBuffer, 0, mByteCount);
                    if (!this.mVerbose) continue;
                    System.out.println("wrote " + mByteCount + " bytes");
                }
                jos.flush();
                jos.closeEntry();
            }
        }
    }
}

