/*
This Java source file was generated by test-to-java.xsl
and is a derived work from the source document.
The source document contained the following notice:



Copyright (c) 2001 World Wide Web Consortium,
(Massachusetts Institute of Technology, Institut National de
Recherche en Informatique et en Automatique, Keio University).  All
Rights Reserved.  This program is distributed under the W3C's Software
Intellectual Property License.  This program is distributed in the
hope that it will be useful, but WITHOUT ANY WARRANTY; without even
the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.

See W3C License http://www.w3.org/Consortium/Legal/ for more details.


*/

package org.w3c.domts.level2.core;


import org.junit.jupiter.api.Test;
import org.w3c.dom.*;

import static org.junit.jupiter.api.Assertions.assertEquals;
import static org.junit.jupiter.api.Assertions.assertThrows;
import static org.w3c.domts.DOMTest.load;


/**
 * The method setNamedItemNS adds a node using its namespaceURI and localName and
 * raises a INUSE_ATTRIBUTE_ERR Raised if arg is an Attr that is already an
 * attribute of another Element object.
 * Retreieve the attributes of first element whose localName is address into a named node map.
 * Retreive the attribute whose namespaceURI=http://www.usa.com and localName=domestic
 * from the NamedNodeMap.  Retreieve the attributes of second element whose localName is address
 * into a named node map.  Call the setNamedItemNS method on the second nodemap with the domestic
 * attribute that was retreived and removed from the first nodeMap as an argument.
 * Assuming that when an attribute is removed from a nodemap, it still remains in the domtree
 * his should raise an INUSE_ATTRIBIUTE_ERR.
 *
 * @see <a href="http://www.w3.org/TR/DOM-Level-2-Core/core#ID-setNamedItemNS">http://www.w3.org/TR/DOM-Level-2-Core/core#ID-setNamedItemNS</a>
 */
public class namednodemapsetnameditemns07 {
    @Test
    void testRun() throws Throwable {
        Document doc = load("staffNS", true);
        NodeList elementList = doc.getElementsByTagNameNS("*", "address");
        Element element = (Element) elementList.item(0);
        NamedNodeMap attributes = element.getAttributes();
        Attr attr = (Attr) attributes.getNamedItemNS("http://www.usa.com", "domestic");
        element = (Element) elementList.item(1);
        NamedNodeMap attributes2 = element.getAttributes();

        DOMException ex = assertThrows(DOMException.class, () -> attributes2.setNamedItemNS(attr));
        assertEquals(DOMException.INUSE_ATTRIBUTE_ERR, ex.code, "namednodemapsetnameditemns07");
    }

    /**
     * Gets URI that identifies the test
     *
     * @return uri identifier of test
     */
    public String getTargetURI() {
        return "http://www.w3.org/2001/DOM-Test-Suite/level2/core/namednodemapsetnameditemns07";
    }

}
