/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.client.java.metrics;

import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import org.apache.rocketmq.client.java.metrics.HistogramEnum;
import org.apache.rocketmq.client.java.metrics.Metric;
import org.apache.rocketmq.client.java.route.Endpoints;
import org.apache.rocketmq.shaded.com.google.common.base.MoreObjects;
import org.apache.rocketmq.shaded.com.google.common.base.Preconditions;
import org.apache.rocketmq.shaded.io.opentelemetry.api.metrics.DoubleHistogram;
import org.apache.rocketmq.shaded.io.opentelemetry.api.metrics.Meter;
import org.apache.rocketmq.shaded.io.opentelemetry.sdk.metrics.SdkMeterProvider;
import org.apache.rocketmq.shaded.org.slf4j.Logger;
import org.apache.rocketmq.shaded.org.slf4j.LoggerFactory;

public class ClientMeter {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClientMeter.class);
    private final boolean enabled;
    private final Meter meter;
    private final Endpoints endpoints;
    private final SdkMeterProvider provider;
    private final String clientId;
    private final ConcurrentMap<String, DoubleHistogram> histogramMap;

    public ClientMeter(Meter meter, Endpoints endpoints, SdkMeterProvider provider, String clientId) {
        this.enabled = true;
        this.meter = Preconditions.checkNotNull(meter, "meter should not be null");
        this.endpoints = Preconditions.checkNotNull(endpoints, "endpoints should not be null");
        this.provider = Preconditions.checkNotNull(provider, "provider should not be null");
        this.clientId = Preconditions.checkNotNull(clientId, "clientId should not be null");
        this.histogramMap = new ConcurrentHashMap<String, DoubleHistogram>();
    }

    private ClientMeter(String clientId) {
        this.enabled = false;
        this.meter = null;
        this.endpoints = null;
        this.provider = null;
        this.clientId = Preconditions.checkNotNull(clientId, "clientId should not be null");
        this.histogramMap = new ConcurrentHashMap<String, DoubleHistogram>();
    }

    static ClientMeter disabledInstance(String clientId) {
        return new ClientMeter(clientId);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public Endpoints getEndpoints() {
        return this.endpoints;
    }

    Optional<DoubleHistogram> getHistogramByEnum(HistogramEnum histogramEnum) {
        DoubleHistogram histogram = this.histogramMap.computeIfAbsent(histogramEnum.getName(), name -> this.enabled ? this.meter.histogramBuilder(histogramEnum.getName()).build() : null);
        return null == histogram ? Optional.empty() : Optional.of(histogram);
    }

    public void shutdown() {
        if (!this.enabled) {
            return;
        }
        CountDownLatch latch = new CountDownLatch(1);
        this.provider.shutdown().whenComplete(latch::countDown);
        try {
            latch.await();
            LOGGER.info("Shutdown client meter successfully, clientId={}, endpoints={}", (Object)this.clientId, (Object)this.endpoints);
        }
        catch (Throwable t) {
            LOGGER.error("Failed to shutdown message meter, clientId={}, endpoints={}", this.clientId, this.endpoints, t);
        }
    }

    public boolean satisfy(Metric metric) {
        if (this.enabled && metric.isOn() && this.endpoints.equals(metric.getEndpoints())) {
            return true;
        }
        return !this.enabled && !metric.isOn();
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("enabled", this.enabled).add("meter", this.meter).add("endpoints", this.endpoints).add("provider", this.provider).add("histogramMap", this.histogramMap).toString();
    }
}

