/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.client.java.message;

import com.google.common.base.MoreObjects;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.rocketmq.client.apis.message.Message;
import org.apache.rocketmq.client.java.message.MessageCommon;

public class MessageImpl
implements Message {
    protected final Collection<String> keys;
    final byte[] body;
    private final String topic;
    @Nullable
    private final String tag;
    @Nullable
    private final String messageGroup;
    @Nullable
    private final Long deliveryTimestamp;
    @Nullable
    private final String parentTraceContext;
    private final Map<String, String> properties;

    MessageImpl(String topic, byte[] body, @Nullable String tag, Collection<String> keys, @Nullable String messageGroup, @Nullable String parentTraceContext, @Nullable Long deliveryTimestamp, Map<String, String> properties) {
        this.topic = topic;
        this.body = body;
        this.tag = tag;
        this.messageGroup = messageGroup;
        this.deliveryTimestamp = deliveryTimestamp;
        this.keys = keys;
        this.parentTraceContext = parentTraceContext;
        this.properties = properties;
    }

    MessageImpl(Message message) {
        this.topic = message.getTopic();
        if (message instanceof MessageImpl) {
            MessageImpl impl = (MessageImpl)message;
            this.body = impl.body;
        } else {
            ByteBuffer body = message.getBody();
            byte[] bytes = new byte[body.remaining()];
            body.get(bytes);
            this.body = bytes;
        }
        this.tag = message.getTag().orElse(null);
        this.messageGroup = message.getMessageGroup().orElse(null);
        this.deliveryTimestamp = message.getDeliveryTimestamp().orElse(null);
        this.parentTraceContext = message.getParentTraceContext().orElse(null);
        this.keys = message.getKeys();
        this.properties = message.getProperties();
    }

    public MessageCommon getMessageCommon() {
        return new MessageCommon(this.topic, this.body, this.tag, this.messageGroup, this.deliveryTimestamp, this.parentTraceContext, this.keys, this.properties);
    }

    public String getTopic() {
        return this.topic;
    }

    public ByteBuffer getBody() {
        return ByteBuffer.wrap(this.body).asReadOnlyBuffer();
    }

    public Map<String, String> getProperties() {
        return new HashMap<String, String>(this.properties);
    }

    public Optional<String> getTag() {
        return null == this.tag ? Optional.empty() : Optional.of(this.tag);
    }

    public Collection<String> getKeys() {
        return new ArrayList<String>(this.keys);
    }

    public Optional<Long> getDeliveryTimestamp() {
        return null == this.deliveryTimestamp ? Optional.empty() : Optional.of(this.deliveryTimestamp);
    }

    public Optional<String> getMessageGroup() {
        return null == this.messageGroup ? Optional.empty() : Optional.of(this.messageGroup);
    }

    public Optional<String> getParentTraceContext() {
        return null == this.parentTraceContext ? Optional.empty() : Optional.of(this.parentTraceContext);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("topic", (Object)this.topic).add("tag", (Object)this.tag).add("messageGroup", (Object)this.messageGroup).add("deliveryTimestamp", (Object)this.deliveryTimestamp).add("parentTraceContext", (Object)this.parentTraceContext).add("keys", this.keys).add("properties", this.properties).toString();
    }
}

