/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.client.java.metrics;

import io.grpc.ClientInterceptor;
import io.grpc.ManagedChannel;
import io.grpc.NameResolver;
import io.grpc.netty.shaded.io.grpc.netty.GrpcSslContexts;
import io.grpc.netty.shaded.io.grpc.netty.NettyChannelBuilder;
import io.grpc.netty.shaded.io.netty.handler.ssl.SslContext;
import io.grpc.netty.shaded.io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.metrics.DoubleHistogram;
import io.opentelemetry.api.metrics.Meter;
import io.opentelemetry.exporter.otlp.metrics.OtlpGrpcMetricExporter;
import io.opentelemetry.sdk.OpenTelemetrySdk;
import io.opentelemetry.sdk.metrics.InstrumentSelector;
import io.opentelemetry.sdk.metrics.InstrumentType;
import io.opentelemetry.sdk.metrics.SdkMeterProvider;
import io.opentelemetry.sdk.metrics.View;
import io.opentelemetry.sdk.metrics.export.MetricExporter;
import io.opentelemetry.sdk.metrics.export.MetricReader;
import io.opentelemetry.sdk.metrics.export.PeriodicMetricReader;
import io.opentelemetry.sdk.resources.Resource;
import java.net.InetSocketAddress;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.rocketmq.client.apis.consumer.PushConsumer;
import org.apache.rocketmq.client.java.impl.ClientImpl;
import org.apache.rocketmq.client.java.metrics.ClientMeter;
import org.apache.rocketmq.client.java.metrics.GaugeEnum;
import org.apache.rocketmq.client.java.metrics.HistogramEnum;
import org.apache.rocketmq.client.java.metrics.MessageCacheObserver;
import org.apache.rocketmq.client.java.metrics.MessageMeterInterceptor;
import org.apache.rocketmq.client.java.metrics.Metric;
import org.apache.rocketmq.client.java.metrics.MetricLabels;
import org.apache.rocketmq.client.java.route.Endpoints;
import org.apache.rocketmq.client.java.rpc.AuthInterceptor;
import org.apache.rocketmq.client.java.rpc.IpNameResolverFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientMeterProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClientMeterProvider.class);
    private static final Duration METRIC_EXPORTER_RPC_TIMEOUT = Duration.ofSeconds(3L);
    private static final Duration METRIC_READER_INTERVAL = Duration.ofMinutes(1L);
    private static final String METRIC_INSTRUMENTATION_NAME = "org.apache.rocketmq.message";
    private final ClientImpl client;
    private volatile ClientMeter clientMeter;
    private volatile MessageCacheObserver messageCacheObserver;

    public ClientMeterProvider(ClientImpl client) {
        this.client = client;
        this.client.registerMessageInterceptor(new MessageMeterInterceptor(this));
        this.clientMeter = ClientMeter.disabledInstance(client.clientId());
        this.messageCacheObserver = null;
    }

    public void setMessageCacheObserver(MessageCacheObserver messageCacheObserver) {
        this.messageCacheObserver = messageCacheObserver;
    }

    Optional<DoubleHistogram> getHistogramByEnum(HistogramEnum histogramEnum) {
        return this.clientMeter.getHistogramByEnum(histogramEnum);
    }

    public synchronized void reset(Metric metric) {
        String clientId = this.client.clientId();
        try {
            if (this.clientMeter.satisfy(metric)) {
                LOGGER.info("Metric settings is satisfied by the current message meter, clientId={}", (Object)clientId);
                return;
            }
            if (!metric.isOn()) {
                LOGGER.info("Metric is off, clientId={}", (Object)clientId);
                this.clientMeter.shutdown();
                this.clientMeter = ClientMeter.disabledInstance(this.client.clientId());
                return;
            }
            Endpoints endpoints = metric.getEndpoints();
            SslContext sslContext = GrpcSslContexts.forClient().trustManager(InsecureTrustManagerFactory.INSTANCE).build();
            NettyChannelBuilder channelBuilder = (NettyChannelBuilder)NettyChannelBuilder.forTarget((String)endpoints.getGrpcTarget()).sslContext(sslContext).intercept(new ClientInterceptor[]{new AuthInterceptor(this.client.getClientConfiguration(), clientId)});
            List<InetSocketAddress> socketAddresses = endpoints.toSocketAddresses();
            if (null != socketAddresses) {
                IpNameResolverFactory metricResolverFactory = new IpNameResolverFactory(socketAddresses);
                channelBuilder.nameResolverFactory((NameResolver.Factory)metricResolverFactory);
            }
            ManagedChannel channel = channelBuilder.build();
            OtlpGrpcMetricExporter exporter = OtlpGrpcMetricExporter.builder().setChannel(channel).setTimeout(METRIC_EXPORTER_RPC_TIMEOUT).build();
            InstrumentSelector sendSuccessCostTimeInstrumentSelector = InstrumentSelector.builder().setType(InstrumentType.HISTOGRAM).setName(HistogramEnum.SEND_SUCCESS_COST_TIME.getName()).build();
            View sendSuccessCostTimeView = View.builder().setAggregation(HistogramEnum.SEND_SUCCESS_COST_TIME.getBucket()).build();
            InstrumentSelector deliveryLatencyInstrumentSelector = InstrumentSelector.builder().setType(InstrumentType.HISTOGRAM).setName(HistogramEnum.DELIVERY_LATENCY.getName()).build();
            View deliveryLatencyView = View.builder().setAggregation(HistogramEnum.DELIVERY_LATENCY.getBucket()).build();
            InstrumentSelector awaitTimeInstrumentSelector = InstrumentSelector.builder().setType(InstrumentType.HISTOGRAM).setName(HistogramEnum.AWAIT_TIME.getName()).build();
            View awaitTimeView = View.builder().setAggregation(HistogramEnum.AWAIT_TIME.getBucket()).build();
            InstrumentSelector processTimeInstrumentSelector = InstrumentSelector.builder().setType(InstrumentType.HISTOGRAM).setName(HistogramEnum.PROCESS_TIME.getName()).build();
            View processTimeView = View.builder().setAggregation(HistogramEnum.PROCESS_TIME.getBucket()).build();
            PeriodicMetricReader reader = PeriodicMetricReader.builder((MetricExporter)exporter).setInterval(METRIC_READER_INTERVAL).build();
            SdkMeterProvider provider = SdkMeterProvider.builder().setResource(Resource.empty()).registerMetricReader((MetricReader)reader).registerView(sendSuccessCostTimeInstrumentSelector, sendSuccessCostTimeView).registerView(deliveryLatencyInstrumentSelector, deliveryLatencyView).registerView(awaitTimeInstrumentSelector, awaitTimeView).registerView(processTimeInstrumentSelector, processTimeView).build();
            OpenTelemetrySdk openTelemetry = OpenTelemetrySdk.builder().setMeterProvider(provider).build();
            Meter meter = openTelemetry.getMeter(METRIC_INSTRUMENTATION_NAME);
            ClientMeter existedClientMeter = this.clientMeter;
            this.clientMeter = new ClientMeter(meter, endpoints, provider, clientId);
            existedClientMeter.shutdown();
            LOGGER.info("Metrics is on, endpoints={}, clientId={}", (Object)endpoints, (Object)clientId);
            if (!(this.client instanceof PushConsumer)) {
                return;
            }
            String consumerGroup = ((PushConsumer)this.client).getConsumerGroup();
            meter.gaugeBuilder(GaugeEnum.CONSUMER_CACHED_MESSAGES.getName()).buildWithCallback(measurement -> {
                Map<String, Long> cachedMessageCountMap = this.messageCacheObserver.getCachedMessageCount();
                for (Map.Entry<String, Long> entry : cachedMessageCountMap.entrySet()) {
                    String topic = entry.getKey();
                    Attributes attributes = Attributes.builder().put(MetricLabels.TOPIC, (Object)topic).put(MetricLabels.CONSUMER_GROUP, (Object)consumerGroup).put(MetricLabels.CLIENT_ID, (Object)clientId).build();
                    measurement.record((double)entry.getValue().longValue(), attributes);
                }
            });
            meter.gaugeBuilder(GaugeEnum.CONSUMER_CACHED_BYTES.getName()).buildWithCallback(measurement -> {
                Map<String, Long> cachedMessageBytesMap = this.messageCacheObserver.getCachedMessageBytes();
                for (Map.Entry<String, Long> entry : cachedMessageBytesMap.entrySet()) {
                    String topic = entry.getKey();
                    Attributes attributes = Attributes.builder().put(MetricLabels.TOPIC, (Object)topic).put(MetricLabels.CONSUMER_GROUP, (Object)consumerGroup).put(MetricLabels.CLIENT_ID, (Object)clientId).build();
                    measurement.record((double)entry.getValue().longValue(), attributes);
                }
            });
        }
        catch (Throwable t) {
            LOGGER.error("Exception raised when resetting message meter, clientId={}", (Object)clientId, (Object)t);
        }
    }

    public boolean isEnabled() {
        return this.clientMeter.isEnabled();
    }

    public ClientImpl getClient() {
        return this.client;
    }
}

