/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.coverage.grid;

import java.awt.image.RenderedImage;
import org.apache.sis.coverage.CannotEvaluateException;
import org.apache.sis.coverage.SubspaceNotSpecifiedException;
import org.apache.sis.coverage.grid.DisjointExtentException;
import org.apache.sis.coverage.grid.GridCoverage;
import org.apache.sis.coverage.grid.GridExtent;
import org.apache.sis.coverage.grid.GridGeometry;
import org.apache.sis.coverage.grid.IllegalGridGeometryException;
import org.apache.sis.feature.internal.Resources;
import org.apache.sis.image.DataType;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.internal.shared.Numerics;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.util.FactoryException;

final class DimensionAppender
extends GridCoverage {
    private final GridCoverage source;
    private final GridGeometry dimToAdd;

    private DimensionAppender(GridCoverage source, GridGeometry dimToAdd) throws FactoryException {
        super(source, new GridGeometry(source.getGridGeometry(), dimToAdd));
        this.source = source;
        this.dimToAdd = dimToAdd;
    }

    static GridCoverage create(GridCoverage source, GridGeometry dimToAdd) throws FactoryException {
        GridExtent extent = dimToAdd.getExtent();
        int i = extent.getDimension();
        if (i == 0) {
            return source;
        }
        do {
            long size;
            if ((size = extent.getSize(--i)) == 1L) continue;
            throw new IllegalGridGeometryException(Resources.format((short)90, extent.getAxisIdentification(i, i), size));
        } while (i != 0);
        if (source instanceof DimensionAppender) {
            DimensionAppender a = (DimensionAppender)source;
            dimToAdd = new GridGeometry(a.dimToAdd, dimToAdd);
            source = a.source;
        }
        return new DimensionAppender(source, dimToAdd);
    }

    final GridCoverage selectDimensions(int[] gridAxesToPass) throws FactoryException {
        int dimension = gridAxesToPass.length;
        int sourceDim = this.source.getGridGeometry().getDimension();
        if (dimension < sourceDim || gridAxesToPass[0] != 0 || gridAxesToPass[sourceDim - 1] != sourceDim - 1) {
            return null;
        }
        if (dimension == sourceDim) {
            return this.source;
        }
        int[] selected = new int[dimension - sourceDim];
        for (int i = sourceDim; i < dimension; ++i) {
            selected[i - sourceDim] = gridAxesToPass[i] - sourceDim;
        }
        return DimensionAppender.create(this.source, this.dimToAdd.selectDimensions(selected));
    }

    @Override
    final DataType getBandType() {
        return this.source.getBandType();
    }

    @Override
    protected GridCoverage createConvertedValues(boolean converted) {
        try {
            return new DimensionAppender(this.source.forConvertedValues(converted), this.dimToAdd);
        }
        catch (FactoryException e) {
            throw new CannotEvaluateException(e.getMessage(), e);
        }
    }

    @Override
    public GridCoverage.Evaluator evaluator() {
        return this.source.evaluator();
    }

    @Override
    public RenderedImage render(GridExtent sliceExtent) {
        if (sliceExtent != null) {
            int sourceDim = this.source.getGridGeometry().getDimension();
            int dimension = this.dimToAdd.getDimension() + sourceDim;
            if (dimension != sliceExtent.getDimension()) {
                throw new MismatchedDimensionException();
            }
            for (int i = sourceDim; i < dimension; ++i) {
                long expected;
                long actual;
                long size = sliceExtent.getSize(i);
                if (size != 1L) {
                    throw new SubspaceNotSpecifiedException(Resources.format((short)50, sourceDim, sliceExtent.getAxisIdentification(i, i), Numerics.toUnsignedDouble((long)size)));
                }
                if (this.dimToAdd.extent == null || (actual = sliceExtent.getLow(i)) == (expected = this.dimToAdd.extent.getLow(i - sourceDim))) continue;
                throw new DisjointExtentException(sliceExtent.getAxisIdentification(i, i), expected, expected, actual, actual);
            }
            sliceExtent = sliceExtent.selectDimensions(ArraysExt.range((int)0, (int)sourceDim));
        }
        return this.source.render(sliceExtent);
    }
}

