/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.coverage.grid;

import java.awt.image.RenderedImage;
import java.util.Map;
import java.util.TreeMap;
import org.apache.sis.coverage.grid.DerivedGridCoverage;
import org.apache.sis.coverage.grid.DimensionalityReduction;
import org.apache.sis.coverage.grid.EvaluatorWrapper;
import org.apache.sis.coverage.grid.GridCoverage;
import org.apache.sis.coverage.grid.GridExtent;
import org.apache.sis.coverage.grid.GridGeometry;
import org.apache.sis.util.internal.shared.CollectionsExt;

final class ReducedGridCoverage
extends DerivedGridCoverage {
    private final DimensionalityReduction reduction;

    ReducedGridCoverage(GridCoverage source, DimensionalityReduction reduction) {
        super(source, reduction.getReducedGridGeometry());
        this.reduction = reduction;
    }

    @Override
    final boolean isNotRepleacable() {
        return true;
    }

    @Override
    public RenderedImage render(GridExtent sliceExtent) {
        return this.source.render(this.reduction.reverse(sliceExtent));
    }

    @Override
    public GridCoverage.Evaluator evaluator() {
        return new SliceEvaluator(this.source.evaluator());
    }

    private final class SliceEvaluator
    extends EvaluatorWrapper {
        private Map<Integer, Long> slice;

        SliceEvaluator(GridCoverage.Evaluator source) {
            super(source);
            this.setDefaultSlice(null);
        }

        @Override
        public GridCoverage getCoverage() {
            return ReducedGridCoverage.this;
        }

        @Override
        public Map<Integer, Long> getDefaultSlice() {
            if (this.slice == null) {
                TreeMap copy = new TreeMap();
                super.getDefaultSlice().forEach((dim, coord) -> {
                    if ((dim = Integer.valueOf(ReducedGridCoverage.this.reduction.toReducedDimension((int)dim))) >= 0) {
                        copy.put(dim, coord);
                    }
                });
                this.slice = CollectionsExt.unmodifiableOrCopy(copy);
            }
            return this.slice;
        }

        @Override
        public void setDefaultSlice(Map<Integer, Long> slice) {
            if (slice == null) {
                GridGeometry origin = ReducedGridCoverage.this.source.getGridGeometry();
                slice = origin.getExtent().getSliceCoordinates();
            } else {
                TreeMap<Integer, Long> copy = new TreeMap<Integer, Long>();
                slice.forEach((dim, coord) -> copy.put(ReducedGridCoverage.this.reduction.toSourceDimension((int)dim), (Long)coord));
                slice = copy;
            }
            slice.putAll(ReducedGridCoverage.this.reduction.getSliceCoordinates());
            super.setDefaultSlice(slice);
            this.slice = null;
        }
    }
}

