/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.feature.builder;

import org.apache.sis.feature.AbstractIdentifiedType;
import org.apache.sis.feature.builder.FeatureTypeBuilder;
import org.apache.sis.feature.builder.TypeBuilder;
import org.opengis.util.GenericName;

public abstract class PropertyTypeBuilder
extends TypeBuilder {
    private FeatureTypeBuilder owner;
    int minimumOccurs;
    int maximumOccurs;

    PropertyTypeBuilder(PropertyTypeBuilder builder) {
        super(builder);
        this.owner = builder.owner;
        this.minimumOccurs = builder.minimumOccurs;
        this.maximumOccurs = builder.maximumOccurs;
    }

    PropertyTypeBuilder(FeatureTypeBuilder owner) {
        super(owner.getLocale());
        this.owner = owner;
        this.minimumOccurs = owner.defaultMinimumOccurs;
        this.maximumOccurs = owner.defaultMaximumOccurs;
    }

    final FeatureTypeBuilder owner() {
        this.ensureAlive(this.owner);
        return this.owner;
    }

    @Override
    public PropertyTypeBuilder setName(GenericName name) {
        super.setName(name);
        return this;
    }

    @Override
    public PropertyTypeBuilder setName(CharSequence localPart) {
        super.setName(localPart);
        return this;
    }

    @Override
    public PropertyTypeBuilder setName(CharSequence ... components) {
        super.setName(components);
        return this;
    }

    public int getMinimumOccurs() {
        return this.minimumOccurs;
    }

    public PropertyTypeBuilder setMinimumOccurs(int occurs) {
        if (occurs != this.minimumOccurs) {
            if (occurs < 0) {
                throw new IllegalArgumentException(this.errors().getString((short)117, (Object)"occurs", (Object)occurs));
            }
            this.minimumOccurs = occurs;
            if (occurs > this.maximumOccurs) {
                this.maximumOccurs = occurs;
            }
            this.clearCache();
        }
        return this;
    }

    public final int getMaximumOccurs() {
        return this.maximumOccurs;
    }

    public PropertyTypeBuilder setMaximumOccurs(int occurs) {
        if (occurs != this.maximumOccurs) {
            if (occurs < 0) {
                throw new IllegalArgumentException(this.errors().getString((short)117, (Object)"occurs", (Object)occurs));
            }
            this.maximumOccurs = occurs;
            if (occurs < this.minimumOccurs) {
                this.minimumOccurs = occurs;
            }
            this.clearCache();
        }
        return this;
    }

    @Override
    public PropertyTypeBuilder setDefinition(CharSequence definition) {
        super.setDefinition(definition);
        return this;
    }

    @Override
    public PropertyTypeBuilder setDesignation(CharSequence designation) {
        super.setDesignation(designation);
        return this;
    }

    @Override
    public PropertyTypeBuilder setDescription(CharSequence description) {
        super.setDescription(description);
        return this;
    }

    @Override
    public PropertyTypeBuilder setDeprecated(boolean deprecated) {
        super.setDeprecated(deprecated);
        return this;
    }

    boolean isIdentifier() {
        return false;
    }

    @Override
    final GenericName createLocalName(CharSequence name) {
        this.ensureAlive(this.owner);
        return this.owner.createLocalName(name);
    }

    @Override
    final GenericName createGenericName(CharSequence ... names) {
        this.ensureAlive(this.owner);
        return this.owner.createGenericName(names);
    }

    @Override
    void clearCache() {
        this.ensureAlive(this.owner);
        this.owner.clearCache();
    }

    @Override
    public abstract AbstractIdentifiedType build() throws IllegalStateException;

    AbstractIdentifiedType buildForFeature() throws IllegalStateException {
        return this.build();
    }

    final void dispose() {
        this.owner = null;
    }

    @Override
    public void remove() {
        if (this.owner != null) {
            this.owner.replace(this, null, true);
            this.dispose();
        }
    }

    public void replaceBy(PropertyTypeBuilder replacement) {
        FeatureTypeBuilder owner = this.owner();
        if (replacement != null) {
            if (replacement.owner() != owner) {
                throw new IllegalArgumentException(this.resources().getString((short)92));
            }
            owner.replace(replacement, null, false);
        }
        owner.replace(this, replacement, true);
        this.dispose();
        this.remove();
    }
}

