/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.filter;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.sis.feature.DefaultAttributeType;
import org.apache.sis.feature.internal.shared.FeatureExpression;
import org.apache.sis.feature.internal.shared.FeatureProjectionBuilder;
import org.apache.sis.filter.Expression;
import org.apache.sis.filter.Optimization;
import org.apache.sis.filter.internal.Node;
import org.apache.sis.math.FunctionProperty;
import org.apache.sis.util.Classes;
import org.apache.sis.util.ObjectConverters;
import org.apache.sis.util.UnconvertibleObjectException;
import org.apache.sis.util.collection.WeakValueHashMap;
import org.apache.sis.util.iso.Names;
import org.apache.sis.util.resources.Errors;

abstract class LeafExpression<R, V>
extends Node
implements FeatureExpression<R, V> {
    private static final long serialVersionUID = 4262341851590811918L;

    LeafExpression() {
    }

    @Override
    public final List<Expression<R, ?>> getParameters() {
        return List.of();
    }

    @Override
    public Set<FunctionProperty> properties() {
        return Set.of();
    }

    static final class Transformed<R, V>
    extends Literal<R, V>
    implements Optimization.OnExpression<R, V> {
        private static final long serialVersionUID = -5120203649333919221L;
        final Expression<R, ?> original;

        Transformed(V value, Expression<R, ?> original) {
            super(value);
            this.original = original;
        }

        @Override
        public Expression<R, ? extends V> optimize(Optimization optimization) {
            return Optimization.literal(this.getValue());
        }

        @Override
        public <N> Expression<R, N> toValueType(Class<N> target) {
            try {
                Object c = ObjectConverters.convert((Object)this.value, target);
                return c != this.value ? new Literal(c) : this;
            }
            catch (UnconvertibleObjectException e) {
                try {
                    return this.original.toValueType(target);
                }
                catch (RuntimeException bis) {
                    ClassCastException c = new ClassCastException(Errors.format((short)12, (Object)this.getFunctionName(), target));
                    c.initCause(e);
                    c.addSuppressed(bis);
                    throw c;
                }
            }
        }
    }

    static class Literal<R, V>
    extends LeafExpression<R, V>
    implements org.apache.sis.pending.geoapi.filter.Literal<R, V> {
        private static final Set<FunctionProperty> CONSTANT = Set.of(FunctionProperty.ORDER_PRESERVING, FunctionProperty.ORDER_REVERSING);
        private static final long serialVersionUID = -8383113218490957822L;
        protected final V value;
        private static final WeakValueHashMap<Class<?>, DefaultAttributeType<?>> TYPES = new WeakValueHashMap(Class.class);

        Literal(V value) {
            this.value = value;
        }

        @Override
        public Class<? super R> getResourceClass() {
            return Object.class;
        }

        @Override
        protected Collection<?> getChildren() {
            return Collections.singleton(this.value);
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public Class<?> getValueClass() {
            return this.value != null ? this.value.getClass() : Object.class;
        }

        @Override
        public V apply(Object ignored) {
            return this.value;
        }

        @Override
        public Set<FunctionProperty> properties() {
            return CONSTANT;
        }

        @Override
        public <N> Expression<R, N> toValueType(Class<N> target) {
            try {
                Object c = ObjectConverters.convert(this.value, target);
                return c != this.value ? new Literal<R, Object>(c) : this;
            }
            catch (UnconvertibleObjectException e) {
                throw (ClassCastException)new ClassCastException(Errors.format((short)12, (Object)this.getFunctionName(), target)).initCause(e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public FeatureProjectionBuilder.Item expectedType(FeatureProjectionBuilder addTo) {
            DefaultAttributeType propertyType;
            Class<?> valueType = this.getValueClass();
            WeakValueHashMap<Class<?>, DefaultAttributeType<?>> weakValueHashMap = TYPES;
            synchronized (weakValueHashMap) {
                propertyType = (DefaultAttributeType)TYPES.get(valueType);
                if (propertyType == null) {
                    Class standardType = Classes.getStandardType(valueType);
                    propertyType = (DefaultAttributeType)TYPES.computeIfAbsent((Object)standardType, Literal::newType);
                    if (valueType != standardType) {
                        TYPES.put(valueType, (Object)propertyType);
                    }
                }
            }
            return addTo.addSourceProperty(propertyType, true);
        }

        private static <R> DefaultAttributeType<R> newType(Class<R> standardType) {
            return Literal.createType(standardType, Names.createLocalName(null, null, (CharSequence)"Literal"));
        }
    }
}

