/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.image;

import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.ImagingOpException;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.awt.image.WritableRenderedImage;
import java.lang.ref.Reference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import java.util.Vector;
import org.apache.sis.feature.internal.Resources;
import org.apache.sis.image.ComputedTiles;
import org.apache.sis.image.PlanarImage;
import org.apache.sis.image.TileCache;
import org.apache.sis.image.internal.shared.ImageUtilities;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.Disposable;
import org.apache.sis.util.Exceptions;
import org.apache.sis.util.collection.Cache;
import org.apache.sis.util.internal.shared.Numerics;
import org.apache.sis.util.resources.Errors;

public abstract class ComputedImage
extends PlanarImage
implements Disposable {
    public static final String SOURCE_PADDING_KEY = "org.apache.sis.SourcePadding";
    private final ComputedTiles reference;
    private final RenderedImage[] sources;
    private WritableRenderedImage destination;
    protected final SampleModel sampleModel;

    protected ComputedImage(SampleModel sampleModel, RenderedImage ... sources) {
        this.sampleModel = Objects.requireNonNull(sampleModel);
        WritableRenderedImage[] ws = null;
        if (sources != null) {
            sources = (RenderedImage[])sources.clone();
            int count = 0;
            for (int i = 0; i < sources.length; ++i) {
                RenderedImage source = sources[i];
                ArgumentChecks.ensureNonNullElement((String)"sources", (int)i, (Object)source);
                if (!(source instanceof WritableRenderedImage)) continue;
                if (ws == null) {
                    ws = new WritableRenderedImage[sources.length - i];
                }
                ws[count++] = (WritableRenderedImage)source;
            }
            if (count != 0) {
                if (count == sources.length) {
                    sources = ws;
                } else {
                    ws = (WritableRenderedImage[])ArraysExt.resize(ws, (int)count);
                }
            }
        }
        this.sources = sources;
        this.reference = new ComputedTiles(this, ws);
    }

    final Reference<ComputedImage> reference() {
        return this.reference;
    }

    final void setDestination(WritableRenderedImage target) {
        if (this.destination != null) {
            throw new IllegalStateException(Errors.format((short)1, (Object)"destination"));
        }
        if (target != null) {
            if (!this.sampleModel.equals(target.getSampleModel())) {
                throw new IllegalArgumentException(Resources.format((short)46));
            }
            if (target.getTileGridXOffset() != this.getTileGridXOffset() || target.getTileGridYOffset() != this.getTileGridYOffset()) {
                throw new IllegalArgumentException(Resources.format((short)47));
            }
            this.destination = target;
        }
    }

    final WritableRenderedImage getDestination() {
        return this.destination;
    }

    final RenderedImage getSource() {
        return this.sources[0];
    }

    final RenderedImage[] getSourceArray() {
        return (RenderedImage[])this.sources.clone();
    }

    final int getNumSources() {
        return this.sources != null ? this.sources.length : 0;
    }

    protected final RenderedImage getSource(int index) {
        if (this.sources != null) {
            return this.sources[index];
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public Vector<RenderedImage> getSources() {
        return this.sources != null ? new Vector<RenderedImage>(Arrays.asList(this.sources)) : null;
    }

    private <T> T getProperty(Class<T> type, String name, RenderedImage source) {
        Object value = this.getProperty(name);
        if (type.isInstance(value)) {
            return (T)value;
        }
        if (this.sources != null && value instanceof Object[]) {
            Object[] array = (Object[])value;
            int n = Math.min(this.sources.length, array.length);
            for (int i = 0; i < n; ++i) {
                if (this.sources[i] != source || !type.isInstance(value = array[i])) continue;
                return (T)value;
            }
        }
        return null;
    }

    @Override
    public final SampleModel getSampleModel() {
        return this.sampleModel;
    }

    @Override
    public final int getTileWidth() {
        return this.sampleModel.getWidth();
    }

    @Override
    public final int getTileHeight() {
        return this.sampleModel.getHeight();
    }

    private static void checkTileIndex(String name, int min, int count, int value) {
        int max = min + count;
        if (value < min || value >= max) {
            throw new IndexOutOfBoundsException(Errors.format((short)204, (Object)name, (Object)min, (Object)(max - 1), (Object)value));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Raster getTile(int tileX, int tileY) {
        TileCache cache = TileCache.GLOBAL;
        TileCache.Key key = new TileCache.Key(this.reference, tileX, tileY);
        Raster tile = (Raster)cache.peek(key);
        if (tile == null || this.reference.isTileDirty(key)) {
            Throwable error;
            block13: {
                ComputedImage.checkTileIndex("tileX", this.getMinTileX(), this.getNumXTiles(), tileX);
                ComputedImage.checkTileIndex("tileY", this.getMinTileY(), this.getNumYTiles(), tileY);
                error = null;
                Cache.Handler handler = cache.lock(key);
                try {
                    int min;
                    boolean writeInDestination;
                    tile = (Raster)handler.peek();
                    boolean marked = this.reference.trySetComputing(key);
                    if (!marked && tile != null) break block13;
                    WritableRenderedImage destination = this.destination;
                    boolean bl = writeInDestination = destination != null && tileX >= (min = destination.getMinTileX()) && tileX < min + destination.getNumXTiles() && tileY >= (min = destination.getMinTileY()) && tileY < min + destination.getNumYTiles();
                    WritableRaster previous = writeInDestination ? destination.getWritableTile(tileX, tileY) : (tile instanceof WritableRaster ? (WritableRaster)tile : null);
                    try {
                        tile = this.computeTile(tileX, tileY, previous);
                    }
                    catch (Exception e) {
                        tile = null;
                        error = Exceptions.unwrap((Exception)e);
                    }
                    finally {
                        if (writeInDestination) {
                            destination.releaseWritableTile(tileX, tileY);
                        }
                    }
                    if (marked) {
                        this.reference.endWrite(key, error == null);
                    }
                }
                finally {
                    handler.putAndUnlock((Object)tile);
                }
            }
            if (tile == null) {
                if (!(error instanceof ImagingOpException)) {
                    error = new ImagingOpException(key.error((short)4)).initCause(error);
                }
                throw (ImagingOpException)error;
            }
        }
        return tile;
    }

    protected abstract Raster computeTile(int var1, int var2, WritableRaster var3) throws Exception;

    protected WritableRaster createTile(int tileX, int tileY) {
        int x = ImageUtilities.tileToPixelX(this, tileX);
        int y = ImageUtilities.tileToPixelY(this, tileY);
        return WritableRaster.createWritableRaster(this.sampleModel, new Point(x, y));
    }

    @Override
    protected Disposable prefetch(Rectangle tiles) {
        return null;
    }

    public boolean hasTileWriters() {
        return this.reference.getWritableTileIndices(null);
    }

    public boolean isTileWritable(int tileX, int tileY) {
        return this.reference.isTileWritable(new TileCache.Key(this.reference, tileX, tileY));
    }

    public Point[] getWritableTileIndices() {
        ArrayList<Point> indices = new ArrayList<Point>();
        if (this.reference.getWritableTileIndices(indices)) {
            return (Point[])indices.toArray(Point[]::new);
        }
        return null;
    }

    protected boolean markTileWritable(int tileX, int tileY, boolean writing) {
        TileCache.Key key = new TileCache.Key(this.reference, tileX, tileY);
        if (writing) {
            return this.reference.startWrite(key);
        }
        return this.reference.endWrite(key, true);
    }

    protected boolean markDirtyTiles(Rectangle tiles) {
        return this.reference.markDirtyTiles(tiles.x, tiles.y, Math.addExact(tiles.x, tiles.width - 1), Math.addExact(tiles.y, tiles.height - 1), false);
    }

    protected boolean clearErrorFlags(Rectangle tiles) {
        return this.reference.markDirtyTiles(tiles.x, tiles.y, Math.addExact(tiles.x, tiles.width - 1), Math.addExact(tiles.y, tiles.height - 1), true);
    }

    protected void sourceTileChanged(RenderedImage source, int tileX, int tileY) {
        long sourceWidth = source.getTileWidth();
        long sourceHeight = source.getTileHeight();
        long targetWidth = this.getTileWidth();
        long targetHeight = this.getTileHeight();
        long tx = (long)tileX * sourceWidth + (long)source.getTileGridXOffset() - (long)this.getTileGridXOffset();
        long ty = (long)tileY * sourceHeight + (long)source.getTileGridYOffset() - (long)this.getTileGridYOffset();
        Insets b = this.getProperty(Insets.class, SOURCE_PADDING_KEY, source);
        this.reference.markDirtyTiles(Numerics.clamp((long)Math.floorDiv(tx - (long)(b == null ? 0 : b.left), targetWidth)), Numerics.clamp((long)Math.floorDiv(ty - (long)(b == null ? 0 : b.top), targetHeight)), Numerics.clamp((long)Math.floorDiv(tx + (long)(b == null ? 0 : b.right) + sourceWidth - 1L, targetWidth)), Numerics.clamp((long)Math.floorDiv(ty + (long)(b == null ? 0 : b.bottom) + sourceHeight - 1L, targetHeight)), false);
    }

    public void dispose() {
        this.reference.dispose();
    }

    final int hashCodeBase() {
        return Arrays.hashCode(this.sources) + 31 * this.sampleModel.hashCode() + 37 * Objects.hash(this.destination);
    }

    final boolean equalsBase(Object object) {
        if (object != null && this.getClass().equals(object.getClass())) {
            ComputedImage other = (ComputedImage)object;
            return Arrays.equals(this.sources, other.sources) && Objects.equals(this.destination, other.destination) && this.sampleModel.equals(other.sampleModel);
        }
        return false;
    }
}

