/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.image;

import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.image.BufferedImage;
import java.awt.image.ImagingOpException;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRenderedImage;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Objects;
import java.util.Vector;
import java.util.function.DoubleUnaryOperator;
import javax.measure.Quantity;
import org.apache.sis.feature.internal.Resources;
import org.apache.sis.image.BandAggregateImage;
import org.apache.sis.image.BandSelectImage;
import org.apache.sis.image.BandedSampleConverter;
import org.apache.sis.image.Colorizer;
import org.apache.sis.image.DataType;
import org.apache.sis.image.ErrorHandler;
import org.apache.sis.image.ImageAdapter;
import org.apache.sis.image.ImageLayout;
import org.apache.sis.image.ImageOverlay;
import org.apache.sis.image.Interpolation;
import org.apache.sis.image.MaskedImage;
import org.apache.sis.image.PrefetchedImage;
import org.apache.sis.image.RecoloredImage;
import org.apache.sis.image.ResampledImage;
import org.apache.sis.image.StatisticsCalculator;
import org.apache.sis.image.UserProperties;
import org.apache.sis.image.Visualization;
import org.apache.sis.image.internal.shared.ImageUtilities;
import org.apache.sis.image.internal.shared.TiledImage;
import org.apache.sis.image.processing.isoline.Isolines;
import org.apache.sis.math.Statistics;
import org.apache.sis.measure.NumberRange;
import org.apache.sis.referencing.operation.transform.MathTransforms;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.collection.WeakHashSet;
import org.apache.sis.util.resources.Errors;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransform1D;
import org.opengis.referencing.operation.NoninvertibleTransformException;
import org.opengis.referencing.operation.TransformException;

public class ImageProcessor
implements Cloneable {
    private static final WeakHashSet<RenderedImage> CACHE = new WeakHashSet(RenderedImage.class);
    private ImageLayout layout = ImageLayout.DEFAULT;
    private Interpolation interpolation;
    private Number[] fillValues;
    private Colorizer colorizer;
    private Quantity<?>[] positionalAccuracyHints;
    private Mode executionMode = Mode.DEFAULT;
    private ErrorHandler errorHandler = ErrorHandler.THROW;

    static RenderedImage unique(RenderedImage image) {
        return (RenderedImage)CACHE.unique((Object)image);
    }

    public ImageProcessor() {
        this.interpolation = Interpolation.BILINEAR;
    }

    public synchronized ImageLayout getImageLayout() {
        return this.layout;
    }

    public synchronized void setImageLayout(ImageLayout layout) {
        this.layout = Objects.requireNonNull(layout);
    }

    public synchronized Interpolation getInterpolation() {
        return this.interpolation;
    }

    public synchronized void setInterpolation(Interpolation method) {
        this.interpolation = Objects.requireNonNull(method);
    }

    public synchronized Number[] getFillValues() {
        return this.fillValues != null ? (Number[])this.fillValues.clone() : null;
    }

    public synchronized void setFillValues(Number ... values) {
        this.fillValues = values != null ? (Number[])values.clone() : null;
    }

    public synchronized Colorizer getColorizer() {
        return this.colorizer;
    }

    public synchronized void setColorizer(Colorizer colorizer) {
        this.colorizer = colorizer;
    }

    @Deprecated(since="1.5", forRemoval=true)
    public synchronized Resizing getImageResizingPolicy() {
        return this.layout.isImageBoundsAdjustmentAllowed ? Resizing.EXPAND : Resizing.NONE;
    }

    @Deprecated(since="1.5", forRemoval=true)
    public synchronized void setImageResizingPolicy(Resizing policy) {
        this.layout = policy.layout;
    }

    public synchronized Quantity<?>[] getPositionalAccuracyHints() {
        return this.positionalAccuracyHints != null ? (Quantity[])this.positionalAccuracyHints.clone() : new Quantity[]{};
    }

    public synchronized void setPositionalAccuracyHints(Quantity<?> ... hints) {
        if (hints != null) {
            Object[] copy = new Quantity[hints.length];
            int n = 0;
            for (Quantity<?> hint : hints) {
                if (hint == null) continue;
                copy[n++] = hint;
            }
            if (n != 0) {
                this.positionalAccuracyHints = (Quantity[])ArraysExt.resize((Object[])copy, (int)n);
                return;
            }
        }
        this.positionalAccuracyHints = null;
    }

    public synchronized Mode getExecutionMode() {
        return this.executionMode;
    }

    public synchronized void setExecutionMode(Mode mode) {
        this.executionMode = Objects.requireNonNull(mode);
    }

    private boolean parallel(RenderedImage source) {
        assert (Thread.holdsLock(this));
        switch (this.executionMode.ordinal()) {
            case 0: {
                return true;
            }
            case 1: {
                return false;
            }
        }
        if (source instanceof BufferedImage) {
            return true;
        }
        return source.getClass().getName().startsWith("org.apache.sis.");
    }

    public synchronized ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    public synchronized void setErrorHandler(ErrorHandler handler) {
        this.errorHandler = Objects.requireNonNull(handler);
    }

    private boolean failOnException() {
        assert (Thread.holdsLock(this));
        return this.errorHandler == ErrorHandler.THROW;
    }

    public static DoubleUnaryOperator filterNodataValues(Number ... values) {
        return values != null ? StatisticsCalculator.filterNodataValues(values) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Statistics[] valueOfStatistics(RenderedImage source, Shape areaOfInterest, DoubleUnaryOperator ... sampleFilters) {
        ErrorHandler errorListener;
        boolean failOnException;
        boolean parallel;
        Object property;
        ArgumentChecks.ensureNonNull((String)"source", (Object)source);
        int[] bandsToCompute = null;
        Statistics[] statistics = null;
        if (areaOfInterest == null && (sampleFilters == null || ArraysExt.allEquals((Object[])sampleFilters, null)) && (property = source.getProperty("org.apache.sis.Statistics")) instanceof Statistics[]) {
            statistics = (Statistics[])ArraysExt.resize((Object[])((Statistics[])property), (int)ImageUtilities.getNumBands(source));
            bandsToCompute = new int[statistics.length];
            int n = 0;
            for (int i = 0; i < statistics.length; ++i) {
                if (statistics[i] != null) continue;
                bandsToCompute[n++] = i;
            }
            if (n == 0) {
                return statistics;
            }
            bandsToCompute = ArraysExt.resize((int[])bandsToCompute, (int)n);
            source = this.selectBands(source, bandsToCompute);
        }
        ImageProcessor imageProcessor = this;
        synchronized (imageProcessor) {
            parallel = this.parallel(source);
            failOnException = this.failOnException();
            errorListener = this.errorHandler;
        }
        StatisticsCalculator calculator = new StatisticsCalculator(source, areaOfInterest, sampleFilters, parallel, failOnException);
        Object property2 = calculator.getProperty("org.apache.sis.Statistics");
        calculator.logAndClearError(ImageProcessor.class, "valueOfStatistics", errorListener);
        Statistics[] computed = (Statistics[])property2;
        if (bandsToCompute == null) {
            return computed;
        }
        for (int i = 0; i < bandsToCompute.length; ++i) {
            statistics[bandsToCompute[i]] = computed[i];
        }
        return statistics;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RenderedImage statistics(RenderedImage source, Shape areaOfInterest, DoubleUnaryOperator ... sampleFilters) {
        boolean failOnException;
        boolean parallel;
        ArgumentChecks.ensureNonNull((String)"source", (Object)source);
        if (areaOfInterest == null && (sampleFilters == null || ArraysExt.allEquals((Object[])sampleFilters, null)) && ArraysExt.contains((Object[])source.getPropertyNames(), (Object)"org.apache.sis.Statistics")) {
            return source;
        }
        ImageProcessor imageProcessor = this;
        synchronized (imageProcessor) {
            parallel = this.parallel(source);
            failOnException = this.failOnException();
        }
        return new StatisticsCalculator(source, areaOfInterest, sampleFilters, parallel, failOnException).unique();
    }

    public RenderedImage stretchColorRamp(RenderedImage source, Map<String, ?> modifiers) {
        ArgumentChecks.ensureNonNull((String)"source", (Object)source);
        return RecoloredImage.stretchColorRamp(this, source, modifiers);
    }

    public RenderedImage addUserProperties(RenderedImage source, Map<String, Object> properties) {
        return ImageProcessor.unique(new UserProperties(source, properties));
    }

    public RenderedImage selectBands(RenderedImage source, int ... bands) {
        ArgumentChecks.ensureNonNull((String)"source", (Object)source);
        return BandSelectImage.create(source, true, (int[])bands.clone());
    }

    public RenderedImage aggregateBands(RenderedImage ... sources) {
        return this.aggregateBands(sources, (int[][])null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RenderedImage aggregateBands(RenderedImage[] sources, int[][] bandsPerSource) {
        boolean parallel;
        Colorizer colorizer;
        ArgumentChecks.ensureNonEmpty((String)"sources", (Object[])sources);
        ImageProcessor imageProcessor = this;
        synchronized (imageProcessor) {
            colorizer = this.colorizer;
            parallel = this.executionMode != Mode.SEQUENTIAL;
        }
        return BandAggregateImage.create(sources, bandsPerSource, colorizer, true, true, parallel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RenderedImage overlay(RenderedImage[] sources, Rectangle bounds) {
        boolean parallel;
        Colorizer colorizer;
        ImageLayout layout;
        ArgumentChecks.ensureNonEmpty((String)"sources", (Object[])sources);
        ImageProcessor imageProcessor = this;
        synchronized (imageProcessor) {
            layout = this.layout;
            colorizer = this.colorizer;
            parallel = this.executionMode != Mode.SEQUENTIAL;
        }
        return ImageOverlay.create(sources, bounds, layout.sampleModel, colorizer, layout.isTileSizeAdjustmentAllowed | bounds != null, parallel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RenderedImage reformat(RenderedImage source, SampleModel sampleModel) {
        boolean parallel;
        ImageLayout layout;
        ArgumentChecks.ensureNonNull((String)"source", (Object)source);
        ImageProcessor imageProcessor = this;
        synchronized (imageProcessor) {
            layout = this.layout;
            parallel = this.executionMode != Mode.SEQUENTIAL;
        }
        if (sampleModel == null) {
            sampleModel = layout.sampleModel;
            ArgumentChecks.ensureNonNull((String)"sampleModel", (Object)sampleModel);
        }
        return ImageOverlay.create(new RenderedImage[]{source}, null, sampleModel, null, layout.isTileSizeAdjustmentAllowed, parallel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RenderedImage mask(RenderedImage source, Shape mask, boolean maskInside) {
        Number[] fillValues;
        ArgumentChecks.ensureNonNull((String)"source", (Object)source);
        ArgumentChecks.ensureNonNull((String)"mask", (Object)mask);
        ImageProcessor imageProcessor = this;
        synchronized (imageProcessor) {
            fillValues = this.fillValues;
        }
        return ImageProcessor.unique(new MaskedImage(source, mask, maskInside, fillValues));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RenderedImage convert(RenderedImage source, NumberRange<?>[] sourceRanges, MathTransform1D[] converters, DataType targetType) {
        Colorizer colorizer;
        ImageLayout layout;
        ArgumentChecks.ensureNonNull((String)"source", (Object)source);
        ArgumentChecks.ensureNonNull((String)"converters", (Object)converters);
        ArgumentChecks.ensureNonNull((String)"targetType", (Object)((Object)targetType));
        ArgumentChecks.ensureCountBetween((String)"converters", (boolean)true, (int)1, (int)ImageUtilities.getNumBands(source), (int)converters.length);
        converters = (MathTransform1D[])converters.clone();
        for (int i = 0; i < converters.length; ++i) {
            ArgumentChecks.ensureNonNullElement((String)"converters", (int)i, (Object)converters[i]);
        }
        ImageProcessor imageProcessor = this;
        synchronized (imageProcessor) {
            layout = this.layout;
            colorizer = this.colorizer;
        }
        return ImageProcessor.unique(BandedSampleConverter.create(source, layout, sourceRanges, converters, targetType, colorizer));
    }

    private static void ensureNonEmpty(Rectangle bounds) {
        if (bounds != null && bounds.isEmpty()) {
            throw new IllegalArgumentException(Errors.format((short)44, (Object)"bounds"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RenderedImage resample(RenderedImage source, Rectangle bounds, MathTransform toSource) {
        RenderedImage resampled;
        RenderedImage colored;
        block7: {
            Quantity<?>[] positionalAccuracyHints;
            Number[] fillValues;
            Interpolation interpolation;
            ImageLayout layout;
            ArgumentChecks.ensureNonNull((String)"source", (Object)source);
            ArgumentChecks.ensureNonNull((String)"bounds", (Object)bounds);
            ArgumentChecks.ensureNonNull((String)"toSource", (Object)toSource);
            ImageProcessor.ensureNonEmpty(bounds);
            colored = source;
            SampleModel sm = source.getSampleModel();
            boolean isIdentity = toSource.isIdentity();
            resampled = null;
            while (true) {
                Vector<RenderedImage> sources;
                if (isIdentity && bounds.x == source.getMinX() && bounds.y == source.getMinY() && bounds.width == source.getWidth() && bounds.height == source.getHeight()) {
                    resampled = source;
                    break block7;
                }
                if (!Objects.equals(sm, source.getSampleModel())) break;
                if (source instanceof ImageAdapter) {
                    source = ((ImageAdapter)source).source;
                    continue;
                }
                if (!(source instanceof ResampledImage) || (sources = source.getSources()) == null || sources.size() != 1) break;
                toSource = MathTransforms.concatenate((MathTransform)toSource, (MathTransform)((ResampledImage)source).toSource);
                isIdentity = toSource.isIdentity();
                source = (RenderedImage)sources.get(0);
            }
            ImageProcessor imageProcessor = this;
            synchronized (imageProcessor) {
                layout = this.layout;
                interpolation = this.interpolation;
                fillValues = this.fillValues;
                positionalAccuracyHints = this.positionalAccuracyHints;
            }
            WritableRenderedImage destination = layout.getDestination();
            SampleModel rsm = layout.createCompatibleSampleModel(source, bounds);
            ResampledImage image = new ResampledImage(source, rsm, layout.getPreferredMinTile(), bounds, toSource, interpolation, fillValues, positionalAccuracyHints);
            image.setDestination(destination);
            resampled = ImageProcessor.unique(image);
            if (destination != null) {
                return resampled;
            }
        }
        return RecoloredImage.applySameColors(resampled, colored);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RenderedImage prefetch(RenderedImage source, Rectangle areaOfInterest) {
        ErrorHandler errorListener;
        boolean parallel;
        if (source == null || source instanceof BufferedImage || source instanceof TiledImage) {
            return source;
        }
        if (source instanceof PrefetchedImage) {
            source = ((PrefetchedImage)source).source;
        }
        ImageProcessor imageProcessor = this;
        synchronized (imageProcessor) {
            parallel = this.parallel(source);
            errorListener = this.errorHandler;
        }
        PrefetchedImage image = new PrefetchedImage(source, areaOfInterest, errorListener, parallel);
        return image.isEmpty() ? source : image;
    }

    public RenderedImage visualize(RenderedImage source) {
        ArgumentChecks.ensureNonNull((String)"source", (Object)source);
        return this.visualize(new Visualization.Builder(null, source, null));
    }

    public RenderedImage visualize(RenderedImage source, Rectangle bounds, MathTransform toSource) {
        ArgumentChecks.ensureNonNull((String)"source", (Object)source);
        ArgumentChecks.ensureNonNull((String)"bounds", (Object)bounds);
        ArgumentChecks.ensureNonNull((String)"toSource", (Object)toSource);
        ImageProcessor.ensureNonEmpty(bounds);
        return this.visualize(new Visualization.Builder(bounds, source, toSource));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RenderedImage visualize(Visualization.Builder builder) {
        ImageProcessor imageProcessor = this;
        synchronized (imageProcessor) {
            builder.layout = this.layout;
            builder.interpolation = this.interpolation;
            builder.colorizer = this.colorizer;
            builder.fillValues = this.fillValues;
            builder.positionalAccuracyHints = this.positionalAccuracyHints;
        }
        try {
            return builder.create(this);
        }
        catch (IllegalStateException | NoninvertibleTransformException e) {
            throw new IllegalArgumentException(Resources.format((short)66), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<NavigableMap<Double, Shape>> isolines(RenderedImage data, double[][] levels, MathTransform gridToCRS) {
        boolean parallel;
        ArgumentChecks.ensureNonNull((String)"data", (Object)data);
        ArgumentChecks.ensureNonNull((String)"levels", (Object)levels);
        ImageProcessor imageProcessor = this;
        synchronized (imageProcessor) {
            parallel = this.parallel(data);
        }
        if (parallel) {
            return Isolines.toList(Isolines.parallelGenerate(data, levels, gridToCRS));
        }
        try {
            return Isolines.toList(Isolines.generate(data, levels, gridToCRS));
        }
        catch (TransformException e) {
            throw (ImagingOpException)new ImagingOpException(null).initCause(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean equals(Object object) {
        if (object != null && object.getClass() == this.getClass()) {
            Object[] positionalAccuracyHints;
            Colorizer colorizer;
            ImageLayout layout;
            Object[] fillValues;
            Interpolation interpolation;
            ErrorHandler errorHandler;
            Mode executionMode;
            ImageProcessor other = (ImageProcessor)object;
            ImageProcessor imageProcessor = this;
            synchronized (imageProcessor) {
                executionMode = this.executionMode;
                errorHandler = this.errorHandler;
                interpolation = this.interpolation;
                fillValues = this.fillValues;
                layout = this.layout;
                colorizer = this.colorizer;
                positionalAccuracyHints = this.positionalAccuracyHints;
            }
            imageProcessor = other;
            synchronized (imageProcessor) {
                return layout.equals(other.layout) && errorHandler.equals(other.errorHandler) && executionMode.equals((Object)other.executionMode) && interpolation.equals(other.interpolation) && Objects.equals(colorizer, other.colorizer) && Arrays.equals(fillValues, other.fillValues) && Arrays.equals(positionalAccuracyHints, other.positionalAccuracyHints);
            }
        }
        return false;
    }

    public synchronized int hashCode() {
        return Objects.hash(new Object[]{this.getClass(), this.errorHandler, this.executionMode, this.colorizer, this.interpolation, this.layout}) + 37 * Arrays.hashCode(this.fillValues) + 39 * Arrays.hashCode(this.positionalAccuracyHints);
    }

    public synchronized ImageProcessor clone() {
        try {
            return (ImageProcessor)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static enum Mode {
        PARALLEL,
        SEQUENTIAL,
        DEFAULT;

    }

    @Deprecated(since="1.5", forRemoval=true)
    public static enum Resizing {
        NONE(ImageLayout.DEFAULT),
        EXPAND(ImageLayout.DEFAULT.allowImageBoundsAdjustments(true));

        public final ImageLayout layout;

        private Resizing(ImageLayout layout) {
            this.layout = layout;
        }
    }
}

