/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.image;

import java.awt.Image;
import java.awt.image.RenderedImage;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.sis.image.ImageAdapter;

final class UserProperties
extends ImageAdapter {
    private final Map<String, Object> properties;

    UserProperties(RenderedImage source, Map<String, Object> properties) {
        super(source);
        this.properties = Objects.requireNonNull(properties);
    }

    @Override
    public String[] getPropertyNames() {
        String[] names = super.getPropertyNames();
        if (!this.properties.isEmpty()) {
            Set<String> union;
            if (names != null) {
                union = new HashSet<String>(Arrays.asList(names));
                union.addAll(this.properties.keySet());
            } else {
                union = this.properties.keySet();
            }
            names = (String[])union.toArray(String[]::new);
        }
        return names.length != 0 ? names : null;
    }

    @Override
    public Object getProperty(String name) {
        Object value = this.properties.getOrDefault(name, Image.UndefinedProperty);
        if (value == Image.UndefinedProperty) {
            value = super.getProperty(name);
        }
        return value;
    }

    @Override
    public boolean equals(Object object) {
        return super.equals(object) && this.properties.equals(((UserProperties)object).properties);
    }

    @Override
    public int hashCode() {
        return super.hashCode() + 71 * this.properties.hashCode();
    }

    @Override
    Class<? extends ImageAdapter> appendStringContent(StringBuilder buffer) {
        buffer.append(this.properties.keySet());
        return UserProperties.class;
    }
}

