/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.ArrayList;
import java.util.List;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.sql.compile.Visitor;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.util.JBitSet;
import org.apache.derby.impl.sql.compile.AggregateNode;
import org.apache.derby.impl.sql.compile.AndNode;
import org.apache.derby.impl.sql.compile.BinaryRelationalOperatorNode;
import org.apache.derby.impl.sql.compile.BooleanConstantNode;
import org.apache.derby.impl.sql.compile.ConstantNode;
import org.apache.derby.impl.sql.compile.ExpressionClassBuilder;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.FromTable;
import org.apache.derby.impl.sql.compile.PredicateList;
import org.apache.derby.impl.sql.compile.ResultColumn;
import org.apache.derby.impl.sql.compile.ResultColumnList;
import org.apache.derby.impl.sql.compile.ResultSetNode;
import org.apache.derby.impl.sql.compile.SubqueryList;
import org.apache.derby.impl.sql.compile.TableName;
import org.apache.derby.impl.sql.compile.ValueNode;
import org.apache.derby.impl.sql.compile.VirtualColumnNode;
import org.apache.derby.shared.common.error.StandardException;

public class ColumnReference
extends ValueNode {
    public static final int MERGE_UNKNOWN = 0;
    public static final int MERGE_SOURCE = 1;
    public static final int MERGE_TARGET = 2;
    private String _columnName;
    private TableName _qualifiedTableName;
    private int tableNumber;
    private int columnNumber;
    private ResultColumn source;
    private ResultColumn _origSource;
    private String origName;
    private int _origTableNumber = -1;
    private int _origColumnNumber = -1;
    private int tableNumberBeforeFlattening = -1;
    private int columnNumberBeforeFlattening = -1;
    private boolean replacesAggregate;
    private boolean replacesWindowFunctionCall;
    private int nestingLevel = -1;
    private int sourceLevel = -1;
    private boolean scoped;
    private ArrayList<RemapInfo> remaps;
    private int _mergeTableID = 0;

    ColumnReference(String string, TableName tableName, int n, int n2, ContextManager contextManager) {
        super(contextManager);
        this._columnName = string;
        this._qualifiedTableName = tableName;
        this.setBeginOffset(n);
        this.setEndOffset(n2);
        this.tableNumber = -1;
        this.remaps = null;
    }

    ColumnReference(String string, TableName tableName, ContextManager contextManager) {
        super(contextManager);
        this._columnName = string;
        this._qualifiedTableName = tableName;
        this.tableNumber = -1;
        this.remaps = null;
    }

    @Override
    public String toString() {
        return "";
    }

    @Override
    void printSubNodes(int n) {
    }

    boolean getCorrelated() {
        return this.sourceLevel != this.nestingLevel;
    }

    void setNestingLevel(int n) {
        this.nestingLevel = n;
    }

    private int getNestingLevel() {
        return this.nestingLevel;
    }

    void setSourceLevel(int n) {
        this.sourceLevel = n;
    }

    int getSourceLevel() {
        return this.sourceLevel;
    }

    void markGeneratedToReplaceAggregate() {
        this.replacesAggregate = true;
    }

    void markGeneratedToReplaceWindowFunctionCall() {
        this.replacesWindowFunctionCall = true;
    }

    boolean getGeneratedToReplaceAggregate() {
        return this.replacesAggregate;
    }

    boolean getGeneratedToReplaceWindowFunctionCall() {
        return this.replacesWindowFunctionCall;
    }

    @Override
    ValueNode getClone() throws StandardException {
        ColumnReference columnReference = new ColumnReference(this._columnName, this._qualifiedTableName, this.getContextManager());
        columnReference.copyFields(this);
        return columnReference;
    }

    void copyFields(ColumnReference columnReference) throws StandardException {
        super.copyFields(columnReference);
        this.setQualifiedTableName(columnReference.getQualifiedTableName());
        this.tableNumber = columnReference.getTableNumber();
        this.columnNumber = columnReference.getColumnNumber();
        this.source = columnReference.getSource();
        this.nestingLevel = columnReference.getNestingLevel();
        this.sourceLevel = columnReference.getSourceLevel();
        this.replacesAggregate = columnReference.getGeneratedToReplaceAggregate();
        this.replacesWindowFunctionCall = columnReference.getGeneratedToReplaceWindowFunctionCall();
        this.scoped = columnReference.isScoped();
        this.copyTagsFrom(columnReference);
        if (columnReference._mergeTableID != 0) {
            this.setMergeTableID(columnReference.getMergeTableID());
        }
    }

    @Override
    ColumnReference bindExpression(FromList fromList, SubqueryList subqueryList, List<AggregateNode> list) throws StandardException {
        if (fromList.size() == 0) {
            throw StandardException.newException((String)"42X15", (Object[])new Object[]{this._columnName});
        }
        ResultColumn resultColumn = fromList.bindColumnReference(this);
        if (resultColumn == null) {
            throw StandardException.newException((String)"42X04", (Object[])new Object[]{this.getSQLColumnName()});
        }
        return this;
    }

    String getSQLColumnName() {
        if (this._qualifiedTableName == null) {
            return this._columnName;
        }
        return this._qualifiedTableName.toString() + "." + this._columnName;
    }

    @Override
    public String getColumnName() {
        return this._columnName;
    }

    int getTableNumber() {
        return this.tableNumber;
    }

    void setTableNumber(int n) {
        this.tableNumber = n;
    }

    @Override
    String getTableName() {
        return this._qualifiedTableName != null ? this._qualifiedTableName.getTableName() : null;
    }

    String getSourceTableName() {
        return this.source != null ? this.source.getTableName() : null;
    }

    String getSourceSchemaName() throws StandardException {
        return this.source != null ? this.source.getSchemaName() : null;
    }

    @Override
    public boolean updatableByCursor() {
        return this.source != null ? this.source.updatableByCursor() : false;
    }

    public TableName getQualifiedTableName() {
        return this._qualifiedTableName;
    }

    void setQualifiedTableName(TableName tableName) {
        this._qualifiedTableName = tableName;
    }

    int getColumnNumber() {
        return this.columnNumber;
    }

    void setColumnNumber(int n) {
        this.columnNumber = n;
    }

    ResultColumn getSource() {
        return this.source;
    }

    void setSource(ResultColumn resultColumn) {
        this.source = resultColumn;
    }

    @Override
    ValueNode putAndsOnTop() throws StandardException {
        BooleanConstantNode booleanConstantNode = new BooleanConstantNode(true, this.getContextManager());
        BinaryRelationalOperatorNode binaryRelationalOperatorNode = new BinaryRelationalOperatorNode(0, (ValueNode)this, booleanConstantNode, false, this.getContextManager());
        binaryRelationalOperatorNode.bindComparisonOperator();
        AndNode andNode = new AndNode(binaryRelationalOperatorNode, booleanConstantNode, this.getContextManager());
        andNode.postBindFixup();
        return andNode;
    }

    @Override
    boolean categorize(JBitSet jBitSet, boolean bl) {
        jBitSet.set(this.tableNumber);
        return !this.replacesAggregate && !this.replacesWindowFunctionCall && (this.source.getExpression() instanceof ColumnReference || this.source.getExpression() instanceof VirtualColumnNode || this.source.getExpression() instanceof ConstantNode);
    }

    void remapColumnReferences() {
        ValueNode valueNode = this.source.getExpression();
        if (!(valueNode instanceof VirtualColumnNode) && !(valueNode instanceof ColumnReference)) {
            return;
        }
        if (this.scoped && this._origSource != null) {
            if (this.remaps == null) {
                this.remaps = new ArrayList();
            }
            this.remaps.add(new RemapInfo(this.columnNumber, this.tableNumber, this._columnName, this.source));
        } else {
            this._origSource = this.source;
            this.origName = this._columnName;
            this._origColumnNumber = this.columnNumber;
            this._origTableNumber = this.tableNumber;
        }
        this.source = this.getSourceResultColumn();
        this._columnName = this.source.getName();
        int n = this.columnNumber = this.source.getExpression() instanceof VirtualColumnNode ? this.source.getVirtualColumnId() : this.source.getColumnPosition();
        if (this.source.getExpression() instanceof ColumnReference) {
            ColumnReference columnReference = (ColumnReference)this.source.getExpression();
            this.tableNumber = columnReference.getTableNumber();
        }
    }

    void unRemapColumnReferences() {
        if (this._origSource == null) {
            return;
        }
        if (this.remaps == null || this.remaps.isEmpty()) {
            this.source = this._origSource;
            this._origSource = null;
            this._columnName = this.origName;
            this.origName = null;
            this.tableNumber = this._origTableNumber;
            this.columnNumber = this._origColumnNumber;
        } else {
            RemapInfo remapInfo = this.remaps.remove(this.remaps.size() - 1);
            this.source = remapInfo.getSource();
            this._columnName = remapInfo.getColumnName();
            this.tableNumber = remapInfo.getTableNumber();
            this.columnNumber = remapInfo.getColumnNumber();
            if (this.remaps.isEmpty()) {
                this.remaps = null;
            }
        }
    }

    protected boolean hasBeenRemapped() {
        return this._origSource != null;
    }

    @Override
    ResultColumn getSourceResultColumn() {
        return this.source.getExpression().getSourceResultColumn();
    }

    @Override
    ValueNode remapColumnReferencesToExpressions() throws StandardException {
        ValueNode valueNode;
        ValueNode valueNode2 = this.source;
        if (!this.source.isRedundant()) {
            return this;
        }
        ValueNode valueNode3 = this.source;
        while (valueNode3 != null && valueNode3.isRedundant()) {
            valueNode = valueNode3.getExpression().getSourceResultColumn();
            if (valueNode != null && ((ResultColumn)valueNode).isRedundant()) {
                valueNode2 = valueNode;
            }
            valueNode3 = valueNode;
        }
        if (((ResultColumn)valueNode2).getExpression() instanceof VirtualColumnNode) {
            valueNode = (VirtualColumnNode)((ResultColumn)valueNode2).getExpression();
            ResultSetNode resultSetNode = ((VirtualColumnNode)valueNode).getSourceResultSet();
            if (resultSetNode instanceof FromTable) {
                ResultColumn resultColumn;
                FromTable fromTable = (FromTable)resultSetNode;
                ResultColumnList resultColumnList = fromTable.getResultColumns();
                if (this.tableNumberBeforeFlattening == -1) {
                    this.tableNumberBeforeFlattening = this.tableNumber;
                    this.columnNumberBeforeFlattening = this.columnNumber;
                }
                if ((resultColumn = resultColumnList.getResultColumn(this.tableNumberBeforeFlattening, this.columnNumberBeforeFlattening, this._columnName)) == null) {
                    resultColumn = resultColumnList.getResultColumn(this._columnName);
                }
                this.tableNumber = fromTable.getTableNumber();
                this.columnNumber = resultColumn.getExpression() instanceof VirtualColumnNode ? resultColumn.getVirtualColumnId() : resultColumn.getColumnPosition();
            }
            this.source = ((ResultColumn)valueNode2).getExpression().getSourceResultColumn();
            return this;
        }
        return ((ResultColumn)valueNode2).getExpression().getClone();
    }

    void getTablesReferenced(JBitSet jBitSet) {
        if (jBitSet.size() < this.tableNumber) {
            jBitSet.grow(this.tableNumber);
        }
        if (this.tableNumber != -1) {
            jBitSet.set(this.tableNumber);
        }
    }

    @Override
    boolean isCloneable() {
        return true;
    }

    @Override
    boolean constantExpression(PredicateList predicateList) {
        return predicateList.constantColumn(this);
    }

    @Override
    void generateExpression(ExpressionClassBuilder expressionClassBuilder, MethodBuilder methodBuilder) throws StandardException {
        int n = this.source.getResultSetNumber();
        if (this.source.isRedundant()) {
            this.source.generateExpression(expressionClassBuilder, methodBuilder);
            return;
        }
        expressionClassBuilder.pushColumnReference(methodBuilder, n, this.source.getVirtualColumnId());
        methodBuilder.cast(this.getTypeCompiler().interfaceName());
    }

    @Override
    String getSchemaName() {
        return this._qualifiedTableName != null ? this._qualifiedTableName.getSchemaName() : null;
    }

    @Override
    protected int getOrderableVariantType() {
        return 1;
    }

    boolean pointsToColumnReference() {
        return this.source.getExpression() instanceof ColumnReference;
    }

    @Override
    DataTypeDescriptor getTypeServices() {
        if (this.source == null) {
            return super.getTypeServices();
        }
        return this.source.getTypeServices();
    }

    protected ResultSetNode getSourceResultSet(int[] nArray) throws StandardException {
        if (this.source == null) {
            return null;
        }
        ResultColumn resultColumn = this.getSource();
        ValueNode valueNode = resultColumn.getExpression();
        nArray[0] = this.getColumnNumber();
        while (valueNode != null && (resultColumn.isRedundant() || valueNode instanceof ColumnReference)) {
            if (valueNode instanceof ColumnReference) {
                nArray[0] = ((ColumnReference)valueNode).getColumnNumber();
                resultColumn = ((ColumnReference)valueNode).getSource();
            }
            while (resultColumn.isRedundant()) {
                valueNode = resultColumn.getExpression();
                if (valueNode instanceof VirtualColumnNode) {
                    resultColumn = valueNode.getSourceResultColumn();
                    continue;
                }
                if (!(valueNode instanceof ColumnReference)) break;
                nArray[0] = ((ColumnReference)valueNode).getColumnNumber();
                resultColumn = ((ColumnReference)valueNode).getSource();
            }
            valueNode = resultColumn.getExpression();
        }
        if (valueNode != null && valueNode instanceof VirtualColumnNode) {
            return ((VirtualColumnNode)valueNode).getSourceResultSet();
        }
        nArray[0] = -1;
        return null;
    }

    @Override
    boolean isEquivalent(ValueNode valueNode) throws StandardException {
        if (!this.isSameNodeKind(valueNode)) {
            return false;
        }
        ColumnReference columnReference = (ColumnReference)valueNode;
        return this.tableNumber == columnReference.tableNumber && this._columnName.equals(columnReference.getColumnName());
    }

    protected void markAsScoped() {
        this.scoped = true;
    }

    protected boolean isScoped() {
        return this.scoped;
    }

    void setMergeTableID(int n) {
        if (this._mergeTableID == 0 || this._mergeTableID != n) {
            // empty if block
        }
        this._mergeTableID = n;
    }

    private String prettyPrintMergeTableID(int n) {
        switch (n) {
            case 1: {
                return "SOURCE";
            }
            case 2: {
                return "TARGET";
            }
        }
        return "UNKNOWN";
    }

    int getMergeTableID() {
        return this._mergeTableID;
    }

    @Override
    void acceptChildren(Visitor visitor) throws StandardException {
        super.acceptChildren(visitor);
        if (this._qualifiedTableName != null) {
            this.setQualifiedTableName((TableName)this._qualifiedTableName.accept(visitor));
        }
    }

    private static class RemapInfo {
        int colNum;
        int tableNum;
        String colName;
        ResultColumn source;

        RemapInfo(int n, int n2, String string, ResultColumn resultColumn) {
            this.colNum = n;
            this.tableNum = n2;
            this.colName = string;
            this.source = resultColumn;
        }

        int getColumnNumber() {
            return this.colNum;
        }

        int getTableNumber() {
            return this.tableNum;
        }

        String getColumnName() {
            return this.colName;
        }

        ResultColumn getSource() {
            return this.source;
        }

        void setColNumber(int n) {
            this.colNum = n;
        }

        void setTableNumber(int n) {
            this.tableNum = n;
        }

        void setColName(String string) {
            this.colName = string;
        }

        void setSource(ResultColumn resultColumn) {
            this.source = resultColumn;
        }
    }
}

