/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import java.sql.Timestamp;
import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.depend.DependencyManager;
import org.apache.derby.iapi.sql.depend.Provider;
import org.apache.derby.iapi.sql.depend.ProviderInfo;
import org.apache.derby.iapi.sql.dictionary.DataDescriptorGenerator;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.SPSDescriptor;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.sql.dictionary.TriggerDescriptor;
import org.apache.derby.iapi.sql.dictionary.TriggerDescriptorList;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.impl.sql.execute.DDLSingleTableConstantAction;
import org.apache.derby.shared.common.error.StandardException;

class CreateTriggerConstantAction
extends DDLSingleTableConstantAction {
    private String triggerName;
    private String triggerSchemaName;
    private TableDescriptor triggerTable;
    private UUID triggerTableId;
    private int eventMask;
    private boolean isBefore;
    private boolean isRow;
    private boolean isEnabled;
    private boolean referencingOld;
    private boolean referencingNew;
    private UUID whenSPSId;
    private String whenText;
    private UUID actionSPSId;
    private String actionText;
    private final String originalWhenText;
    private String originalActionText;
    private String oldReferencingName;
    private String newReferencingName;
    private UUID spsCompSchemaId;
    private int[] referencedCols;
    private int[] referencedColsInTriggerAction;
    private final ProviderInfo[] providerInfo;

    CreateTriggerConstantAction(String string, String string2, int n, boolean bl, boolean bl2, boolean bl3, TableDescriptor tableDescriptor, UUID uUID, String string3, UUID uUID2, String string4, UUID uUID3, int[] nArray, int[] nArray2, String string5, String string6, boolean bl4, boolean bl5, String string7, String string8, ProviderInfo[] providerInfoArray) {
        super(tableDescriptor.getUUID());
        this.triggerName = string2;
        this.triggerSchemaName = string;
        this.triggerTable = tableDescriptor;
        this.eventMask = n;
        this.isBefore = bl;
        this.isRow = bl2;
        this.isEnabled = bl3;
        this.whenSPSId = uUID;
        this.whenText = string3;
        this.actionSPSId = uUID2;
        this.actionText = string4;
        this.spsCompSchemaId = uUID3;
        this.referencedCols = nArray;
        this.referencedColsInTriggerAction = nArray2;
        this.originalActionText = string6;
        this.originalWhenText = string5;
        this.referencingOld = bl4;
        this.referencingNew = bl5;
        this.oldReferencingName = string7;
        this.newReferencingName = string8;
        this.providerInfo = providerInfoArray;
    }

    @Override
    public void executeConstantAction(Activation activation) throws StandardException {
        Object object;
        SPSDescriptor sPSDescriptor = null;
        LanguageConnectionContext languageConnectionContext = activation.getLanguageConnectionContext();
        DataDictionary dataDictionary = languageConnectionContext.getDataDictionary();
        DependencyManager dependencyManager = dataDictionary.getDependencyManager();
        TransactionController transactionController = languageConnectionContext.getTransactionExecute();
        dataDictionary.startWriting(languageConnectionContext);
        SchemaDescriptor schemaDescriptor = CreateTriggerConstantAction.getSchemaDescriptorForCreate(dataDictionary, activation, this.triggerSchemaName);
        if (this.spsCompSchemaId == null) {
            object = languageConnectionContext.getDefaultSchema();
            if (((SchemaDescriptor)object).getUUID() == null) {
                object = dataDictionary.getSchemaDescriptor(((SchemaDescriptor)object).getDescriptorName(), transactionController, false);
            }
            if (object != null) {
                this.spsCompSchemaId = ((SchemaDescriptor)object).getUUID();
            }
        }
        if (this.triggerTable != null) {
            this.triggerTableId = this.triggerTable.getUUID();
            object = this.triggerTable.getName();
        } else {
            object = "with UUID " + this.triggerTableId;
        }
        this.triggerTable = dataDictionary.getTableDescriptor(this.triggerTableId);
        if (this.triggerTable == null) {
            throw StandardException.newException((String)"X0X05.S", (Object[])new Object[]{object});
        }
        this.lockTableForDDL(transactionController, this.triggerTable.getHeapConglomerateId(), true);
        this.triggerTable = dataDictionary.getTableDescriptor(this.triggerTableId);
        if (this.triggerTable == null) {
            throw StandardException.newException((String)"X0X05.S", (Object[])new Object[]{object});
        }
        dependencyManager.invalidateFor(this.triggerTable, 28, languageConnectionContext);
        UUID uUID = dataDictionary.getUUIDFactory().createUUID();
        UUID uUID2 = this.actionSPSId = this.actionSPSId == null ? dataDictionary.getUUIDFactory().createUUID() : this.actionSPSId;
        if (this.whenSPSId == null && this.whenText != null) {
            this.whenSPSId = dataDictionary.getUUIDFactory().createUUID();
        }
        DataDescriptorGenerator dataDescriptorGenerator = dataDictionary.getDataDescriptorGenerator();
        TriggerDescriptor triggerDescriptor = dataDescriptorGenerator.newTriggerDescriptor(schemaDescriptor, uUID, this.triggerName, this.eventMask, this.isBefore, this.isRow, this.isEnabled, this.triggerTable, this.whenSPSId, this.actionSPSId, this.makeCreationTimestamp(dataDictionary), this.referencedCols, this.referencedColsInTriggerAction, this.originalActionText, this.referencingOld, this.referencingNew, this.oldReferencingName, this.newReferencingName, this.originalWhenText);
        dataDictionary.addDescriptor(triggerDescriptor, schemaDescriptor, 13, false, transactionController);
        if (this.whenText != null) {
            String string = "VALUES " + this.whenText;
            sPSDescriptor = this.createSPS(languageConnectionContext, dataDescriptorGenerator, dataDictionary, transactionController, uUID, schemaDescriptor, this.whenSPSId, this.spsCompSchemaId, string, true, this.triggerTable);
        }
        SPSDescriptor sPSDescriptor2 = this.createSPS(languageConnectionContext, dataDescriptorGenerator, dataDictionary, transactionController, uUID, schemaDescriptor, this.actionSPSId, this.spsCompSchemaId, this.actionText, false, this.triggerTable);
        if (sPSDescriptor != null) {
            dependencyManager.addDependency(triggerDescriptor, sPSDescriptor, languageConnectionContext.getContextManager());
        }
        dependencyManager.addDependency(triggerDescriptor, sPSDescriptor2, languageConnectionContext.getContextManager());
        dependencyManager.addDependency(triggerDescriptor, this.triggerTable, languageConnectionContext.getContextManager());
        for (ProviderInfo providerInfo : this.providerInfo) {
            Provider provider = (Provider)providerInfo.getDependableFinder().getDependable(dataDictionary, providerInfo.getObjectId());
            dependencyManager.addDependency(triggerDescriptor, provider, languageConnectionContext.getContextManager());
        }
        this.storeViewTriggerDependenciesOnPrivileges(activation, triggerDescriptor);
    }

    private SPSDescriptor createSPS(LanguageConnectionContext languageConnectionContext, DataDescriptorGenerator dataDescriptorGenerator, DataDictionary dataDictionary, TransactionController transactionController, UUID uUID, SchemaDescriptor schemaDescriptor, UUID uUID2, UUID uUID3, String string, boolean bl, TableDescriptor tableDescriptor) throws StandardException {
        if (string == null) {
            return null;
        }
        String string2 = "TRIGGER" + (bl ? "WHEN_" : "ACTN_") + uUID + "_" + tableDescriptor.getUUID().toString();
        SPSDescriptor sPSDescriptor = new SPSDescriptor(dataDictionary, string2, uUID2 == null ? dataDictionary.getUUIDFactory().createUUID() : uUID2, schemaDescriptor.getUUID(), uUID3 == null ? languageConnectionContext.getDefaultSchema().getUUID() : uUID3, 'T', true, string, true);
        sPSDescriptor.prepareAndRelease(languageConnectionContext, tableDescriptor);
        dataDictionary.addSPSDescriptor(sPSDescriptor, transactionController);
        return sPSDescriptor;
    }

    public String toString() {
        return this.constructToString("CREATE TRIGGER ", this.triggerName);
    }

    private Timestamp makeCreationTimestamp(DataDictionary dataDictionary) throws StandardException {
        Timestamp timestamp = new Timestamp(System.currentTimeMillis());
        TriggerDescriptorList triggerDescriptorList = dataDictionary.getTriggerDescriptors(this.triggerTable);
        int n = triggerDescriptorList.size();
        if (n == 0) {
            return timestamp;
        }
        Timestamp timestamp2 = ((TriggerDescriptor)triggerDescriptorList.get(n - 1)).getCreationTimestamp();
        if (timestamp.after(timestamp2)) {
            return timestamp;
        }
        timestamp.setTime(timestamp2.getTime() + 1L);
        return timestamp;
    }
}

