/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.converter;

import java.util.EnumSet;
import java.util.Set;
import org.apache.sis.converter.SystemConverter;
import org.apache.sis.converter.SystemRegistry;
import org.apache.sis.math.FunctionProperty;
import org.apache.sis.util.Numbers;
import org.apache.sis.util.ObjectConverter;
import org.apache.sis.util.UnconvertibleObjectException;
import org.apache.sis.util.resources.Errors;

final class NumberConverter<S extends Number, T extends Number>
extends SystemConverter<S, T> {
    private static final long serialVersionUID = 3339549290992876106L;
    private volatile transient ObjectConverter<T, S> inverse;

    NumberConverter(Class<S> sourceClass, Class<T> targetClass) {
        super(sourceClass, targetClass);
    }

    @Override
    public ObjectConverter<T, S> inverse() throws UnsupportedOperationException {
        ObjectConverter<Object, Object> candidate = this.inverse;
        if (candidate == null) {
            try {
                this.inverse = candidate = SystemRegistry.INSTANCE.findExact(this.targetClass, this.sourceClass);
            }
            catch (UnconvertibleObjectException e) {
                throw new UnsupportedOperationException(Errors.format((short)129), e);
            }
        }
        return candidate;
    }

    @Override
    public Set<FunctionProperty> properties() {
        return EnumSet.of(Numbers.widestClass(this.sourceClass, this.targetClass) == this.targetClass ? FunctionProperty.INJECTIVE : FunctionProperty.SURJECTIVE, FunctionProperty.ORDER_PRESERVING, FunctionProperty.INVERTIBLE);
    }

    @Override
    public T apply(S source) {
        double delta;
        Object target;
        double sourceValue = ((Number)source).doubleValue();
        try {
            target = Numbers.cast(source, this.targetClass);
        }
        catch (IllegalArgumentException e) {
            throw new UnconvertibleObjectException(this.formatErrorMessage(source), e);
        }
        double targetValue = ((Number)target).doubleValue();
        if (Double.doubleToLongBits(targetValue) != Double.doubleToLongBits(sourceValue) && !((delta = Math.abs(targetValue - sourceValue)) < 0.5)) {
            if (delta < 1.0) {
                target = Numbers.cast(Math.round(sourceValue), this.targetClass);
            } else {
                throw new UnconvertibleObjectException(this.formatErrorMessage(source));
            }
        }
        return (T)target;
    }

    static final class Comparable<S extends Number>
    extends SystemConverter<S, java.lang.Comparable<?>> {
        private static final long serialVersionUID = -6366381413315460619L;

        Comparable(Class<S> sourceClass) {
            super(sourceClass, java.lang.Comparable.class);
        }

        @Override
        public Set<FunctionProperty> properties() {
            if (this.targetClass.isAssignableFrom(this.sourceClass)) {
                return Comparable.bijective();
            }
            return EnumSet.noneOf(FunctionProperty.class);
        }

        @Override
        public java.lang.Comparable<?> apply(Number source) {
            if (source == null || source instanceof java.lang.Comparable) {
                return (java.lang.Comparable)((Object)source);
            }
            return (java.lang.Comparable)((Object)Numbers.narrowestNumber(source));
        }
    }
}

