/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.pending.jdk;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;

public final class JDK21 {
    private JDK21() {
    }

    public static <E> E getFirst(List<E> sequenced) {
        try {
            return sequenced.get(0);
        }
        catch (IndexOutOfBoundsException e) {
            throw new NoSuchElementException();
        }
    }

    public static <E> E getLast(List<E> sequenced) {
        try {
            return sequenced.get(sequenced.size() - 1);
        }
        catch (IndexOutOfBoundsException e) {
            throw new NoSuchElementException();
        }
    }

    public static <K, V> void putFirst(LinkedHashMap<K, V> sequenced, K key, V value) {
        LinkedHashMap copy = (LinkedHashMap)sequenced.clone();
        sequenced.clear();
        sequenced.put(key, value);
        sequenced.putAll(copy);
    }

    public static <E> Iterable<E> reversed(Collection<E> sequenced) {
        ArrayList list = sequenced instanceof List ? (ArrayList)sequenced : new ArrayList(sequenced);
        return () -> {
            final ListIterator it = list.listIterator(list.size());
            return new Iterator<E>(){

                @Override
                public boolean hasNext() {
                    return it.hasPrevious();
                }

                @Override
                public E next() {
                    return it.previous();
                }
            };
        };
    }

    public static void repeat(StringBuilder buffer, char c, int count) {
        while (--count >= 0) {
            buffer.append(c);
        }
    }
}

