/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.style.se1;

import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlElements;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import java.util.ArrayList;
import java.util.List;
import org.apache.sis.filter.Expression;
import org.apache.sis.style.se1.AnchorPoint;
import org.apache.sis.style.se1.Displacement;
import org.apache.sis.style.se1.ExternalGraphic;
import org.apache.sis.style.se1.GraphicalSymbol;
import org.apache.sis.style.se1.Mark;
import org.apache.sis.style.se1.StyleElement;
import org.apache.sis.style.se1.StyleFactory;
import org.apache.sis.style.se1.Translucent;

@XmlType(name="GraphicType", propOrder={"graphicalSymbols", "opacity", "size", "rotation", "anchorPoint", "displacement"})
@XmlRootElement(name="Graphic")
public class Graphic<R>
extends StyleElement<R>
implements Translucent<R> {
    @XmlElements(value={@XmlElement(name="Mark", type=Mark.class), @XmlElement(name="ExternalGraphic", type=ExternalGraphic.class)})
    private List<GraphicalSymbol<R>> graphicalSymbols;
    @XmlElement(name="Opacity")
    protected Expression<R, ? extends Number> opacity;
    @XmlElement(name="Size")
    protected Expression<R, ? extends Number> size;
    @XmlElement(name="Rotation")
    protected Expression<R, ? extends Number> rotation;
    @XmlElement(name="AnchorPoint")
    protected AnchorPoint<R> anchorPoint;
    @XmlElement(name="Displacement")
    protected Displacement<R> displacement;

    private Graphic() {
    }

    public Graphic(StyleFactory<R> factory) {
        super(factory);
        this.graphicalSymbols = new ArrayList<GraphicalSymbol<R>>();
    }

    public Graphic(Graphic<R> source) {
        super(source);
        this.graphicalSymbols = new ArrayList<GraphicalSymbol<R>>(source.graphicalSymbols);
        this.opacity = source.opacity;
        this.size = source.size;
        this.rotation = source.rotation;
        this.anchorPoint = source.anchorPoint;
        this.displacement = source.displacement;
    }

    public List<GraphicalSymbol<R>> graphicalSymbols() {
        return this.graphicalSymbols;
    }

    @Override
    public Expression<R, ? extends Number> getOpacity() {
        return this.defaultToOne(this.opacity);
    }

    @Override
    public void setOpacity(Expression<R, ? extends Number> value) {
        this.opacity = value;
    }

    public Expression<R, ? extends Number> getSize() {
        Expression<R, ? extends Number> value = this.size;
        if (value == null && this.graphicalSymbols.isEmpty()) {
            return this.factory.six;
        }
        return value;
    }

    public void setSize(Expression<R, ? extends Number> value) {
        this.size = value;
    }

    public Expression<R, ? extends Number> getRotation() {
        return this.defaultToZero(this.rotation);
    }

    public void setRotation(Expression<R, ? extends Number> value) {
        this.rotation = value;
    }

    public AnchorPoint<R> getAnchorPoint() {
        if (this.anchorPoint == null) {
            this.anchorPoint = this.factory.createAnchorPoint();
        }
        return this.anchorPoint;
    }

    public void setAnchorPoint(AnchorPoint<R> value) {
        this.anchorPoint = value;
    }

    public Displacement<R> getDisplacement() {
        if (this.displacement == null) {
            this.displacement = this.factory.createDisplacement();
        }
        return this.displacement;
    }

    public void setDisplacement(Displacement<R> value) {
        this.displacement = value;
    }

    @Override
    final Object[] properties() {
        return new Object[]{this.graphicalSymbols, this.opacity, this.size, this.rotation, this.anchorPoint, this.displacement};
    }

    @Override
    public Graphic<R> clone() {
        Graphic clone = (Graphic)super.clone();
        clone.selfClone();
        return clone;
    }

    private void selfClone() {
        this.graphicalSymbols = new ArrayList<GraphicalSymbol<R>>(this.graphicalSymbols);
        this.graphicalSymbols.replaceAll(GraphicalSymbol::clone);
        if (this.anchorPoint != null) {
            this.anchorPoint = this.anchorPoint.clone();
        }
        if (this.displacement != null) {
            this.displacement = this.displacement.clone();
        }
    }
}

