/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.style.se1;

import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import java.awt.Color;
import java.util.Optional;
import org.apache.sis.filter.Expression;
import org.apache.sis.style.se1.GraphicFill;
import org.apache.sis.style.se1.GraphicStroke;
import org.apache.sis.style.se1.StyleElement;
import org.apache.sis.style.se1.StyleFactory;
import org.apache.sis.style.se1.Translucent;

@XmlType(name="StrokeType", propOrder={"graphicFill", "graphicStroke"})
@XmlRootElement(name="Stroke")
public class Stroke<R>
extends StyleElement<R>
implements Translucent<R> {
    @XmlElement(name="GraphicFill")
    protected GraphicFill<R> graphicFill;
    @XmlElement(name="GraphicStroke")
    protected GraphicStroke<R> graphicStroke;
    protected Expression<R, Color> color;
    protected Expression<R, ? extends Number> opacity;
    protected Expression<R, ? extends Number> width;
    protected Expression<R, String> lineJoin;
    protected Expression<R, String> lineCap;
    protected Expression<R, float[]> dashArray;
    protected Expression<R, Integer> dashOffset;

    private Stroke() {
    }

    public Stroke(StyleFactory<R> factory) {
        super(factory);
    }

    public Stroke(Stroke<R> source) {
        super(source);
        this.graphicFill = source.graphicFill;
        this.graphicStroke = source.graphicStroke;
        this.color = source.color;
        this.opacity = source.opacity;
        this.width = source.width;
        this.lineJoin = source.lineJoin;
        this.lineCap = source.lineCap;
        this.dashArray = source.dashArray;
        this.dashOffset = source.dashOffset;
    }

    public Optional<GraphicFill<R>> getGraphicFill() {
        return Optional.ofNullable(this.graphicFill);
    }

    public void setGraphicFill(GraphicFill<R> value) {
        this.graphicFill = value;
        if (value != null) {
            this.graphicStroke = null;
        }
    }

    public Optional<GraphicStroke<R>> getGraphicStroke() {
        return Optional.ofNullable(this.graphicStroke);
    }

    public void setGraphicStroke(GraphicStroke<R> value) {
        this.graphicStroke = value;
        if (value != null) {
            this.graphicFill = null;
        }
    }

    public Expression<R, Color> getColor() {
        Expression<R, Color> value = this.color;
        return value != null ? value : this.factory.black;
    }

    public void setColor(Expression<R, Color> value) {
        this.color = value;
        if (value != null) {
            this.graphicFill = null;
            this.graphicStroke = null;
        }
    }

    public void setColorAndOpacity(Color value) {
        if (value == null) {
            this.color = null;
            this.opacity = null;
        } else {
            this.opacity = this.opacity(value);
            if (this.opacity != null) {
                value = new Color(value.getRGB() | 0xFF000000);
            }
            this.color = this.literal(value);
        }
    }

    @Override
    public Expression<R, ? extends Number> getOpacity() {
        return this.defaultToOne(this.opacity);
    }

    @Override
    public void setOpacity(Expression<R, ? extends Number> value) {
        this.opacity = value;
    }

    public Expression<R, ? extends Number> getWidth() {
        return this.defaultToOne(this.width);
    }

    public void setWidth(Expression<R, ? extends Number> value) {
        this.width = value;
    }

    public Expression<R, String> getLineJoin() {
        Expression<R, String> value = this.lineJoin;
        return value != null ? value : this.factory.bevel;
    }

    public void setLineJoin(Expression<R, String> value) {
        this.lineJoin = value;
    }

    public Expression<R, String> getLineCap() {
        Expression<R, String> value = this.lineCap;
        return value != null ? value : this.factory.square;
    }

    public void setLineCap(Expression<R, String> value) {
        this.lineCap = value;
    }

    public Optional<Expression<R, float[]>> getDashArray() {
        return Optional.ofNullable(this.dashArray);
    }

    public void setDashArray(Expression<R, float[]> value) {
        this.dashArray = value;
    }

    public Expression<R, Integer> getDashOffset() {
        Expression<R, Integer> value = this.dashOffset;
        return value != null ? value : this.factory.zeroAsInt;
    }

    public void setDashOffset(Expression<R, Integer> value) {
        this.dashOffset = value;
    }

    @Override
    final Object[] properties() {
        return new Object[]{this.graphicFill, this.graphicStroke, this.color, this.opacity, this.width, this.lineJoin, this.lineCap, this.dashArray, this.dashOffset};
    }

    @Override
    public Stroke<R> clone() {
        Stroke clone = (Stroke)super.clone();
        clone.selfClone();
        return clone;
    }

    private void selfClone() {
        if (this.graphicFill != null) {
            this.graphicFill = this.graphicFill.clone();
        }
        if (this.graphicStroke != null) {
            this.graphicStroke = this.graphicStroke.clone();
        }
    }
}

