/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.io.stream;

import java.io.BufferedReader;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.channels.Channel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SeekableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.spi.FileSystemProvider;
import java.util.Locale;
import javax.imageio.stream.ImageInputStream;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamReader;
import org.apache.sis.io.stream.ChannelData;
import org.apache.sis.io.stream.ChannelDataOutput;
import org.apache.sis.io.stream.ChannelImageInputStream;
import org.apache.sis.io.stream.OutputStreamAdapter;
import org.apache.sis.pending.jdk.JDK20;
import org.apache.sis.storage.internal.InputStreamAdapter;
import org.apache.sis.storage.internal.Resources;
import org.apache.sis.util.CharSequences;

public final class IOUtilities {
    public static final String CURRENT_DIRECTORY_SYMBOL = ".";
    public static final char URI_PATH_SEPARATOR = '/';
    public static final char EXTENSION_SEPARATOR = '.';

    private IOUtilities() {
    }

    public static boolean isKindOfPath(Object path) {
        return path instanceof URI || path instanceof URL || path instanceof Path || path instanceof File || path instanceof CharSequence;
    }

    public static String filename(Object path) {
        return IOUtilities.part(path, false);
    }

    public static String extension(Object path) {
        return IOUtilities.part(path, true);
    }

    private static String part(Object path, boolean extension) {
        int end;
        String name;
        int fromIndex = 0;
        if (path instanceof File) {
            name = ((File)path).getName();
            end = name.length();
        } else if (path instanceof Path) {
            Path tip = ((Path)path).getFileName();
            if (tip == null) {
                return null;
            }
            name = tip.toString();
            end = name.length();
        } else {
            int separator = 47;
            if (path instanceof URL) {
                name = ((URL)path).getPath();
            } else if (path instanceof URI) {
                URI uri = (URI)path;
                name = uri.isOpaque() ? uri.getSchemeSpecificPart() : uri.getPath();
            } else if (path instanceof CharSequence) {
                name = path.toString();
                separator = File.separatorChar;
            } else {
                return null;
            }
            end = name.length();
            do {
                if (--end < 0) {
                    return "";
                }
                fromIndex = name.lastIndexOf(47, end);
                if (separator == 47) continue;
                fromIndex = Math.max(fromIndex, name.lastIndexOf(separator, end));
            } while (fromIndex == end);
            ++fromIndex;
            ++end;
        }
        if (extension && (fromIndex = CharSequences.lastIndexOf((CharSequence)name, (int)46, (int)fromIndex, (int)end) + 1) <= 1) {
            return "";
        }
        return name.substring(fromIndex, end);
    }

    public static String toString(Object path) {
        if (path instanceof CharSequence || path instanceof Path || path instanceof URL || path instanceof URI) {
            return path.toString();
        }
        if (path instanceof File) {
            return ((File)path).getPath();
        }
        return null;
    }

    public static URI toURI(Object path) throws URISyntaxException {
        if (path instanceof URI) {
            return (URI)path;
        }
        if (path instanceof URL) {
            return ((URL)path).toURI();
        }
        if (path instanceof File) {
            return ((File)path).toURI();
        }
        if (path instanceof Path) {
            return ((Path)path).toUri();
        }
        if (path instanceof CharSequence) {
            return new URI(path.toString());
        }
        return null;
    }

    public static URI toAuxiliaryURI(URI location, String replacement, boolean extension) throws URISyntaxException {
        if (location == null || !location.isAbsolute() || location.isOpaque()) {
            return null;
        }
        Object path = location.getRawPath();
        int s = ((String)path).indexOf(63);
        if (s < 0 && (s = ((String)path).indexOf(35)) < 0) {
            s = ((String)path).length();
        }
        int base = ((String)path).lastIndexOf(47, s);
        s = extension ? ((String)path).lastIndexOf(46, s) : base;
        path = !extension || s > base ? ((String)path).substring(0, s + 1) + replacement : (String)path + CURRENT_DIRECTORY_SYMBOL + replacement;
        return new URI(location.getScheme(), location.getRawAuthority(), (String)path, null, null);
    }

    public static String filenameWithoutExtension(String path) {
        if (path != null) {
            int e;
            int s = path.lastIndexOf(File.separatorChar);
            if (s < 0 && File.separatorChar != '/') {
                s = path.lastIndexOf(47);
            }
            if ((e = path.lastIndexOf(46)) <= ++s) {
                e = path.length();
            }
            path = path.substring(s, e);
        }
        return path;
    }

    public static String encodeURI(String path) {
        if (path == null) {
            return null;
        }
        StringBuilder buffer = null;
        int length = path.length();
        int i = 0;
        while (i < length) {
            int c = path.codePointAt(i);
            int e = Character.charCount(c) + i;
            if (Character.isSpaceChar(c) || Character.isISOControl(c) || c == 37 || c == 92) {
                if (buffer == null) {
                    buffer = new StringBuilder(path);
                    buffer.setLength(i);
                }
                for (byte b : path.substring(i, e).getBytes(StandardCharsets.UTF_8)) {
                    buffer.append('%');
                    String hex = Integer.toHexString(Byte.toUnsignedInt(b)).toUpperCase(Locale.ROOT);
                    if (hex.length() < 2) {
                        buffer.append('0');
                    }
                    buffer.append(hex);
                }
            } else if (buffer != null) {
                buffer.appendCodePoint(c);
            }
            i = e;
        }
        return buffer != null ? buffer.toString() : path;
    }

    /*
     * Exception decompiling
     */
    public static Object toFileOrURL(String path, String encoding) throws UnsupportedEncodingException, MalformedURLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static Path toPathOrNull(Object path) {
        if (path instanceof Path) {
            return (Path)path;
        }
        if (path instanceof File) {
            return ((File)path).toPath();
        }
        if (path instanceof URI) {
            return Path.of((URI)path);
        }
        if (path instanceof CharSequence) {
            return Path.of(path.toString(), new String[0]);
        }
        return null;
    }

    public static BufferedReader toBuffered(Reader reader) {
        if (reader instanceof BufferedReader) {
            return (BufferedReader)reader;
        }
        return new LineNumberReader(reader);
    }

    public static InputStream toInputStream(AutoCloseable stream) throws IOException {
        ImageInputStream input;
        if (stream instanceof InputStream) {
            return (InputStream)stream;
        }
        if (stream instanceof ImageInputStream) {
            input = (ImageInputStream)stream;
        } else {
            ChannelData output;
            if (stream instanceof ChannelData) {
                output = (ChannelData)((Object)stream);
            } else if (stream instanceof OutputStreamAdapter) {
                output = ((OutputStreamAdapter)stream).output;
            } else {
                return null;
            }
            Channel channel = output.channel();
            if (!(channel instanceof ReadableByteChannel)) {
                return null;
            }
            input = new ChannelImageInputStream(output.filename, (ReadableByteChannel)channel, output.buffer, true);
        }
        return new InputStreamAdapter(input);
    }

    public static OutputStream toOutputStream(AutoCloseable stream) throws IOException {
        block5: {
            ChannelDataOutput output;
            block7: {
                ChannelData data;
                block6: {
                    if (stream instanceof OutputStream) {
                        return (OutputStream)stream;
                    }
                    if (stream instanceof InputStreamAdapter) {
                        stream = ((InputStreamAdapter)stream).input;
                    }
                    if (!(stream instanceof ChannelData)) break block5;
                    data = (ChannelData)((Object)stream);
                    if (!(stream instanceof ChannelDataOutput)) break block6;
                    output = (ChannelDataOutput)((Object)stream);
                    break block7;
                }
                Channel channel = data.channel();
                if (!(channel instanceof WritableByteChannel)) break block5;
                output = new ChannelDataOutput(data.filename, (WritableByteChannel)channel, data.buffer);
            }
            return new OutputStreamAdapter(output);
        }
        return null;
    }

    public static boolean truncate(AutoCloseable stream) throws IOException {
        if (stream instanceof OutputStreamAdapter) {
            stream = ((OutputStreamAdapter)stream).output.channel();
        } else if (stream instanceof ChannelData) {
            stream = ((ChannelData)((Object)stream)).channel();
        }
        if (stream instanceof SeekableByteChannel) {
            SeekableByteChannel s = (SeekableByteChannel)stream;
            s.truncate(s.position());
            return true;
        }
        return false;
    }

    public static boolean isAbsentOrEmpty(Path path) throws IOException {
        BasicFileAttributes attributes = JDK20.readAttributesIfExists((FileSystemProvider)path.getFileSystem().provider(), (Path)path, BasicFileAttributes.class, (LinkOption[])new LinkOption[0]);
        return attributes == null || attributes.isRegularFile() && attributes.size() == 0L;
    }

    public static boolean isWriteOnly(Object output) {
        if (output instanceof DataInput || output instanceof ReadableByteChannel) {
            return false;
        }
        return output instanceof OutputStream || output instanceof DataOutput || output instanceof ChannelDataOutput || output instanceof WritableByteChannel;
    }

    public static boolean isWrite(OpenOption[] options) {
        boolean isRead = false;
        boolean isWrite = false;
        boolean truncate = false;
        if (options != null) {
            block5: for (OpenOption op : options) {
                if (!(op instanceof StandardOpenOption)) continue;
                switch ((StandardOpenOption)op) {
                    case READ: {
                        isRead = true;
                        continue block5;
                    }
                    case WRITE: {
                        isWrite = true;
                        continue block5;
                    }
                    case CREATE_NEW: 
                    case TRUNCATE_EXISTING: {
                        truncate = true;
                    }
                }
            }
        }
        return isWrite & (!isRead | truncate);
    }

    public static boolean isHTTP(String protocol) {
        return "http".equalsIgnoreCase(protocol) || "https".equalsIgnoreCase(protocol);
    }

    public static int readCodePoint(Reader in) throws IOException {
        int c = in.read();
        while (c >= 55296 && c <= 56319) {
            int low = in.read();
            if (low >= 56320 && low <= 57343) {
                c = Character.toCodePoint((char)c, (char)low);
                break;
            }
            c = low;
        }
        return c;
    }

    public static String canNotReadFile(Locale locale, String format, String filename, Object store) {
        Object[] parameters = IOUtilities.errorMessageParameters(format, filename, store);
        return Resources.forLocale(locale).getString(IOUtilities.errorMessageKey(parameters), parameters);
    }

    public static short errorMessageKey(Object[] parameters) {
        return (short)(parameters.length == 2 ? 1 : (parameters.length == 3 ? 2 : 3));
    }

    public static Object[] errorMessageParameters(String format, String filename, Object store) {
        int line = 0;
        int column = 0;
        if (store instanceof XMLStreamReader) {
            Location location = ((XMLStreamReader)store).getLocation();
            line = location.getLineNumber() + 1;
            column = location.getColumnNumber() + 1;
        } else if (store instanceof LineNumberReader) {
            line = ((LineNumberReader)store).getLineNumber();
        }
        Object[] params = new Object[line == 0 ? 2 : (column == 0 ? 3 : 4)];
        switch (params.length) {
            default: {
                params[3] = column;
            }
            case 3: {
                params[2] = line;
            }
            case 2: {
                params[1] = filename;
            }
            case 1: {
                params[0] = format;
            }
            case 0: 
        }
        return params;
    }
}

