/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.base;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.util.Arrays;
import javax.xml.transform.Source;
import org.apache.sis.io.stream.IOUtilities;
import org.apache.sis.util.ArraysExt;

public final class AuxiliaryContent
implements CharSequence {
    static final int BUFFER_SIZE = 1024;
    private static final int MAXIMAL_LENGTH = 65536;
    public final Source source;
    private final Object location;
    private final char[] buffer;
    private final int offset;
    private final int length;

    AuxiliaryContent(Object location, Source source) {
        this.source = source;
        this.location = location;
        this.buffer = ArraysExt.EMPTY_CHAR;
        this.offset = 0;
        this.length = 0;
    }

    private AuxiliaryContent(Object location, char[] buffer, int offset, int length) {
        this.source = null;
        this.location = location;
        this.buffer = buffer;
        this.offset = offset;
        this.length = length;
    }

    static AuxiliaryContent read(Object location, InputStream stream, Charset encoding) throws IOException {
        try (InputStreamReader reader = encoding != null ? new InputStreamReader(stream, encoding) : new InputStreamReader(stream);){
            int count;
            char[] buffer = new char[1024];
            int offset = 0;
            while ((count = reader.read(buffer, offset, buffer.length - offset)) >= 0) {
                if ((offset += count) < buffer.length) continue;
                if (offset >= 65536) {
                    AuxiliaryContent auxiliaryContent = null;
                    return auxiliaryContent;
                }
                buffer = Arrays.copyOf(buffer, offset * 2);
            }
            AuxiliaryContent auxiliaryContent = new AuxiliaryContent(location, buffer, 0, offset);
            return auxiliaryContent;
        }
    }

    public String getFilename() {
        return IOUtilities.filename(this.location);
    }

    public URI getURI() throws URISyntaxException {
        return IOUtilities.toURI(this.location);
    }

    @Override
    public int length() {
        return this.length;
    }

    @Override
    public char charAt(int index) {
        return this.buffer[this.offset + index];
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return new AuxiliaryContent(this.location, this.buffer, this.offset + start, end - start);
    }

    @Override
    public String toString() {
        return new String(this.buffer, this.offset, this.length);
    }
}

