/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing;

import java.util.AbstractSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Logger;
import org.apache.sis.referencing.AuthorityFactories;
import org.apache.sis.referencing.CRS;
import org.apache.sis.referencing.factory.GeodeticObjectFactory;
import org.apache.sis.referencing.factory.MultiAuthoritiesFactory;
import org.apache.sis.referencing.factory.NoSuchAuthorityFactoryException;
import org.apache.sis.referencing.operation.DefaultCoordinateOperationFactory;
import org.apache.sis.referencing.operation.transform.DefaultMathTransformFactory;
import org.apache.sis.util.iso.AbstractFactory;
import org.apache.sis.util.logging.Logging;
import org.apache.sis.util.resources.Errors;
import org.opengis.metadata.extent.GeographicBoundingBox;
import org.opengis.referencing.AuthorityFactory;
import org.opengis.referencing.crs.CRSAuthorityFactory;
import org.opengis.referencing.crs.CRSFactory;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.cs.CSAuthorityFactory;
import org.opengis.referencing.cs.CSFactory;
import org.opengis.referencing.datum.DatumAuthorityFactory;
import org.opengis.referencing.datum.DatumFactory;
import org.opengis.referencing.operation.CoordinateOperation;
import org.opengis.referencing.operation.CoordinateOperationAuthorityFactory;
import org.opengis.referencing.operation.CoordinateOperationFactory;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.util.Factory;
import org.opengis.util.FactoryException;

public class MultiRegisterOperations
extends AbstractFactory {
    private static final Map<Class<?>, Boolean> FACTORY_TYPES = Map.of(CoordinateOperationAuthorityFactory.class, Boolean.TRUE, DatumAuthorityFactory.class, Boolean.TRUE, CRSAuthorityFactory.class, Boolean.TRUE, CSAuthorityFactory.class, Boolean.TRUE, DatumFactory.class, Boolean.FALSE, CRSFactory.class, Boolean.FALSE, CSFactory.class, Boolean.FALSE);
    private final String authority;
    private final String version;
    private final GeographicBoundingBox areaOfInterest;
    private final CRSAuthorityFactory crsFactory;
    private static final MultiRegisterOperations DEFAULT = new MultiRegisterOperations();

    public static MultiRegisterOperations provider() {
        return DEFAULT;
    }

    private MultiRegisterOperations() {
        this.authority = null;
        this.version = null;
        this.crsFactory = null;
        this.areaOfInterest = null;
    }

    protected MultiRegisterOperations(MultiRegisterOperations source, GeographicBoundingBox areaOfInterest) {
        this.authority = source.authority;
        this.version = source.version;
        this.crsFactory = source.crsFactory;
        this.areaOfInterest = areaOfInterest;
    }

    protected MultiRegisterOperations(MultiRegisterOperations source, String authority, String version) throws FactoryException {
        this.authority = Objects.requireNonNull(authority);
        this.version = version;
        this.areaOfInterest = source.areaOfInterest;
        this.crsFactory = AuthorityFactories.ALL.getAuthorityFactory(CRSAuthorityFactory.class, authority, version);
    }

    public MultiRegisterOperations withAuthority(String newValue) throws FactoryException {
        if (this.version == null && Objects.equals(this.authority, newValue)) {
            return this;
        }
        if (newValue == null) {
            return DEFAULT.withAreaOfInterest(this.areaOfInterest);
        }
        return new MultiRegisterOperations(this, newValue, null);
    }

    public MultiRegisterOperations withVersion(String newValue) throws FactoryException {
        if (Objects.equals(this.version, newValue)) {
            return this;
        }
        if (newValue == null && this.authority == null) {
            return DEFAULT.withAreaOfInterest(this.areaOfInterest);
        }
        if (this.authority != null) {
            return new MultiRegisterOperations(this, this.authority, newValue);
        }
        throw new IllegalStateException(Errors.format((short)111, (Object)"authority"));
    }

    public MultiRegisterOperations withAreaOfInterest(GeographicBoundingBox newValue) {
        if (Objects.equals(this.areaOfInterest, newValue)) {
            return this;
        }
        if (newValue == null && this.authority == null && this.version == null) {
            return DEFAULT;
        }
        return new MultiRegisterOperations(this, newValue);
    }

    public CoordinateReferenceSystem findCoordinateReferenceSystem(String code) throws FactoryException {
        if (this.crsFactory != null) {
            return this.crsFactory.createCoordinateReferenceSystem(code);
        }
        return CRS.forCode(code);
    }

    public CoordinateOperation findCoordinateOperation(String code) throws FactoryException {
        if (this.crsFactory instanceof CoordinateOperationAuthorityFactory) {
            ((CoordinateOperationAuthorityFactory)this.crsFactory).createCoordinateOperation(code);
        }
        return AuthorityFactories.ALL.createCoordinateOperation(code);
    }

    public Set<CoordinateOperation> findCoordinateOperations(CoordinateReferenceSystem source, CoordinateReferenceSystem target) throws FactoryException {
        final List<CoordinateOperation> operations = CRS.findOperations(source, target, this.areaOfInterest);
        return new AbstractSet<CoordinateOperation>(this){
            final /* synthetic */ MultiRegisterOperations this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public Iterator<CoordinateOperation> iterator() {
                return operations.iterator();
            }

            @Override
            public boolean isEmpty() {
                return operations.isEmpty();
            }

            @Override
            public int size() {
                return operations.size();
            }
        };
    }

    public <T extends Factory> Optional<T> getFactory(Class<? extends T> type) throws FactoryException {
        AbstractFactory factory;
        Boolean b = FACTORY_TYPES.get(type);
        if (b != null) {
            if (b.booleanValue()) {
                MultiAuthoritiesFactory mf = AuthorityFactories.ALL;
                if (this.authority == null) {
                    factory = mf;
                } else {
                    try {
                        factory = mf.getAuthorityFactory(type.asSubclass(AuthorityFactory.class), this.authority, this.version);
                    }
                    catch (NoSuchAuthorityFactoryException e) {
                        Logging.recoverableException((Logger)AuthorityFactories.LOGGER, MultiRegisterOperations.class, (String)"getFactory", (Throwable)((Object)e));
                        return Optional.empty();
                    }
                }
            } else {
                factory = GeodeticObjectFactory.provider();
            }
        } else if (type == CoordinateOperationFactory.class) {
            factory = DefaultCoordinateOperationFactory.provider();
        } else if (type == MathTransformFactory.class) {
            factory = DefaultMathTransformFactory.provider();
        } else {
            throw new IllegalArgumentException(Errors.format((short)59, (Object)"type", type));
        }
        return Optional.of((Factory)type.cast(factory));
    }
}

