/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.crs;

import jakarta.xml.bind.annotation.XmlTransient;
import java.util.Map;
import org.apache.sis.io.wkt.Formatter;
import org.apache.sis.referencing.crs.AbstractCRS;
import org.apache.sis.referencing.crs.DefaultGeodeticCRS;
import org.apache.sis.referencing.cs.AbstractCS;
import org.apache.sis.referencing.cs.AxesConvention;
import org.apache.sis.referencing.datum.DefaultDatumEnsemble;
import org.apache.sis.util.ArgumentChecks;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.referencing.crs.GeocentricCRS;
import org.opengis.referencing.crs.GeodeticCRS;
import org.opengis.referencing.cs.CartesianCS;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.SphericalCS;
import org.opengis.referencing.datum.GeodeticDatum;

@XmlTransient
public class DefaultGeocentricCRS
extends DefaultGeodeticCRS
implements GeocentricCRS {
    private static final long serialVersionUID = 6784642848287659827L;

    public DefaultGeocentricCRS(Map<String, ?> properties, GeodeticDatum datum, DefaultDatumEnsemble<GeodeticDatum> ensemble, CartesianCS cs) {
        super(properties, datum, ensemble, (CoordinateSystem)cs);
        DefaultGeocentricCRS.checkDimension(3, 3, (CoordinateSystem)cs);
    }

    public DefaultGeocentricCRS(Map<String, ?> properties, GeodeticDatum datum, DefaultDatumEnsemble<GeodeticDatum> ensemble, SphericalCS cs) {
        super(properties, datum, ensemble, (CoordinateSystem)cs);
        DefaultGeocentricCRS.checkDimension(2, 3, (CoordinateSystem)cs);
    }

    @Deprecated(since="1.5", forRemoval=true)
    public DefaultGeocentricCRS(Map<String, ?> properties, GeodeticDatum datum, CartesianCS cs) {
        this(properties, datum, null, cs);
    }

    @Deprecated(since="1.5", forRemoval=true)
    public DefaultGeocentricCRS(Map<String, ?> properties, GeodeticDatum datum, SphericalCS cs) {
        this(properties, datum, null, cs);
    }

    private DefaultGeocentricCRS(DefaultGeocentricCRS original, AbstractCS cs) {
        super(original, (ReferenceIdentifier)null, cs);
    }

    protected DefaultGeocentricCRS(GeodeticCRS crs) {
        super(crs);
        CoordinateSystem cs = super.getCoordinateSystem();
        if (cs instanceof CartesianCS) {
            ArgumentChecks.ensureDimensionMatches((String)"crs.coordinateSystem", (int)3, (CoordinateSystem)cs);
        } else if (!(cs instanceof SphericalCS)) {
            throw DefaultGeocentricCRS.illegalCoordinateSystemType(cs);
        }
        DefaultGeocentricCRS.checkDimension(2, 3, cs);
    }

    public static DefaultGeocentricCRS castOrCopy(GeodeticCRS object) {
        return object == null || object instanceof DefaultGeocentricCRS ? (DefaultGeocentricCRS)object : new DefaultGeocentricCRS(object);
    }

    @Override
    public Class<? extends GeocentricCRS> getInterface() {
        return GeocentricCRS.class;
    }

    @Override
    public final GeodeticDatum getDatum() {
        return super.getDatum();
    }

    @Override
    public DefaultDatumEnsemble<GeodeticDatum> getDatumEnsemble() {
        return super.getDatumEnsemble();
    }

    @Override
    public DefaultGeocentricCRS forConvention(AxesConvention convention) {
        return (DefaultGeocentricCRS)super.forConvention(convention);
    }

    @Override
    final AbstractCRS createSameType(AbstractCS cs) {
        return new DefaultGeocentricCRS(this, cs);
    }

    @Override
    protected String formatTo(Formatter formatter) {
        return super.formatTo(formatter);
    }

    private DefaultGeocentricCRS() {
    }
}

